/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.util.NotationExtendedMetaData;

public class DiagramIOUtilClone {
    private static String UNABLE_TO_LOAD_DIAGRAM = Messages.UnableToLoadResource;
    private static String NO_DIAGRAM_IN_RESOURCE = Messages.NoDiagramInResource;

    public static boolean hasUnrecognizedData(Resource resource) {
        return false;
    }

    public static Diagram load(TransactionalEditingDomain domain, IFile file, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        FileLoader loader = new FileLoader(file);
        return DiagramIOUtilClone.load(domain, loader, bTryCompatible, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Diagram load(TransactionalEditingDomain domain, ILoader loader, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        Resource notationModel = null;
        try {
            EObject rootElement;
            try {
                notationModel = loader.load(domain, new HashMap<String, Object>(), monitor);
            }
            catch (Resource.IOWrappedException e) {
                Throwable exc;
                if (!bTryCompatible) throw e;
                Throwable causeError = e.getCause();
                if (causeError == null) {
                    causeError = e;
                }
                String errMsg = causeError.getLocalizedMessage();
                if (causeError instanceof Resource.IOWrappedException && (exc = ((Resource.IOWrappedException)causeError).getCause()) != null) {
                    causeError = exc;
                }
                if (!(causeError instanceof PackageNotFoundException) && !(causeError instanceof ClassNotFoundException)) {
                    if (!(causeError instanceof FeatureNotFoundException)) throw new CoreException((IStatus)new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 4, UNABLE_TO_LOAD_DIAGRAM, causeError));
                }
                if (!DiagramIOUtilClone.shouldLoadInCompatibilityMode(errMsg)) return null;
                HashMap<String, Object> loadOptions = new HashMap<String, Object>();
                loadOptions.put("EXTENDED_META_DATA", new NotationExtendedMetaData());
                loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                notationModel = loader.load(domain, loadOptions, monitor);
            }
            if (notationModel == null) {
                throw new RuntimeException(UNABLE_TO_LOAD_DIAGRAM);
            }
            Iterator rootContents = notationModel.getContents().iterator();
            do {
                if (rootContents.hasNext()) continue;
                throw new RuntimeException(NO_DIAGRAM_IN_RESOURCE);
            } while (!((rootElement = (EObject)rootContents.next()) instanceof Diagram));
            return (Diagram)rootElement;
        }
        catch (Exception e) {
            CoreException thrownExcp = null;
            if (e instanceof CoreException) {
                thrownExcp = (CoreException)e;
                throw thrownExcp;
            }
            thrownExcp = new CoreException((IStatus)new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 4, e.getMessage(), (Throwable)e));
            throw thrownExcp;
        }
    }

    public static Diagram load(TransactionalEditingDomain domain, IStorage storage, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        ILoader loader = null;
        loader = storage instanceof IFile ? new FileLoader((IFile)storage) : new StorageLoader(storage);
        return DiagramIOUtilClone.load(domain, loader, bTryCompatible, monitor);
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, boolean bKeepUnrecognizedData, IProgressMonitor progressMonitor) throws CoreException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (bKeepUnrecognizedData) {
            options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        DiagramIOUtilClone.save(domain, file, diagram, progressMonitor, options);
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, IProgressMonitor progressMonitor) throws CoreException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        DiagramIOUtilClone.save(domain, file, diagram, progressMonitor, options);
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, IProgressMonitor progressMonitor, Map<String, Boolean> options) throws CoreException {
        Resource notationModel = diagram.eResource();
        String fileName = file.getFullPath().toOSString();
        notationModel.setURI(URI.createPlatformResourceURI((String)fileName, (boolean)true));
        try {
            notationModel.save(options);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 4, e.getLocalizedMessage(), null));
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private static boolean shouldLoadInCompatibilityMode(String errMsg) {
        return false;
    }

    public static void unload(TransactionalEditingDomain domain, Diagram diagram) {
        diagram.eResource().unload();
    }

    private static class FileLoader
    implements ILoader {
        private IFile fFile;

        public FileLoader(IFile file) {
            assert (file != null);
            this.fFile = file;
        }

        @Override
        public Resource load(TransactionalEditingDomain domain, Map<String, Object> loadOptions, IProgressMonitor monitor) throws IOException, CoreException {
            this.fFile.refreshLocal(0, monitor);
            URI uri = URI.createPlatformResourceURI((String)this.fFile.getFullPath().toString(), (boolean)true);
            Resource resource = domain.getResourceSet().getResource(uri, false);
            if (resource == null) {
                resource = domain.getResourceSet().createResource(uri);
            }
            if (!resource.isLoaded()) {
                HashMap<String, Object> loadingOptions = new HashMap<String, Object>(GMFResourceFactory.getDefaultLoadOptions());
                for (String key : loadOptions.keySet()) {
                    loadingOptions.put(key, loadOptions.get(key));
                }
                try {
                    resource.load(loadingOptions);
                }
                catch (IOException e) {
                    resource.unload();
                    throw e;
                }
            }
            return resource;
        }
    }

    private static interface ILoader {
        public Resource load(TransactionalEditingDomain var1, Map<String, Object> var2, IProgressMonitor var3) throws IOException, CoreException;
    }

    private static class StorageLoader
    implements ILoader {
        private IStorage fStorage;

        public StorageLoader(IStorage storage) {
            assert (storage != null);
            this.fStorage = storage;
        }

        @Override
        public Resource load(TransactionalEditingDomain editingDomain, Map<String, Object> loadOptions, IProgressMonitor monitor) throws IOException, CoreException {
            String storagePath = this.fStorage.getFullPath().toString();
            Resource resource = editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)storagePath, (boolean)true), true);
            return resource;
        }
    }
}

