/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.figures;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Toggle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Image;

public final class GMFCheckBox
extends Toggle {
    private WrappingLabel label = null;
    static final Image UNCHECKED = GMFCheckBox.createImage("checkboxoff.gif");
    static final Image CHECKED = GMFCheckBox.createImage("checkboxon.gif");

    public GMFCheckBox() {
        this("");
    }

    public GMFCheckBox(String text) {
        this.label = new WrappingLabel(text, UNCHECKED);
        this.setContents((IFigure)this.label);
        this.setFocusTraversable(false);
        this.setRequestFocusEnabled(false);
    }

    private static Image createImage(String name) {
        InputStream stream = GMFCheckBox.class.getResourceAsStream(name);
        Image image = new Image(null, stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return image;
    }

    public WrappingLabel getLabel() {
        return this.label;
    }

    protected void handleSelectionChanged() {
        if (this.isSelected()) {
            this.label.setIcon(CHECKED);
        } else {
            this.label.setIcon(UNCHECKED);
        }
    }

    protected void init() {
        super.init();
        this.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getPropertyName().equals("selected")) {
                    GMFCheckBox.this.handleSelectionChanged();
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void setText(String text) {
        if (this.label != null && this.label.getText() != text) {
            this.label.setText(text);
            this.repaint();
        }
    }
}

