/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.dialogs;

import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class TypedElementSelectionValidator
implements ISelectionStatusValidator {
    private IStatus fgErrorStatus = new Status(4, WebUIPlugin.getDefault().getBundle().getSymbolicName(), -1, "", null);
    private IStatus fgOKStatus = Status.OK_STATUS;
    private Class[] fAcceptedTypes;
    private boolean fAllowMultipleSelection;
    private Collection fRejectedElements;

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
        this(acceptedTypes, allowMultipleSelection, null);
    }

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection, Collection rejectedElements) {
        Assert.isNotNull((Object)acceptedTypes);
        this.fAcceptedTypes = acceptedTypes;
        this.fAllowMultipleSelection = allowMultipleSelection;
        this.fRejectedElements = rejectedElements;
    }

    private boolean isOfAcceptedType(Object o) {
        int i = 0;
        while (i < this.fAcceptedTypes.length) {
            if (this.fAcceptedTypes[i].isInstance(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRejectedElement(Object elem) {
        return this.fRejectedElements != null && this.fRejectedElements.contains(elem);
    }

    protected boolean isSelectedValid(Object elem) {
        return true;
    }

    private boolean isValid(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            Object o = selection[i];
            if (!this.isOfAcceptedType(o) || this.isRejectedElement(o) || !this.isSelectedValid(o)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IStatus validate(Object[] elements) {
        if (this.isValid(elements)) {
            return this.fgOKStatus;
        }
        return this.fgErrorStatus;
    }
}

