/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.dialogs;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.dialogs.EmptyFolderFilter;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.webpage.wizard.NewWebPageWizard;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class SelectWebPageTreeDialog
extends SelectionDialog {
    private TreeViewer viewer;
    private IProject project;
    private IFile selectedWebPage = null;
    private String nodeName = "";

    public SelectWebPageTreeDialog(Shell parentShell, MNode node) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        IFile file = WebProvider.getFileForNode((MNode)node);
        if (file != null) {
            this.project = file.getProject();
        }
        this.nodeName = file != null && !file.exists() ? file.getName() : "";
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.SelectWebPageTreeDialog_1);
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        composite.setLayoutData((Object)gd);
        Label text = new Label(composite, 16384);
        text.setText(Messages.SelectWebPageTreeDialog_2);
        Composite col2 = new Composite(composite, 0);
        col2.setLayout((Layout)new GridLayout());
        col2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(col2);
        gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.numColumns = 2;
        col2.setLayout((Layout)gl);
        GridData data = new GridData(1808);
        data.heightHint = 75;
        data.widthHint = 300;
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.addFilter((ViewerFilter)new EmptyFolderFilter());
        this.viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IFile) {
                    return 1;
                }
                return 0;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button okButton;
                ISelection selection = SelectWebPageTreeDialog.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (okButton = SelectWebPageTreeDialog.this.getButton(0)) != null) {
                    Object selectedObj = ((IStructuredSelection)selection).getFirstElement();
                    if (selectedObj != null && selectedObj instanceof IFile) {
                        okButton.setEnabled(true);
                        SelectWebPageTreeDialog.this.selectedWebPage = (IFile)selectedObj;
                    } else {
                        okButton.setEnabled(false);
                        SelectWebPageTreeDialog.this.selectedWebPage = null;
                    }
                }
            }
        });
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)this.project);
        this.setResult(Arrays.asList(this.viewer.getSelection()));
        Button b = new Button(col2, 8);
        b.setText(Messages.SelectWebPageTreeDialog_3);
        b.setLayoutData((Object)new GridData(1, 1, false, false));
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IDataModel dataModel = DataModelFactory.createDataModel((String)"com.ibm.etools.webtools.webpage.core.WebPageCreationDataModelProvider");
                dataModel.setProperty("IWebPageDataModelProperties.FILE_NAME", (Object)SelectWebPageTreeDialog.this.nodeName);
                dataModel.setProperty("IWebPageCreationDataModelProperties.PROJECT", (Object)SelectWebPageTreeDialog.this.project);
                DataModelPropertyDescriptor[] templateDescs = dataModel.getValidPropertyDescriptors("IWebPageDataModelProperties.TEMPLATE");
                IFacetedProject fp = ProjectFacetUtil.getFacetedProject((IProject)SelectWebPageTreeDialog.this.project);
                boolean isPortlet = false;
                if (fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"jsr.base")) || fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"ibmportlet.base"))) {
                    isPortlet = true;
                }
                int i = 0;
                while (i < templateDescs.length) {
                    ITemplateDescriptor templateDescriptor = (ITemplateDescriptor)templateDescs[i].getPropertyValue();
                    if (isPortlet) {
                        if ("com.ibm.etools.portlet.jsp.BasicPortletJSPTemplate".equals(templateDescriptor.getID())) {
                            dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                            break;
                        }
                    } else if ("com.ibm.etools.webtools.webpage.BasicJSPTemplate".equals(templateDescriptor.getID())) {
                        dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                        break;
                    }
                    ++i;
                }
                NewWebPageWizard wizard = new NewWebPageWizard(dataModel);
                wizard.setOpenEditorAfterCreation(false);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    SelectWebPageTreeDialog.this.viewer.refresh();
                    String fileName = dataModel.getStringProperty("IWebPageDataModelProperties.FILE_NAME");
                    String folderName = dataModel.getStringProperty("IWebPageCreationDataModelProperties.FOLDER");
                    Path path = new Path(folderName);
                    path = path.append(fileName);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    StructuredSelection s = new StructuredSelection((Object)file);
                    SelectWebPageTreeDialog.this.viewer.setSelection((ISelection)s, true);
                }
                Debug.noop();
            }
        });
        return composite;
    }

    public Object[] getResult() {
        if (this.selectedWebPage != null) {
            return new Object[]{this.selectedWebPage};
        }
        return new Object[0];
    }
}

