/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.actions;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.requests.CreateExistingElementRequest;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineerConstants;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineeringService;
import com.ibm.etools.diagram.model.internal.services.TypeGeneratorService;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

final class ReverseEngineerCommand
extends AbstractTransactionalCommand
implements IWorkspaceLockMarker {
    private final MDiagram diagram;

    public ReverseEngineerCommand(TransactionalEditingDomain domain, String label, Map options, List affectedFiles, MDiagram diagram, PreferencesHint preferencesHint, IGraphicalEditPart diagramEditPart) {
        super(domain, label, options, affectedFiles);
        this.diagram = diagram;
    }

    public boolean canUndo() {
        return super.canUndo();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        progressMonitor.beginTask("", 10000);
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.diagram.eResource());
        if (file != null) {
            IElementType webDiagramType = this.diagram.getElementType();
            IProject project = file.getProject();
            HashMap<Object, Boolean> options = new HashMap<Object, Boolean>();
            options.put("use defaults", Boolean.TRUE);
            options.put(ReverseEngineerConstants.REVERSE_ENGINEERING, Boolean.TRUE);
            options.put(ReverseEngineerConstants.DIAGRAM_NODE, (Boolean)this.diagram);
            SubProgressMonitor gatherMonitor = new SubProgressMonitor(progressMonitor, 2000);
            gatherMonitor.beginTask("", 2);
            gatherMonitor.subTask(Messages.GatheringResources);
            Collection adaptables = ReverseEngineeringService.getInstance().getNodeAdapters(project, options, (Collection)this.diagram.getNodes());
            gatherMonitor.worked(1);
            adaptables = ReverseEngineeringService.getInstance().filterNodeAdapters(project, options, Collections.unmodifiableCollection(adaptables));
            SubProgressMonitor createNodeRequests = new SubProgressMonitor((IProgressMonitor)gatherMonitor, 1);
            createNodeRequests.beginTask("", adaptables.size());
            CompositeCommand createNodesCommand = new CompositeCommand(Messages.CreatingNodes);
            Iterator iter = adaptables.iterator();
            while (iter.hasNext()) {
                createNodeRequests.worked(1);
                Object adaptable = iter.next();
                IElementType typeToCreate = TypeGeneratorService.getInstance().getElementType(adaptable);
                if (typeToCreate != null) {
                    CreateExistingElementRequest request = new CreateExistingElementRequest(adaptable, (EObject)this.diagram, typeToCreate);
                    request.setParameter("existing from adapter", adaptable);
                    request.setParameter("configure phase", (Object)"nodePhase");
                    request.addParameters(options);
                    ICommand cmd = webDiagramType.getEditCommand((IEditCommandRequest)request);
                    createNodesCommand.add((IUndoableOperation)cmd);
                }
                if (!progressMonitor.isCanceled()) continue;
                return CommandResult.newCancelledCommandResult();
            }
            createNodeRequests.done();
            gatherMonitor.done();
            progressMonitor.subTask(Messages.CreatingNodes);
            SubProgressMonitor createNodesMonitor = new SubProgressMonitor(progressMonitor, 2000);
            createNodesCommand.execute((IProgressMonitor)createNodesMonitor, info);
            if (!createNodesCommand.getCommandResult().getStatus().isOK()) {
                return createNodesCommand.getCommandResult();
            }
            EList allNodes = this.diagram.getNodes();
            CompositeCommand createEdgeCommands = new CompositeCommand(Messages.CreatingEdges);
            for (MNode node : allNodes) {
                IElementType type = node.getElementType();
                ConfigureRequest request = new ConfigureRequest((EObject)node, type);
                request.setParameter("configure phase", (Object)"edgePhase");
                request.addParameters(options);
                ICommand configCmd = webDiagramType.getEditCommand((IEditCommandRequest)request);
                createEdgeCommands.compose((IUndoableOperation)configCmd);
                if (!progressMonitor.isCanceled()) continue;
                return CommandResult.newCancelledCommandResult();
            }
            progressMonitor.subTask(Messages.CreatingEdges);
            SubProgressMonitor createEdgesMonitor = new SubProgressMonitor(progressMonitor, 6000);
            createEdgeCommands.execute((IProgressMonitor)createEdgesMonitor, info);
            if (!createEdgeCommands.getCommandResult().getStatus().isOK()) {
                return createEdgeCommands.getCommandResult();
            }
            progressMonitor.subTask(Messages.CreatingViews);
        }
        progressMonitor.done();
        return CommandResult.newOKCommandResult();
    }
}

