/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.actions;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.internal.l10n.CommonCoreMessages;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.osgi.util.NLS;

public class FixCompositeCommand
extends CompositeCommand {
    public FixCompositeCommand(String label) {
        super(label);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator iter = this.listIterator();
            while (iter.hasNext()) {
                IUndoableOperation next = (IUndoableOperation)iter.next();
                try {
                    IStatus status = next.execute((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        Trace.trace((Plugin)CommonCorePlugin.getDefault(), (String)"Composite operation execution recovery: child command status is CANCEL or ERROR.");
                        iter.previous();
                        this.unwindFailedExecute(iter, info);
                    } else {
                        if (!progressMonitor.isCanceled()) continue;
                        Trace.trace((Plugin)CommonCorePlugin.getDefault(), (String)"Composite operation redo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedExecute(iter, info);
                    }
                    break;
                }
                catch (ExecutionException e) {
                    iter.previous();
                    this.unwindFailedExecute(iter, info);
                    Trace.throwing((Plugin)CommonCorePlugin.getDefault(), (String)CommonCoreDebugOptions.EXCEPTIONS_THROWING, CompositeCommand.class, (String)"execute", (Throwable)e);
                    throw e;
                }
            }
        }
        finally {
            progressMonitor.done();
        }
        return new CommandResult(this.aggregateStatuses(result), (Object)this.getReturnValues());
    }

    private void unwindFailedExecute(ListIterator iter, IAdaptable info) {
        while (iter.hasPrevious()) {
            IUndoableOperation prev = (IUndoableOperation)iter.previous();
            if (!prev.canUndo()) {
                Log.error((Plugin)CommonCorePlugin.getDefault(), (int)20, (String)NLS.bind((String)CommonCoreMessages.executeRecoveryFailed, (Object)CommonCoreMessages.cannotUndoExecuted));
                break;
            }
            try {
                prev.undo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                Log.error((Plugin)CommonCorePlugin.getDefault(), (int)20, (String)NLS.bind((String)CommonCoreMessages.executeRecoveryFailed, (Object)inner.getLocalizedMessage()));
                break;
            }
        }
    }
}

