/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.actions;

import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;

public class ArrangeNewEditPartsCommand
extends AbstractCommand {
    private final IGraphicalEditPart diagramEditPart;
    private final List<EditPart> snapshot;
    private final List selectedEditParts;
    private Command layoutCmd;
    private boolean arrangeAll = false;

    public ArrangeNewEditPartsCommand(MDiagram diagram, PreferencesHint hint, IGraphicalEditPart diagramEditPart, List selectedEditParts) {
        super(Messages.ArrangeNodes);
        this.selectedEditParts = selectedEditParts;
        this.snapshot = new ArrayList<EditPart>(diagramEditPart.getChildren());
        this.diagramEditPart = diagramEditPart;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        progressMonitor.beginTask("", 2);
        progressMonitor.subTask(Messages.ArrangeNodes);
        ArrayList currentEditParts = new ArrayList(this.diagramEditPart.getChildren());
        if (!this.arrangeAll) {
            currentEditParts.removeAll(this.snapshot);
            currentEditParts.addAll(this.selectedEditParts);
        }
        ArrangeRequest request = new ArrangeRequest(this.arrangeAll ? "arrangeAllAction" : "arrangeSelectionAction", "DEFAULT");
        if (!this.arrangeAll) {
            request.setPartsToArrange(currentEditParts);
        }
        this.layoutCmd = this.diagramEditPart.getCommand((Request)request);
        progressMonitor.worked(1);
        if (this.layoutCmd != null && this.layoutCmd.canExecute()) {
            this.layoutCmd.execute();
        }
        progressMonitor.worked(1);
        progressMonitor.done();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.doExecuteWithResult(progressMonitor, info);
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }

    public void setArrangeAll(boolean arrangeAll) {
        this.arrangeAll = arrangeAll;
    }
}

