/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.nodes;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigFactory;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.osgi.framework.Bundle;

public class CreateActionMappingResourceCommand
extends ResourceModificationCommand {
    private String actionClass = "Action";
    private IFile actionMappingClassFile = null;
    private StrutsChangeCommand changeCommand;
    private String imports = "import javax.servlet.http.HttpServletRequest;" + System.getProperties().getProperty("line.separator") + "import javax.servlet.http.HttpServletResponse;" + System.getProperties().getProperty("line.separator") + "import org.apache.struts.action.Action;";
    private String methodSignature = "ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response";
    private final MNode node;
    private String saveErrorsMethodCall = "saveErrors(request, errors);";

    public CreateActionMappingResourceCommand(MNode node) {
        super(Messages.CreateAction);
        this.node = node;
    }

    private boolean actionTypeExists(String type, IProject project) {
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IType iType = jp.findType(type);
            return iType != null && iType.exists();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void createActionClass(String type, IProject project, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IStatus typeValidStatus = JavaConventions.validateJavaTypeName((String)type, (String)StrutsProjectCoreUtil.getJavaVersion((IProject)project), (String)StrutsProjectCoreUtil.getJavaVersion((IProject)project));
        if (typeValidStatus.getSeverity() == 0 || typeValidStatus.getSeverity() == 2) {
            monitor.subTask(Messages.CreatingActionClass);
            IFolder folder = Model2Util.getSourceFolder((IProject)project);
            IJavaElement rootElement = JavaCore.create((IFolder)folder);
            if (rootElement instanceof IPackageFragmentRoot) {
                sub.worked(1);
                IPackageFragmentRoot root = (IPackageFragmentRoot)rootElement;
                try {
                    String actionCUName = this.getActionClassFromFullyQualifiedType(type);
                    String pkg = this.getActionPackageFromFullyQualifiedType(type);
                    IPackageFragment fragment = root.createPackageFragment(pkg, false, (IProgressMonitor)sub.newChild(1));
                    this.setPortalSpecificStrings(project);
                    if (!fragment.getCompilationUnit(String.valueOf(actionCUName) + ".java").exists()) {
                        String template = this.readTemplateFile();
                        sub.worked(1);
                        template = template.replaceFirst("\\{\\$saveErrorsMethodCall\\}", this.saveErrorsMethodCall);
                        template = template.replaceFirst("\\{\\$actionClass\\}", this.actionClass);
                        template = template.replaceFirst("\\{\\$imports\\}", this.imports);
                        template = template.replaceFirst("\\{\\$methodSignature\\}", this.methodSignature);
                        template = template.replaceFirst("\\{\\$action\\}", actionCUName);
                        template = "".equals(pkg) ? template.replaceFirst("\\{\\$package\\}", pkg) : template.replaceFirst("\\{\\$package\\}", "package " + pkg + ";");
                        template = template.replaceFirst("\\{\\$success\\}", Messages.Success);
                        template = template.replaceFirst("\\{\\$failure\\}", Messages.Failure);
                        ICompilationUnit compUnit = fragment.createCompilationUnit(String.valueOf(actionCUName) + ".java", template, false, (IProgressMonitor)sub.newChild(1));
                        this.actionMappingClassFile = (IFile)compUnit.getResource();
                    }
                }
                catch (JavaModelException e) {
                    DiagramStrutsPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
        }
        sub.done();
        if (monitor != null) {
            monitor.done();
        }
    }

    private CommandResult createActionMapping(IProgressMonitor monitor) {
        final SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)9);
        monitor.subTask(Messages.CreatingStrutsAction);
        final IVirtualComponent component = WebProvider.getVirtualComponent((EObject)this.getNode());
        IFile strutsConfig = this.getFileToModify();
        if (strutsConfig != null) {
            sub.worked(1);
            try {
                StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

                    @Override
                    protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                        IProject project = component.getProject();
                        ActionMapping matchingMapping = null;
                        ActionMappingWildcardUtil matchingWCUtil = null;
                        String actionPath = WebProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)CreateActionMappingResourceCommand.this.getNode());
                        if (actionPath == null) {
                            return true;
                        }
                        String module = StrutsLinksSearchUtil.getStrutsModule((EObject)strutsConfig, (IProgressMonitor)sub.newChild(1));
                        ILink actionLink = StrutsSearchUtil.getActionMappingLink((IProject)project, (String)actionPath, (String)module, (IProgressMonitor)sub.newChild(1));
                        if (actionLink != null) {
                            matchingWCUtil = new ActionMappingWildcardUtil(actionLink.getContainer().getResource().getProject(), actionLink.getName());
                            matchingMapping = (ActionMapping)StrutsLinksSearchUtil.getCorrespondingEObject((EClass)StrutsconfigPackage.eINSTANCE.getActionMapping(), (EObject)strutsConfig, (ILink)actionLink);
                        }
                        sub.worked(1);
                        String type = "";
                        if (matchingMapping == null || matchingWCUtil == null) {
                            matchingMapping = StrutsconfigFactory.eINSTANCE.createActionMapping();
                            type = CreateActionMappingResourceCommand.this.getDefaultActionClassType(actionPath, project);
                            matchingMapping.setPath(actionPath);
                            matchingMapping.setType(type);
                            strutsConfig.getActionMappings().add((Object)matchingMapping);
                        } else {
                            boolean useType;
                            boolean bl = useType = !matchingMapping.isSetForward() && !matchingMapping.isSetInclude();
                            if (useType) {
                                if (!matchingMapping.isSetType() || "".equals(matchingMapping.getType())) {
                                    type = CreateActionMappingResourceCommand.this.getDefaultActionClassType(actionPath, project);
                                    matchingMapping.setType(type);
                                } else {
                                    type = matchingMapping.getType();
                                    if (matchingWCUtil.attributeHasTokens(type)) {
                                        if (matchingWCUtil.isAttributeTokenUseValid(type)) {
                                            type = matchingWCUtil.getConcreteAttributeValue(matchingMapping.getType(), actionPath);
                                        }
                                    } else {
                                        type = matchingMapping.getType();
                                    }
                                }
                            }
                        }
                        sub.worked(1);
                        if (!CreateActionMappingResourceCommand.this.actionTypeExists(type, project)) {
                            CreateActionMappingResourceCommand.this.createActionClass(type, project, (IProgressMonitor)sub.newChild(5));
                        }
                        sub.done();
                        return true;
                    }
                };
                this.changeCommand = StrutsChangeCommand.getStrutsCommand(this.getFileToModify(), changes, true);
                this.changeCommand.execute();
            }
            finally {
                monitor.done();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        super.dispose();
        if (this.changeCommand != null) {
            this.changeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Creating action", (int)1);
        CommandResult result = this.createActionMapping((IProgressMonitor)sub.newChild(1));
        if (!result.getStatus().isOK()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.Error, (String)Messages.CouldNotCreateActionEntryInStrutsConfig);
                }
            });
            sub.setCanceled(true);
            progressMonitor.done();
            return CommandResult.newCancelledCommandResult();
        }
        if (!StrutsProvider.isActionInDiagramModule(this.node)) {
            EList compartments = this.node.getCompartments();
            Iterator iter = compartments.iterator();
            while (iter.hasNext()) {
                Compartment c = (Compartment)iter.next();
                if (!"com.ibm.etools.model2.diagram.struts.ForwardsCompartment".equals(c.getType()) && !"com.ibm.etools.model2.diagram.web.DataCompartment".equals(c.getType())) continue;
                iter.remove();
            }
        } else {
            EList inputs = this.node.getInput();
            for (MEdge edge : inputs) {
                edge.refreshRealization();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.changeCommand != null) {
            this.changeCommand.redo();
        }
        if (this.actionMappingClassFile != null) {
            try {
                IFileState[] state = this.actionMappingClassFile.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.actionMappingClassFile.create(state[0].getContents(), false, progressMonitor);
                }
            }
            catch (CoreException e) {
                DiagramStrutsPlugin.getLogger().log((Throwable)e);
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.changeCommand != null && this.changeCommand.canUndo()) {
            this.changeCommand.undo();
        }
        if (this.actionMappingClassFile != null && this.actionMappingClassFile.exists()) {
            try {
                this.actionMappingClassFile.delete(false, true, progressMonitor);
            }
            catch (CoreException e) {
                DiagramStrutsPlugin.getLogger().log((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    private String getActionClassFromFullyQualifiedType(String type) {
        String[] segments = type.split("\\.");
        if (segments.length > 0) {
            return segments[segments.length - 1];
        }
        return "";
    }

    public String getActionFromPath(String path) {
        return String.valueOf(JavaCodeUtil.capitalizeFirst((String)JavaCodeUtil.legalizeJavaIdentifier((String)path))) + "Action";
    }

    private String getActionPackageFromFullyQualifiedType(String type) {
        String[] segments = type.split("\\.");
        StringBuilder builder = new StringBuilder();
        if (segments.length > 1) {
            int i = 0;
            while (i < segments.length - 1) {
                String s = segments[i];
                builder.append(s);
                if (i == segments.length - 2) break;
                builder.append(".");
                ++i;
            }
        }
        return builder.toString();
    }

    private String getDefaultActionClassType(String actionPath, IProject project) {
        String noFirstSlash = actionPath.replaceFirst("/", "");
        String actionCUName = this.getActionFromPath(noFirstSlash);
        String pkg = this.getDefaultActionPackageName(Model2Util.findComponent((IResource)project));
        return String.valueOf(pkg) + "." + actionCUName;
    }

    public String getDefaultActionPackageName(IVirtualComponent component) {
        String pkg = Model2ProjectPropertyUtils.getPackagePrefix((IProject)component.getProject());
        String module = StrutsProvider.getModuleName((CommonElement)this.node);
        if (module != null && module.length() > 0) {
            module = module.replace('/', '.');
            pkg = String.valueOf(pkg) + module;
        }
        pkg = String.valueOf(pkg) + ".actions";
        return pkg;
    }

    protected IFile getFileToModify() {
        Set links;
        IProject project = WebProvider.getProjectForElement((CommonElement)this.node);
        String module = StrutsProvider.getModuleName((CommonElement)this.node.getParent());
        try {
            links = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)project, (String)module, null);
        }
        catch (ReferenceException referenceException) {
            links = Collections.emptySet();
        }
        if (!links.isEmpty()) {
            return (IFile)((ILink)links.iterator().next()).getContainer().getResource();
        }
        return null;
    }

    private MNode getNode() {
        return this.node;
    }

    protected String readTemplateFile() {
        StringBuffer typeTemplate;
        block5: {
            typeTemplate = new StringBuffer();
            try {
                int prjVersion = StrutsProjectCoreUtil.getStrutsVersion((IProject)this.getFileToModify().getProject());
                InputStream is = prjVersion == 2 || prjVersion == 3 ? FileLocator.openStream((Bundle)DiagramStrutsPlugin.getDefault().getBundle(), (IPath)new Path("templates/actionMappingDefaultClass_1_2_1_3.template"), (boolean)false) : FileLocator.openStream((Bundle)DiagramStrutsPlugin.getDefault().getBundle(), (IPath)new Path("templates/actionMappingDefaultClass.template"), (boolean)false);
                if (is == null) break block5;
                byte[] buffer = new byte[1024];
                int read = 0;
                try {
                    while ((read = is.read(buffer, 0, 1024)) >= 0) {
                        typeTemplate.append(new String(buffer, 0, read));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException iOException) {}
        }
        return typeTemplate.toString();
    }

    private void setPortalSpecificStrings(IProject project) {
        IFacetedProject fp = ProjectFacetUtil.getFacetedProject((IProject)project);
        if (fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"jsr168.base"))) {
            this.imports = "import javax.portlet.PortletRequest;" + System.getProperties().getProperty("line.separator") + "import javax.portlet.PortletResponse;" + System.getProperties().getProperty("line.separator") + "import com.ibm.portal.struts.action.StrutsAction;";
            this.methodSignature = "ActionMapping mapping, ActionForm form, PortletRequest request, PortletResponse response";
            this.actionClass = "StrutsAction";
            this.saveErrorsMethodCall = "";
        } else if (fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"ibmportlet.base"))) {
            this.imports = "import org.apache.jetspeed.portlet.PortletRequest;" + System.getProperties().getProperty("line.separator") + "import com.ibm.wps.struts.action.StrutsAction;";
            this.methodSignature = "ActionMapping mapping, ActionForm form, PortletRequest request";
            this.actionClass = "StrutsAction";
            this.saveErrorsMethodCall = "";
        } else {
            this.actionClass = "Action";
            this.saveErrorsMethodCall = "saveErrors(request, errors);";
        }
    }
}

