/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;

public class UpdateForwardPathResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private IFile file;
    private final IAdaptable forwardHandle;
    private final List<?> resourceToDelete;
    private StrutsChangeCommand strutsChangeCommand;
    private String targetPath;
    private final String targetModule;

    public UpdateForwardPathResourceCommand(IAdaptable forwardAdaptable, String targetPath, String targetModule, List<?> resourceToDelete) {
        super(Messages.UpdateForward);
        this.forwardHandle = forwardAdaptable;
        this.targetPath = targetPath;
        this.resourceToDelete = resourceToDelete;
        this.targetModule = targetModule;
        this.fixTargetPath();
    }

    public UpdateForwardPathResourceCommand(IFile file, IAdaptable forwardAdaptable, String targetPath, String targetModule) {
        this(forwardAdaptable, targetPath, targetModule, null);
        this.file = file;
    }

    public void dispose() {
        super.dispose();
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        final ILink handle = this.getForwardHandle();
        boolean removeReferences = "".equals(this.targetPath);
        if (this.resourceToDelete == null && removeReferences) {
            return CommandResult.newOKCommandResult();
        }
        if ((!removeReferences || this.resourceToDelete.contains(this.getForwardHandle())) && handle != null) {
            StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

                @Override
                protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                    Forward forward = (Forward)StrutsLinksSearchUtil.getCorrespondingEObject((EClass)StrutsconfigPackage.eINSTANCE.getForward(), (EObject)strutsConfig, (ILink)handle);
                    ILink forwardLink = (ILink)UpdateForwardPathResourceCommand.this.forwardHandle.getAdapter(ILink.class);
                    String forwardModule = StrutsSearchUtil.getModuleForILink((ILink)forwardLink, null);
                    if (forward != null) {
                        boolean crossModuleForward = forwardModule != null && UpdateForwardPathResourceCommand.this.targetModule != null && !forwardModule.equals(UpdateForwardPathResourceCommand.this.targetModule);
                        boolean canUpdateForward = true;
                        EObject parent = forward.eContainer();
                        if (parent instanceof ActionMapping) {
                            String path = ((ActionMapping)parent).getPath();
                            ActionMappingWildcardUtil wcu = new ActionMappingWildcardUtil(forwardLink.getContainer().getResource().getProject(), path);
                            if (wcu.actionHasWildcards() && forward.isSetPath() && !"".equals(forward.getPath())) {
                                canUpdateForward = false;
                            }
                        }
                        if (canUpdateForward) {
                            if (crossModuleForward) {
                                if (StrutsProjectCoreUtil.isStruts1_1((IProject)UpdateForwardPathResourceCommand.this.getFileToModify().getProject())) {
                                    forward.setPath(String.valueOf(UpdateForwardPathResourceCommand.this.targetModule) + UpdateForwardPathResourceCommand.this.targetPath);
                                    forward.setContextRelative(crossModuleForward);
                                    forward.unsetModule();
                                } else {
                                    forward.setPath(UpdateForwardPathResourceCommand.this.targetPath);
                                    if (UpdateForwardPathResourceCommand.this.targetModule != null) {
                                        forward.setModule(UpdateForwardPathResourceCommand.this.targetModule);
                                    }
                                    forward.unsetContextRelative();
                                }
                            } else if (StrutsProjectCoreUtil.isStruts1_1((IProject)UpdateForwardPathResourceCommand.this.getFileToModify().getProject())) {
                                forward.setPath(UpdateForwardPathResourceCommand.this.targetPath);
                                forward.setContextRelative(crossModuleForward);
                                forward.unsetModule();
                            } else {
                                forward.setPath(UpdateForwardPathResourceCommand.this.targetPath);
                                forward.unsetContextRelative();
                                forward.unsetModule();
                            }
                        }
                    }
                    return true;
                }
            };
            this.strutsChangeCommand = StrutsChangeCommand.getStrutsCommand(this.getFileToModify(), changes, true);
            if (this.strutsChangeCommand != null) {
                this.strutsChangeCommand.execute();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null && this.strutsChangeCommand.canUndo()) {
            this.strutsChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected void fixTargetPath() {
        String pathTargetModule;
        ILink forwardLink;
        if (this.targetPath != null && this.targetModule != null && (forwardLink = (ILink)this.forwardHandle.getAdapter(ILink.class)) != null && (pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)forwardLink.getContainer().getResource().getProject(), (String)this.targetPath)).equals(this.targetModule)) {
            this.targetPath = this.targetPath.substring(this.targetModule.length());
        }
    }

    public ResourceTree getDeletionTree() {
        if (this.targetPath.equals("")) {
            ActionMappingWildcardUtil wcu;
            Item item = (Item)this.forwardHandle;
            ILink actionLink = (ILink)item.getNode().getAdapter(ILink.class);
            boolean canUpdate = true;
            if (actionLink != null && (wcu = new ActionMappingWildcardUtil(actionLink.getContainer().getResource().getProject(), actionLink.getName())).actionHasWildcards()) {
                canUpdate = false;
            }
            if (canUpdate) {
                ResourceDescriptor desc = new ResourceDescriptor((Object)this.getForwardHandle());
                desc.setDisplayText(NLS.bind((String)Messages.UpdateFileXRemoveReferenceToX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.getForwardHandle().getLinkText()));
                return new ResourceTree(desc);
            }
        }
        return null;
    }

    protected IFile getFileToModify() {
        ILink handle;
        if (this.file == null && (handle = this.getForwardHandle()) != null) {
            this.file = (IFile)handle.getContainer().getResource();
        }
        return this.file;
    }

    public ILink getForwardHandle() {
        return (ILink)this.forwardHandle.getAdapter(ILink.class);
    }
}

