/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStrutsLinkResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.webtools.model.WebModelCreationException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;

public class DeleteStrutsLinkResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final NodeItem item;
    private IFile file;
    private String oldTargetPath;
    private String oldTargetModule;
    private final List<?> resourcesToDelete;
    private String oldAttribute;
    private final MNode source;

    public DeleteStrutsLinkResourceCommand(NodeItem item, List<?> resourcesToDelete) {
        super(Messages.DeleteStrutsLink);
        this.item = item;
        this.resourcesToDelete = resourcesToDelete;
        this.source = item.getNode();
        this.oldTargetPath = StrutsProvider.getItemTargetPath((Item)item);
        this.oldTargetModule = StrutsProvider.getItemTargetModule((Item)item);
        IProject project = WebProvider.getProjectForElement((CommonElement)item);
        ILink handle = this.getStrutsLinkHandle();
        boolean oldUsesModuleAttribute = handle.getParameter("param.struts.module") != null;
        String oldPathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)item), (String)this.oldTargetPath);
        if (StrutsProjectCoreUtil.isStruts1_1((IProject)project) || !oldUsesModuleAttribute) {
            if (this.oldTargetPath != null && !this.oldTargetModule.equals(oldPathTargetModule)) {
                this.oldTargetPath = String.valueOf(this.oldTargetModule) + this.oldTargetPath;
            }
            this.oldTargetModule = null;
            this.oldTargetModule = null;
        } else if (this.oldTargetPath != null && this.oldTargetModule != null && oldPathTargetModule.equals(this.oldTargetModule)) {
            this.oldTargetPath = this.oldTargetPath.substring(this.oldTargetModule.length());
        }
    }

    private void doDelete() throws ExecutionException, WebModelCreationException, UnsupportedEncodingException, IOException, CoreException, Exception {
        int index = StrutsProvider.calculateItemIndexInCompartmentByType((Item)this.item, true);
        StrutsTargetUtilities.removeStrutsLink(index, this.getFileToModify(), this.oldTargetModule, this.oldTargetPath);
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.resourcesToDelete == null) {
            return CommandResult.newOKCommandResult();
        }
        ILink strutsLink = this.getStrutsLinkHandle();
        boolean found = false;
        for (Object o : this.resourcesToDelete) {
            ILink linkToDelete;
            if (!(o instanceof ILink) || !(linkToDelete = (ILink)o).getLinkText().equals(strutsLink.getLinkText())) continue;
            found = true;
            break;
        }
        if (found) {
            this.oldAttribute = this.getCurrentAttribute();
            try {
                this.doDelete();
            }
            catch (Exception e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        try {
            this.doDelete();
        }
        catch (Exception e) {
            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CreateStrutsLinkResourceCommand cmd = new CreateStrutsLinkResourceCommand(this.source, this.oldAttribute, this.oldTargetPath, this.oldTargetModule, true);
        try {
            cmd.execute(progressMonitor, info);
            if (!cmd.getCommandResult().getStatus().isOK()) {
                CommandResult commandResult = cmd.getCommandResult();
                return commandResult;
            }
        }
        finally {
            cmd.dispose();
        }
        return CommandResult.newOKCommandResult();
    }

    private String getCurrentAttribute() {
        ILink linkHandle = (ILink)this.item.getAdapter(ILink.class);
        if (linkHandle != null) {
            return linkHandle.getParameter("attributeParam");
        }
        return null;
    }

    public ResourceTree getDeletionTree() {
        ResourceDescriptor desc = new ResourceDescriptor((Object)this.getStrutsLinkHandle());
        desc.setDisplayText(NLS.bind((String)Messages.DeleteXinfileX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.oldTargetPath));
        return new ResourceTree(desc);
    }

    protected IFile getFileToModify() {
        if (this.file == null) {
            this.file = WebProvider.getFileForNode((MNode)this.item.getNode());
        }
        return this.file;
    }

    private ILink getStrutsLinkHandle() {
        ILink linkHandle = (ILink)this.item.getAdapter(ILink.class);
        return linkHandle;
    }
}

