/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStrutsFormResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;

public class DeleteStrutsFormResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final NodeItem item;
    private IFile file;
    private String oldPath;
    private final List<?> resourcesToDelete;

    public DeleteStrutsFormResourceCommand(NodeItem item, List<?> resourcesToDelete) {
        super(Messages.DeleteStrutsForm);
        this.item = item;
        this.resourcesToDelete = resourcesToDelete;
    }

    private void doDelete() throws Exception {
        int index = StrutsProvider.calculateItemIndexInCompartmentByType((Item)this.item, true);
        StrutsTargetUtilities.removeStrutsForm(index, this.getFileToModify(), this.oldPath);
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.resourcesToDelete == null) {
            return CommandResult.newOKCommandResult();
        }
        ILink strutsLink = this.getStrutsLinkHandle();
        boolean found = false;
        for (Object o : this.resourcesToDelete) {
            ILink linkToDelete;
            if (!(o instanceof ILink) || !(linkToDelete = (ILink)o).getLinkText().equals(strutsLink.getLinkText())) continue;
            found = true;
            break;
        }
        if (found) {
            this.oldPath = this.getCurrentTarget();
            try {
                this.doDelete();
            }
            catch (Exception e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        try {
            this.doDelete();
        }
        catch (Exception e) {
            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CreateStrutsFormResourceCommand cmd = new CreateStrutsFormResourceCommand(this.getFileToModify(), this.oldPath, true);
        try {
            cmd.execute(progressMonitor, info);
            if (!cmd.getCommandResult().getStatus().isOK()) {
                CommandResult commandResult = cmd.getCommandResult();
                return commandResult;
            }
        }
        finally {
            cmd.dispose();
        }
        return CommandResult.newOKCommandResult();
    }

    private String getCurrentTarget() {
        ILink linkHandle = this.getStrutsLinkHandle();
        if (linkHandle != null) {
            return AbstractWebProvider.trimQuotes((String)linkHandle.getLinkText());
        }
        return null;
    }

    public ResourceTree getDeletionTree() {
        ResourceDescriptor desc = new ResourceDescriptor((Object)this.getStrutsLinkHandle());
        desc.setDisplayText(NLS.bind((String)Messages.DeleteXinfileX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.getCurrentTarget()));
        return new ResourceTree(desc);
    }

    protected IFile getFileToModify() {
        if (this.file == null) {
            this.file = WebProvider.getFileForNode((MNode)this.item.getNode());
        }
        return this.file;
    }

    private ILink getStrutsLinkHandle() {
        ILink linkHandle = (ILink)this.item.getAdapter(ILink.class);
        return linkHandle;
    }
}

