/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;

public class DeleteGlobalExceptionResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private IFile file;
    private final NodeItem globalException;
    private final List<?> resourcesToDelete;
    private StrutsChangeCommand strutsChangeCommand;

    public DeleteGlobalExceptionResourceCommand(NodeItem globalException, List<?> resourcesToDelete) {
        super(Messages.DeleteGlobalException);
        this.globalException = globalException;
        this.resourcesToDelete = resourcesToDelete;
    }

    public void dispose() {
        super.dispose();
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        final ILink handle = this.getExceptionHandle();
        if (this.resourcesToDelete == null) {
            return CommandResult.newOKCommandResult();
        }
        if (this.resourcesToDelete.contains(handle)) {
            StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

                @Override
                protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                    Exception0 mapping = (Exception0)StrutsLinksSearchUtil.getCorrespondingEObject((EClass)StrutsconfigPackage.eINSTANCE.getException0(), (EObject)strutsConfig, (ILink)handle);
                    if (mapping != null) {
                        strutsConfig.getGlobalExceptions().remove((Object)mapping);
                    } else {
                        Debug.noop();
                    }
                    return true;
                }
            };
            this.strutsChangeCommand = StrutsChangeCommand.getStrutsCommand(this.getFileToModify(), changes, true);
            if (this.strutsChangeCommand != null) {
                this.strutsChangeCommand.execute();
            }
        } else {
            Debug.noop();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null && this.strutsChangeCommand.canUndo()) {
            this.strutsChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    public ResourceTree getDeletionTree() {
        ResourceDescriptor desc = new ResourceDescriptor((Object)this.getExceptionHandle());
        desc.setDisplayText(NLS.bind((String)Messages.DeleteXinfileX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.getName()));
        return new ResourceTree(desc);
    }

    protected ILink getExceptionHandle() {
        ILink actionMappingHandle = (ILink)this.globalException.getAdapter(ILink.class);
        return actionMappingHandle;
    }

    protected IFile getFileToModify() {
        ILink handle;
        if (this.file == null && (handle = this.getExceptionHandle()) != null) {
            this.file = (IFile)handle.getContainer().getResource();
        }
        return this.file;
    }

    private String getName() {
        return this.getExceptionHandle().getLinkText();
    }
}

