/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.LinkOrFormElement;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CreateStrutsLinkResourceCommand
extends ResourceModificationCommand {
    private IFile file;
    private final MNode source;
    private MNode target;
    private String attributeName;
    private String targetPath;
    private String targetModule;
    private boolean override;
    private boolean createDups;

    public CreateStrutsLinkResourceCommand(MNode source, MNode target, boolean createDups) {
        super(Messages.CreateStrutsLink);
        this.source = source;
        this.target = target;
        this.createDups = createDups;
    }

    public CreateStrutsLinkResourceCommand(MNode source, String attributeName, String targetPath, String targetModule, boolean createDups) {
        super(Messages.CreateStrutsLink);
        this.source = source;
        this.attributeName = attributeName;
        this.targetPath = targetPath;
        this.targetModule = targetModule;
        this.createDups = createDups;
        this.override = true;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        progressMonitor.beginTask("", 700);
        try {
            if (!this.override) {
                if (this.target != null) {
                    this.targetModule = StrutsProvider.getModuleName((CommonElement)this.target);
                }
                this.targetPath = StrutsTargetUtilities.getTargetNodePath(this.source, this.target);
                this.file = this.getFileToModify();
                if (this.target != null && StrutsProvider.isActionMapping((TypedElement)this.target)) {
                    this.attributeName = "action";
                } else {
                    IFile targetFile = Model2Util.getFile((IVirtualComponent)Model2Util.findComponent((IResource)this.file), (String)this.targetPath);
                    this.targetPath = Model2Util.getDocRootRelativePath((IFile)targetFile).toString();
                    this.attributeName = "page";
                }
                IProject project = WebProvider.getProjectForElement((CommonElement)this.source);
                String pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)this.source), (String)this.targetPath);
                if (StrutsProjectCoreUtil.isStruts1_1((IProject)project)) {
                    if (this.targetPath != null && this.targetModule != null && !this.targetModule.equals(pathTargetModule)) {
                        this.targetPath = String.valueOf(this.targetModule) + this.targetPath;
                    }
                    this.targetModule = null;
                } else if (this.targetPath != null && this.targetModule != null && this.targetModule.equals(pathTargetModule)) {
                    this.targetPath = this.targetPath.substring(this.targetModule.length());
                }
            }
            LinkOrFormElement e = null;
            if (!this.createDups) {
                e = StrutsTargetUtilities.getUntargettedLink(this.getFileToModify(), this.targetModule, this.targetPath);
            }
            if (e == null) {
                StrutsTargetUtilities.addStrutsLink(this.getFileToModify(), this.attributeName, this.targetModule, this.targetPath);
            } else {
                String oldModule = e.targetModule;
                String oldPath = e.targetPath;
                StrutsTargetUtilities.updateStrutsLink(0, this.getFileToModify(), this.attributeName, oldModule, oldPath, this.targetModule, this.targetPath);
            }
            progressMonitor.worked(700);
        }
        catch (Exception e) {
            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
        }
        progressMonitor.done();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        try {
            StrutsTargetUtilities.removeStrutsLink(0, this.getFileToModify(), this.targetModule, this.targetPath);
        }
        catch (Exception e) {
            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    protected IFile getFileToModify() {
        if (this.file == null) {
            this.file = WebProvider.getFileForNode((MNode)this.source);
        }
        return this.file;
    }
}

