/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.AbstractCreateForwardResource;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgeNameProperty;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigFactory;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.ui.statushandlers.StatusManager;

public class CreateLocalForwardResourceCommand
extends AbstractCreateForwardResource {
    private final IAdaptable actionMappingHandleAdaptable;
    private final TransactionalEditingDomain domain;
    private final MEdge edge;
    private IFile file;
    private String forwardName;
    private StrutsChangeCommand strutsChangeCommand;
    private boolean createDups;

    public CreateLocalForwardResourceCommand(TransactionalEditingDomain domain, String forwardName, IAdaptable actionMappingHandleAdaptable, MEdge edge, boolean createDups) {
        super(Messages.CreateLocalForward);
        this.domain = domain;
        this.edge = edge;
        this.forwardName = forwardName;
        this.actionMappingHandleAdaptable = actionMappingHandleAdaptable;
        this.createDups = createDups;
    }

    public static String createForwardName(ActionMapping mapping) {
        boolean foundSuccess = false;
        boolean foundFailure = false;
        for (Forward f : mapping.getForwards()) {
            if (Messages.Success.equals(f.getName())) {
                foundSuccess = true;
                continue;
            }
            if (!Messages.Failure.equals(f.getName())) continue;
            foundFailure = true;
        }
        if (!foundSuccess) {
            return Messages.Success;
        }
        if (!foundFailure) {
            return Messages.Failure;
        }
        int i = 1;
        while (!CreateLocalForwardResourceCommand.isUniquePath(mapping, Messages.NewForward, i)) {
            ++i;
        }
        return CreateLocalForwardResourceCommand.createPath(Messages.NewForward, i);
    }

    private static String createPath(String newPath, int suffix) {
        if (suffix >= 1) {
            return String.valueOf(newPath) + suffix;
        }
        return newPath;
    }

    private static boolean isUniquePath(ActionMapping actionMappingHandle, String newPath, int suffix) {
        String incedPath = CreateLocalForwardResourceCommand.createPath(newPath, suffix);
        int i = 0;
        while (i < actionMappingHandle.getForwards().size()) {
            Forward forward = (Forward)actionMappingHandle.getForwards().get(i);
            if (forward.getName().equals(incedPath)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canExecute() {
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProject project = WebProvider.getProjectForElement((CommonElement)this.edge);
        StrutsProvider.ensureUptodate(project);
        final ILink actionMappingHandle = this.getActionMappingHandle();
        if ("include".equals(actionMappingHandle.getParameter("attributeParam")) || "forward".equals(actionMappingHandle.getParameter("attributeParam"))) {
            Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), -1, Messages.CannotCreateExceptionOrForward, null);
            StatusManager.getManager().handle((IStatus)status, 4);
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

            @Override
            protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                ActionMapping mapping = (ActionMapping)StrutsLinksSearchUtil.getCorrespondingEObject((EClass)StrutsconfigPackage.eINSTANCE.getActionMapping(), (EObject)strutsConfig, (ILink)actionMappingHandle);
                if (mapping != null) {
                    Forward createdForward = null;
                    if (!CreateLocalForwardResourceCommand.this.createDups) {
                        String dupForwardName = CreateLocalForwardResourceCommand.this.forwardName;
                        if (dupForwardName == null) {
                            dupForwardName = CreateLocalForwardResourceCommand.this.getEdgeForwardName(CreateLocalForwardResourceCommand.this.edge);
                        }
                        if (dupForwardName != null) {
                            createdForward = CreateLocalForwardResourceCommand.this.getDuplidateForward(mapping, dupForwardName, CreateLocalForwardResourceCommand.this.getTargetPath());
                            if (createdForward == null) {
                                createdForward = CreateLocalForwardResourceCommand.this.getDuplidateForward(mapping, dupForwardName, null);
                            }
                            if (createdForward != null) {
                                CreateLocalForwardResourceCommand.this.forwardName = dupForwardName;
                            }
                        }
                    }
                    if (CreateLocalForwardResourceCommand.this.forwardName == null || CreateLocalForwardResourceCommand.this.forwardName.length() == 0) {
                        CreateLocalForwardResourceCommand.this.forwardName = CreateLocalForwardResourceCommand.createForwardName(mapping);
                    }
                    if (createdForward == null) {
                        createdForward = StrutsconfigFactory.eINSTANCE.createForward();
                        mapping.getForwards().add((Object)createdForward);
                    }
                    if (CreateLocalForwardResourceCommand.this.edge != null) {
                        boolean crossModuleForward = StrutsTargetUtilities.isTargetAndSourceModuleDifferent(CreateLocalForwardResourceCommand.this.edge.getSource(), CreateLocalForwardResourceCommand.this.edge.getTarget());
                        createdForward.setName(CreateLocalForwardResourceCommand.this.forwardName);
                        String targetPath = CreateLocalForwardResourceCommand.this.getTargetPath();
                        String targetModule = StrutsProvider.getModuleName((CommonElement)CreateLocalForwardResourceCommand.this.edge.getTarget());
                        if (crossModuleForward) {
                            if (StrutsProjectCoreUtil.isStruts1_1((IProject)CreateLocalForwardResourceCommand.this.getFileToModify().getProject())) {
                                createdForward.setPath(String.valueOf(targetModule) + targetPath);
                                createdForward.setContextRelative(crossModuleForward);
                                createdForward.unsetModule();
                            } else {
                                createdForward.setPath(targetPath);
                                if (targetModule != null) {
                                    createdForward.setModule(targetModule);
                                }
                                createdForward.unsetContextRelative();
                            }
                        } else if (StrutsProjectCoreUtil.isStruts1_1((IProject)CreateLocalForwardResourceCommand.this.getFileToModify().getProject())) {
                            createdForward.setPath(targetPath);
                            createdForward.setContextRelative(crossModuleForward);
                            createdForward.unsetModule();
                        } else {
                            createdForward.setPath(targetPath);
                            createdForward.unsetContextRelative();
                        }
                    } else {
                        createdForward.setName(CreateLocalForwardResourceCommand.this.forwardName);
                        createdForward.setPath("");
                        if (StrutsProjectCoreUtil.isStruts1_1((IProject)CreateLocalForwardResourceCommand.this.getFileToModify().getProject())) {
                            createdForward.setContextRelative(false);
                            createdForward.unsetModule();
                        } else {
                            createdForward.unsetContextRelative();
                        }
                    }
                }
                return true;
            }
        };
        this.strutsChangeCommand = StrutsChangeCommand.getStrutsCommand(this.getFileToModify(), changes, true);
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.execute();
        }
        if (this.edge != null) {
            UpdateEdgeNameProperty update = new UpdateEdgeNameProperty(this.domain, this.edge, this.forwardName, null, true);
            update.execute(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null && this.strutsChangeCommand.canUndo()) {
            this.strutsChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected ILink getActionMappingHandle() {
        return (ILink)this.actionMappingHandleAdaptable.getAdapter(ILink.class);
    }

    private Forward getDuplidateForward(ActionMapping mapping, String forwardName, String targetPath) {
        for (Forward f : mapping.getForwards()) {
            if (forwardName == null || !forwardName.equals(f.getName()) || !(targetPath == null ? !f.isSetPath() || "".equals(f.getPath()) : targetPath.equals(f.getPath()))) continue;
            return f;
        }
        return null;
    }

    private String getEdgeForwardName(MEdge edge) {
        for (Property p : edge.getPersistedProperties()) {
            if (!p.getName().equals("web.edgename.key")) continue;
            return p.getValue();
        }
        return null;
    }

    protected IFile getFileToModify() {
        ILink handle;
        if (this.file == null && (handle = this.getActionMappingHandle()) != null) {
            this.file = (IFile)handle.getContainer().getResource();
        }
        return this.file;
    }

    @Override
    public String getForwardName() {
        return this.forwardName;
    }

    protected String getTargetPath() {
        String pathTargetModule;
        if (this.edge == null) {
            return "";
        }
        String targetString = StrutsTargetUtilities.getTargetNodePath(this.edge.getSource(), this.edge.getTarget());
        String targetModule = StrutsProvider.getModuleName((CommonElement)this.edge.getTarget());
        if (targetString != null && targetModule != null && (pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)this.edge.getTarget()), (String)targetString)).equals(targetModule)) {
            targetString = targetString.substring(targetModule.length());
        }
        return targetString;
    }
}

