/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.AbstractCreateForwardResource;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgeNameProperty;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateGlobalForwardResourceCommand
extends AbstractCreateForwardResource {
    private String forwardName;
    private final String targetPath;
    private final IAdaptable sourceNode;
    private final MEdge edge;
    private IFile file;
    private final TransactionalEditingDomain domain;
    private StrutsChangeCommand strutsChangeCommand;
    private boolean createDups;

    public CreateGlobalForwardResourceCommand(TransactionalEditingDomain domain, String forwardName, String targetPath, IAdaptable sourceNode, MEdge edge, boolean createDups) {
        super(Messages.CreateGlobalForward);
        this.domain = domain;
        this.forwardName = forwardName;
        this.targetPath = targetPath;
        this.sourceNode = sourceNode;
        this.edge = edge;
        this.createDups = createDups;
    }

    public boolean canExecute() {
        return true;
    }

    public String createForwardName(StrutsConfig config) {
        boolean foundSuccess = false;
        boolean foundFailure = false;
        for (Forward f : config.getGlobalForwards()) {
            if (Messages.Success.equals(f.getName())) {
                foundSuccess = true;
                continue;
            }
            if (!Messages.Failure.equals(f.getName())) continue;
            foundFailure = true;
        }
        if (!foundSuccess) {
            return Messages.Success;
        }
        if (!foundFailure) {
            return Messages.Failure;
        }
        int i = 1;
        while (!this.isUniquePath(config, Messages.NewForward, i)) {
            ++i;
        }
        return this.createPath(Messages.NewForward, i);
    }

    private String createPath(String newPath, int suffix) {
        if (suffix >= 1) {
            return String.valueOf(newPath) + suffix;
        }
        return newPath;
    }

    public void dispose() {
        super.dispose();
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IFile strutsConfigFile = this.getFileToModify();
        if (strutsConfigFile == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.Error, (String)Messages.CouldNotCreateForwardInStrutsConfigFile);
                }
            });
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

            @Override
            protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                Forward createdForward = null;
                if (!CreateGlobalForwardResourceCommand.this.createDups) {
                    String dupForwardName = CreateGlobalForwardResourceCommand.this.forwardName;
                    if (dupForwardName == null) {
                        dupForwardName = CreateGlobalForwardResourceCommand.this.getEdgeForwardName(CreateGlobalForwardResourceCommand.this.edge);
                    }
                    if (dupForwardName != null) {
                        createdForward = CreateGlobalForwardResourceCommand.this.getDuplidateForward(strutsConfig, dupForwardName, CreateGlobalForwardResourceCommand.this.getTargetPath());
                        if (createdForward == null) {
                            createdForward = CreateGlobalForwardResourceCommand.this.getDuplidateForward(strutsConfig, dupForwardName, null);
                        }
                        if (createdForward != null) {
                            CreateGlobalForwardResourceCommand.this.forwardName = dupForwardName;
                        }
                    }
                }
                if (CreateGlobalForwardResourceCommand.this.forwardName == null || CreateGlobalForwardResourceCommand.this.forwardName.length() == 0) {
                    CreateGlobalForwardResourceCommand.this.forwardName = CreateGlobalForwardResourceCommand.this.createForwardName(strutsConfig);
                }
                if (createdForward == null) {
                    createdForward = StrutsconfigFactory.eINSTANCE.createForward();
                    strutsConfig.getGlobalForwards().add((Object)createdForward);
                }
                if (CreateGlobalForwardResourceCommand.this.edge != null) {
                    boolean crossModuleForward = StrutsTargetUtilities.isTargetAndSourceModuleDifferent(CreateGlobalForwardResourceCommand.this.edge.getSource(), CreateGlobalForwardResourceCommand.this.edge.getTarget());
                    createdForward.setName(CreateGlobalForwardResourceCommand.this.forwardName);
                    String targetPath = CreateGlobalForwardResourceCommand.this.getTargetPath();
                    String targetModule = StrutsProvider.getModuleName((CommonElement)CreateGlobalForwardResourceCommand.this.edge.getTarget());
                    if (crossModuleForward) {
                        if (StrutsProjectCoreUtil.isStruts1_1((IProject)CreateGlobalForwardResourceCommand.this.getFileToModify().getProject())) {
                            createdForward.setPath(String.valueOf(targetModule) + targetPath);
                            createdForward.setContextRelative(crossModuleForward);
                            createdForward.unsetModule();
                        } else {
                            createdForward.setPath(targetPath);
                            if (targetModule != null) {
                                createdForward.setModule(targetModule);
                            }
                            createdForward.unsetContextRelative();
                        }
                    } else if (StrutsProjectCoreUtil.isStruts1_1((IProject)CreateGlobalForwardResourceCommand.this.getFileToModify().getProject())) {
                        createdForward.setPath(targetPath);
                        createdForward.setContextRelative(crossModuleForward);
                        createdForward.unsetModule();
                    } else {
                        createdForward.setPath(targetPath);
                        createdForward.unsetContextRelative();
                    }
                } else {
                    createdForward.setName(CreateGlobalForwardResourceCommand.this.forwardName);
                    createdForward.setPath(CreateGlobalForwardResourceCommand.this.targetPath);
                    if (StrutsProjectCoreUtil.isStruts1_1((IProject)CreateGlobalForwardResourceCommand.this.getFileToModify().getProject())) {
                        createdForward.setContextRelative(false);
                        createdForward.unsetModule();
                    } else {
                        createdForward.unsetContextRelative();
                    }
                }
                return true;
            }
        };
        this.strutsChangeCommand = StrutsChangeCommand.getStrutsCommand(this.getFileToModify(), changes, true);
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.execute();
        }
        if (this.edge != null) {
            UpdateEdgeNameProperty update = new UpdateEdgeNameProperty(this.domain, this.edge, this.forwardName, null, true);
            update.execute(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null && this.strutsChangeCommand.canUndo()) {
            this.strutsChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    private Forward getDuplidateForward(StrutsConfig config, String forwardName, String targetPath) {
        for (Forward f : config.getGlobalForwards()) {
            if (forwardName == null || !forwardName.equals(f.getName()) || !(targetPath == null ? !f.isSetPath() || "".equals(f.getPath()) : targetPath.equals(f.getPath()))) continue;
            return f;
        }
        return null;
    }

    private String getEdgeForwardName(MEdge edge) {
        for (Property p : edge.getPersistedProperties()) {
            if (!p.getName().equals("web.edgename.key")) continue;
            return p.getValue();
        }
        return null;
    }

    protected IFile getFileToModify() {
        if (this.file == null) {
            this.file = StrutsProvider.getStrutsConfigFile((CommonElement)((MNode)this.sourceNode.getAdapter(MNode.class)));
        }
        return this.file;
    }

    @Override
    public String getForwardName() {
        return this.forwardName;
    }

    protected String getTargetPath() {
        String pathTargetModule;
        if (this.edge == null) {
            return "";
        }
        String targetString = this.targetPath;
        String targetModule = StrutsProvider.getModuleName((CommonElement)this.edge.getSource());
        if (targetString != null && targetModule != null && (pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)this.edge.getTarget()), (String)targetString)).equals(targetModule)) {
            targetString = targetString.substring(targetModule.length());
        }
        return targetString;
    }

    private boolean isUniquePath(StrutsConfig strutsConfig, String newPath, int suffix) {
        String incedPath = this.createPath(newPath, suffix);
        for (Forward forward : strutsConfig.getGlobalForwards()) {
            if (!forward.getName().equals(incedPath)) continue;
            return false;
        }
        return true;
    }
}

