/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.references;

import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsRefConstants;
import com.ibm.etools.references.web.struts.internal.providers.resolvers.StrutsConfigFileResolver;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class DiagramStrutsReferenceGenerator
implements IReferenceGeneratorProvider {
    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        IFile container = (IFile)params.reference.getSource().getContainer().getResource();
        List resources = WDEEditingDomainManager.INSTANCE.getModelRoots();
        for (Resource resource : resources) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
            if (!container.equals((Object)file)) continue;
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        if ("struts.action.ref".equals(referenceType)) {
            String result = AbstractWebProvider.trimQuotes((String)transformResult);
            Reference ref = StrutsConfigFileResolver.createStrutsActionReference((ILink)link, (String)referenceType, (String)result);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        if ("struts.forward.ref".equals(referenceType)) {
            String result = AbstractWebProvider.trimQuotes((String)transformResult);
            Reference ref = StrutsConfigFileResolver.createStrutsForwardReference((ILink)link, (String)referenceType, (String)result);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        if (StrutsRefConstants.REFTYPE_STRUTS_EXCEPTION_REF.equals(referenceType)) {
            String result = AbstractWebProvider.trimQuotes((String)transformResult);
            Reference ref = StrutsConfigFileResolver.createStrutsExceptionReference((ILink)link, (String)referenceType, (String)result);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        return null;
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("struts.action.ref".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("actionName.id");
        }
        if (StrutsRefConstants.REFTYPE_STRUTS_EXCEPTION_REF.equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("strutsexception.id");
        }
        if ("struts.forward.ref".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("strutsforward.id");
        }
        return null;
    }
}

