/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.references;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class DiagramStrutsLinkDetector
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            TreeWalker iter = ((DocumentTraversal)document).createTreeWalker((Node)document, 1, null, false);
            HashMap<String, IDOMElement> elementToIdMap = new HashMap<String, IDOMElement>();
            Node n = iter.nextNode();
            while (n != null) {
                if ("xmi:XMI".equals(n.getNodeName())) {
                    n = iter.firstChild();
                    continue;
                }
                if ("DiagramModel:Model".equals(n.getNodeName())) {
                    n = iter.firstChild();
                    continue;
                }
                if ("diagram".equals(n.getNodeName())) {
                    links.addAll(this.processDiagramNode(iter, factory, elementToIdMap));
                    n = iter.nextSibling();
                    continue;
                }
                if ("edges".equals(n.getNodeName())) {
                    links.addAll(this.processEdgesNode(iter, factory, elementToIdMap));
                    n = iter.nextSibling();
                    continue;
                }
                n = iter.nextSibling();
            }
        }
        return links;
    }

    private String getAttribute(Node node, String attribute) {
        return ((IDOMElement)node).getAttribute(attribute);
    }

    private List<ILink> processDiagramNode(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        String strutsModule = null;
        Node child = iter.firstChild();
        while (child != null) {
            if ("persistedProperties".equals(child.getNodeName()) && "struts.module.name.key".equals(this.getAttribute(child, "name"))) {
                strutsModule = this.getAttribute(child, "value");
            }
            if ("nodes".equals(child.getNodeName())) {
                links.addAll(this.processNodes(iter, factory, elementToIdMap, strutsModule));
            }
            child = iter.nextSibling();
        }
        iter.parentNode();
        return links;
    }

    private List<ILink> processEdgesNode(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        String type = this.getAttribute(iter.getCurrentNode(), "type");
        ArrayList<ILink> links = new ArrayList<ILink>();
        IDOMElement edge = (IDOMElement)iter.getCurrentNode();
        if ("com.ibm.etools.model2.diagram.struts.GlobalException".equals(type) || "com.ibm.etools.model2.diagram.struts.LocalException".equals(type) || "com.ibm.etools.model2.diagram.struts.GlobalForward".equals(type) || "com.ibm.etools.model2.diagram.struts.LocalForward".equals(type)) {
            IDOMElement child = (IDOMElement)iter.firstChild();
            while (child != null) {
                if ("persistedProperties".equals(child.getNodeName()) && "web.edgename.key".equals(this.getAttribute((Node)child, "name"))) {
                    boolean isLocal = "com.ibm.etools.model2.diagram.struts.LocalException".equals(type) || "com.ibm.etools.model2.diagram.struts.LocalForward".equals(type);
                    boolean isForward = "com.ibm.etools.model2.diagram.struts.GlobalForward".equals(type) || "com.ibm.etools.model2.diagram.struts.LocalForward".equals(type);
                    String linkType = "wde";
                    linkType = String.valueOf(linkType) + (isLocal ? "Local" : "Global");
                    linkType = String.valueOf(linkType) + (isForward ? "Forward" : "Exception");
                    ILink link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                    if (isLocal) {
                        String actionName = null;
                        String actionModule = null;
                        IDOMElement actionSource = elementToIdMap.get(edge.getAttribute("source"));
                        if (actionSource != null) {
                            NodeList list = actionSource.getChildNodes();
                            int i = 0;
                            while (i < list.getLength()) {
                                Node n = list.item(i);
                                if (n instanceof IDOMElement) {
                                    IDOMElement e = (IDOMElement)n;
                                    if ("struts.module.name.key".equals(e.getAttribute("name"))) {
                                        actionModule = e.getAttribute("value");
                                    } else if ("struts.action.name.key".equals(e.getAttribute("name"))) {
                                        actionName = e.getAttribute("value");
                                    }
                                }
                                ++i;
                            }
                        }
                        if (actionName != null && actionModule != null) {
                            factory.addParam(link, "actionName.id", actionName);
                            factory.addParam(link, "module", actionModule);
                        }
                    }
                    links.add(link);
                }
                child = (IDOMElement)iter.nextSibling();
            }
            iter.parentNode();
        }
        return links;
    }

    private List<ILink> processNodes(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap, String strutsModule) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        Node current = iter.getCurrentNode();
        while (current != null) {
            String id = this.getAttribute(current, "xmi:id");
            if (id != null) {
                elementToIdMap.put(id, (IDOMElement)current);
            }
            if ("com.ibm.etools.model2.diagram.struts.StrutsActionNode".equals(this.getAttribute(current, "type"))) {
                Node child = iter.firstChild();
                while (child != null) {
                    if ("struts.action.name.key".equals(this.getAttribute(child, "name"))) {
                        ILink link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)((IDOMElement)child), (IDOMAttr)((IDOMAttr)((IDOMElement)child).getAttributeNode("value")), (String)"wdeStrutsAction", null);
                        NodeList list = current.getChildNodes();
                        int i = 0;
                        while (i < list.getLength()) {
                            IDOMElement e;
                            Node n = list.item(i);
                            if (n instanceof IDOMElement && "struts.module.name.key".equals((e = (IDOMElement)n).getAttribute("name"))) {
                                String module = e.getAttribute("value");
                                factory.addParam(link, "module", module);
                            }
                            ++i;
                        }
                        links.add(link);
                    }
                    child = iter.nextSibling();
                }
                iter.parentNode();
            }
            current = iter.nextSibling();
        }
        return links;
    }
}

