/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.providers.edgeresolver;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IEdgeResolverProvider;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class StrutsEdgeResolver
extends StrutsProvider
implements IEdgeResolverProvider {
    public Collection getTargetableNodeDescriptors(IElementType targetNodeType, SourceReference reference) {
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            ILink targetHandle = null;
            Item sourceItem = reference.getSource();
            ILink itemLink = (ILink)sourceItem.getAdapter(ILink.class);
            String concreteTargetPath = StrutsProvider.getItemTargetPath(sourceItem);
            if (itemLink != null) {
                if ("struts.exception.link".equals(itemLink.getSpecializedType().getId())) {
                    itemLink = StrutsSearchUtil.getExceptionPathLinkForException((ILink)itemLink);
                }
                if (itemLink != null) {
                    targetHandle = StrutsProvider.getStrutsItemTargetLink(sourceItem);
                }
                Debug.noop();
            }
            if (targetHandle == null && itemLink != null) {
                targetHandle = StrutsProvider.getStrutsItemTargetLink(sourceItem);
            }
            if (itemLink != null) {
                if ("com.ibm.etools.model2.diagram.struts.StrutsLink".equals(reference.getEdgeType().getId())) {
                    String attribute = itemLink.getParameter("attributeParam");
                    if ("action".equals(attribute) && !"com.ibm.etools.model2.diagram.struts.StrutsActionNode".equals(targetNodeType.getId())) {
                        Set<ModelDescriptor> set = Collections.singleton(ModelDescriptor.HIDDEN);
                        return set;
                    }
                    if ("page".equals(attribute) && !"com.ibm.etools.model2.diagram.web.WebPageNode".equals(targetNodeType.getId())) {
                        Set<ModelDescriptor> set = Collections.singleton(ModelDescriptor.HIDDEN);
                        return set;
                    }
                } else if (targetHandle == null && concreteTargetPath != null) {
                    String action;
                    IProject project;
                    if ("com.ibm.etools.model2.diagram.struts.StrutsActionNode".equals(targetNodeType.getId())) {
                        project = WebProvider.getProjectForElement((CommonElement)reference.getSource());
                        String action2 = StrutsSearchUtil.depatternActionString((IProject)project, (String)concreteTargetPath, null);
                        if (action2.contains(".")) {
                            Set<ModelDescriptor> set = Collections.singleton(ModelDescriptor.HIDDEN);
                            return set;
                        }
                    } else if ("com.ibm.etools.model2.diagram.web.WebPageNode".equals(targetNodeType.getId()) && !(action = StrutsSearchUtil.depatternActionString((IProject)(project = WebProvider.getProjectForElement((CommonElement)reference.getSource())), (String)concreteTargetPath, null)).equals(concreteTargetPath)) {
                        Set<ModelDescriptor> set = Collections.singleton(ModelDescriptor.HIDDEN);
                        return set;
                    }
                }
            }
            if (targetHandle != null) {
                if ("com.ibm.etools.model2.diagram.struts.StrutsActionNode".equals(targetNodeType.getId()) && targetHandle.getSpecializedType().getId().equals("struts.action.link")) {
                    String depatternedActionPath = StrutsSearchUtil.depatternActionString((IProject)targetHandle.getContainer().getResource().getProject(), (String)concreteTargetPath, null);
                    List<ActionModelDescriptor> list = Collections.singletonList(new ActionModelDescriptor(targetHandle, depatternedActionPath));
                    return list;
                }
                if ("com.ibm.etools.model2.diagram.web.WebPageNode".equals(targetNodeType.getId()) && targetHandle.getContainer().getResource().getType() == 1 && ("builtin.file.nodeid".equals(targetHandle.getSpecializedType().getId()) || "web.commonlink".equals(targetHandle.getSpecializedType().getId()))) {
                    List<WebPageModelDescriptor> list = Collections.singletonList(new WebPageModelDescriptor(targetHandle));
                    return list;
                }
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public void instantiateEdge(MEdge edge, SourceReference reference, MNode target) {
        if (!StrutsEdgeResolver.isActionInputEdge((TypedElement)edge)) {
            Integer dupIndex;
            if (StrutsEdgeResolver.isExceptionEdge((TypedElement)edge)) {
                String edgeName = StrutsEdgeResolver.getStringProperty((String)"struts.exception.name.key", (IPropertyHolder)reference.getSource());
                boolean updated = StrutsEdgeResolver.updateStringProperty((String)"web.edgename.key", (String)edgeName, (IPropertyHolder)edge);
                if (!updated) {
                    Property name = DiagramModelFactory.eINSTANCE.createProperty();
                    name.setName("web.edgename.key");
                    name.setValue(edgeName);
                    edge.getPersistedProperties().add((Object)name);
                    Integer dupIndex2 = (Integer)reference.getParameter("web.dup.index");
                    if (dupIndex2 != null) {
                        Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                        indexProperty.setName("web.dup.index");
                        indexProperty.setValue(dupIndex2.toString());
                        edge.getPersistedProperties().add((Object)indexProperty);
                    }
                }
            } else if (StrutsEdgeResolver.isGlobalForwardEdge((TypedElement)edge)) {
                String edgeName = StrutsEdgeResolver.getStringProperty((String)"struts.forward.name.key", (IPropertyHolder)reference.getSource());
                boolean updated = StrutsEdgeResolver.updateStringProperty((String)"web.edgename.key", (String)edgeName, (IPropertyHolder)edge);
                if (!updated) {
                    Property name = DiagramModelFactory.eINSTANCE.createProperty();
                    name.setName("web.edgename.key");
                    name.setValue(edgeName);
                    edge.getPersistedProperties().add((Object)name);
                }
            } else if ((StrutsEdgeResolver.isHtmlFormEdge((TypedElement)edge) || StrutsEdgeResolver.isHtmlLinkEdge((TypedElement)edge)) && (dupIndex = (Integer)reference.getParameter("web.dup.index")) != null) {
                Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                indexProperty.setName("web.dup.index");
                indexProperty.setValue(dupIndex.toString());
                edge.getPersistedProperties().add((Object)indexProperty);
            }
        }
    }

    public void instantiateNode(SourceReference reference, MNode target, ModelDescriptor descriptor) {
        if (descriptor instanceof ActionModelDescriptor) {
            String prefix;
            Property name = DiagramModelFactory.eINSTANCE.createProperty();
            name.setName("struts.action.name.key");
            name.setValue(((ActionModelDescriptor)descriptor).getDisplayName());
            name.setEditable(true);
            target.getPersistedProperties().add((Object)name);
            target.setTitleProperty(name);
            try {
                prefix = StrutsSearchUtil.getModuleForILink((ILink)((ActionModelDescriptor)descriptor).getHandle(), null);
            }
            catch (ReferenceException referenceException) {
                prefix = "";
            }
            Property module = DiagramModelFactory.eINSTANCE.createProperty();
            module.setName("struts.module.name.key");
            module.setValue(prefix);
            module.setEditable(true);
            target.getPersistedProperties().add((Object)module);
        } else if (descriptor instanceof WebPageModelDescriptor) {
            Property name = DiagramModelFactory.eINSTANCE.createProperty();
            name.setName("web.path.key");
            IPath ipath = ((WebPageModelDescriptor)descriptor).getHandle().getPath();
            String relativePath = WebProvider.getDocumentRootRelativePath((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(ipath)).toString();
            name.setValue(relativePath);
            name.setEditable(true);
            target.getPersistedProperties().add((Object)name);
            target.setTitleProperty(name);
        }
    }

    public boolean isResolvable(MNode target, SourceReference ref) {
        if (ref == null || target == null) {
            return false;
        }
        String edgeRefType = ref.getEdgeType().getId();
        Item sourceItem = ref.getSource();
        if (edgeRefType == null || sourceItem == null) {
            return false;
        }
        if (!("com.ibm.etools.model2.diagram.struts.GlobalException".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.LocalException".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.ActionInput".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.StaticForward".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.StaticInclude".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.GlobalForward".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.LocalForward".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.StrutsFormLink".equals(edgeRefType) || "com.ibm.etools.model2.diagram.struts.StrutsLink".equals(edgeRefType))) {
            return false;
        }
        String targetTitle = target.getTitleProperty().getValue();
        if (target.isRealized()) {
            ILink itemsTarget = StrutsProvider.getStrutsItemTargetLink(sourceItem, targetTitle);
            if (itemsTarget != null) {
                return itemsTarget.equals(target.getAdapter(ILink.class));
            }
        } else {
            String targetModule;
            String itemsTargetModule;
            String itemsTargetPath = StrutsProvider.getItemTargetPath(sourceItem);
            itemsTargetPath = URIUtil.parse((String)itemsTargetPath).path;
            if (!itemsTargetPath.startsWith("/")) {
                itemsTargetPath = "/" + itemsTargetPath;
            }
            if (!(targetTitle = URIUtil.parse((String)targetTitle).path).startsWith("/")) {
                targetTitle = "/" + targetTitle;
            }
            if (Model2Util.isEqualOrBothNull((Object)(itemsTargetModule = StrutsProvider.getItemTargetModule(sourceItem)), (Object)(targetModule = StrutsProvider.getModuleName((CommonElement)target))) && Model2Util.isEqualOrBothNull((Object)itemsTargetPath, (Object)targetTitle)) {
                return true;
            }
        }
        return false;
    }

    private class ActionModelDescriptor
    extends ModelDescriptor {
        private final ILink handle;
        private String moduleRelativeName;

        public ActionModelDescriptor(ILink handle, String concreteName) {
            String pathApplicationTargetModule;
            IProject project;
            String pathTargetModule;
            this.handle = handle;
            String module = StrutsSearchUtil.getModuleForILink((ILink)handle, null);
            this.moduleRelativeName = concreteName;
            String applicationRelativeName = concreteName;
            if (module == null) {
                module = "";
            }
            if ((pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)(project = handle.getContainer().getResource().getProject()), (String)this.moduleRelativeName)).equals(module)) {
                this.moduleRelativeName = this.moduleRelativeName.substring(module.length());
            }
            if (!(pathApplicationTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)project, (String)applicationRelativeName)).equals(module)) {
                applicationRelativeName = String.valueOf(module) + applicationRelativeName;
            }
            this.setDisplayName(applicationRelativeName);
        }

        public ILink getHandle() {
            return this.handle;
        }

        public boolean matches(MNode node) {
            if (StrutsEdgeResolver.isActionMapping((TypedElement)node)) {
                ILink otherHandle = (ILink)node.getAdapter(ILink.class);
                boolean linksEqual = this.handle.equals(otherHandle);
                boolean namesEqual = this.moduleRelativeName.equals(StrutsProvider.getName((CommonElement)node));
                return linksEqual && namesEqual;
            }
            return false;
        }
    }

    private class WebPageModelDescriptor
    extends ModelDescriptor {
        private final ILink handle;

        public WebPageModelDescriptor(ILink handle) {
            this.handle = handle;
            IPath path = WebUtil.getDocumentRootRelativePath((IFile)((IFile)handle.getContainer().getResource()));
            if (path == null) {
                this.setDisplayName("");
            } else {
                this.setDisplayName(path.toString());
            }
        }

        public ILink getHandle() {
            return this.handle;
        }

        public boolean matches(MNode node) {
            if (StrutsEdgeResolver.isWebPageNode((TypedElement)node)) {
                ILink otherHandle = (ILink)node.getAdapter(ILink.class);
                return this.handle.equals(otherHandle);
            }
            return false;
        }
    }
}

