/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.providers.edgegenerator;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.providers.IEdgeGeneratorProvider;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class StrutsArtifactReferenceGenerator
extends StrutsProvider
implements IEdgeGeneratorProvider {
    public Collection generateSources(Item sourceItem, IElementType edgeType, IElementType itemTypeToGenerate) {
        try {
            ILink handle;
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            int dupIndex = 0;
            dupIndex = StrutsArtifactReferenceGenerator.calculateItemIndexInCompartmentByType(sourceItem);
            if ("com.ibm.etools.model2.diagram.struts.LocalForwardItem".equals(sourceItem.getType()) || "com.ibm.etools.model2.diagram.struts.GlobalForwardItem".equals(sourceItem.getType())) {
                ILink handle2 = (ILink)sourceItem.getAdapter(ILink.class);
                if (handle2 != null) {
                    SourceReference ref = new SourceReference(sourceItem, edgeType);
                    ref.setDisplayText(null);
                    String forwardName = AbstractWebProvider.trimQuotes((String)handle2.getName());
                    ref.addParameter("web.edgename.key", (Object)forwardName);
                    ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
                    List<SourceReference> list = Collections.singletonList(ref);
                    return list;
                }
            } else if ("com.ibm.etools.model2.diagram.struts.LocalExceptionItem".equals(sourceItem.getType()) || "com.ibm.etools.model2.diagram.struts.GlobalExceptionItem".equals(sourceItem.getType())) {
                ILink handle3 = (ILink)sourceItem.getAdapter(ILink.class);
                if (handle3 != null) {
                    SourceReference ref = new SourceReference(sourceItem, edgeType);
                    ref.setDisplayText(null);
                    String exceptName = AbstractWebProvider.trimQuotes((String)handle3.getLinkText());
                    ref.addParameter("web.edgename.key", (Object)exceptName);
                    ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
                    List<SourceReference> list = Collections.singletonList(ref);
                    return list;
                }
            } else if ("com.ibm.etools.model2.diagram.struts.ActionInputItem".equals(sourceItem.getType())) {
                ILink handle4 = (ILink)sourceItem.getAdapter(ILink.class);
                if (handle4 != null) {
                    String inputName = StrutsArtifactReferenceGenerator.getItemTargetPath(sourceItem);
                    if ("input".equals(handle4.getParameter("attributeParam")) && (inputName == null || inputName.length() == 0)) {
                        List list = Collections.emptyList();
                        return list;
                    }
                    SourceReference ref = new SourceReference(sourceItem, edgeType);
                    ref.setDisplayText(null);
                    ref.addParameter("web.edgename.key", (Object)inputName);
                    ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
                    List<SourceReference> list = Collections.singletonList(ref);
                    return list;
                }
            } else if ("com.ibm.etools.model2.diagram.struts.StaticForwardItem".equals(sourceItem.getType())) {
                ILink handle5 = (ILink)sourceItem.getAdapter(ILink.class);
                if (handle5 != null) {
                    String forwardName = AbstractWebProvider.trimQuotes((String)handle5.getLinkText());
                    if ("forward".equals(handle5.getParameter("attributeParam")) && (forwardName == null || forwardName.length() == 0)) {
                        List list = Collections.emptyList();
                        return list;
                    }
                    SourceReference ref = new SourceReference(sourceItem, edgeType);
                    ref.setDisplayText(null);
                    ref.addParameter("web.edgename.key", (Object)forwardName);
                    ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
                    List<SourceReference> list = Collections.singletonList(ref);
                    return list;
                }
            } else if ("com.ibm.etools.model2.diagram.struts.StaticIncludeItem".equals(sourceItem.getType()) && (handle = (ILink)sourceItem.getAdapter(ILink.class)) != null) {
                String include = AbstractWebProvider.trimQuotes((String)handle.getLinkText());
                if ("include".equals(handle.getParameter("attributeParam")) && (include == null || include.length() == 0)) {
                    List list = Collections.emptyList();
                    return list;
                }
                SourceReference ref = new SourceReference(sourceItem, edgeType);
                ref.setDisplayText(null);
                ref.addParameter("web.edgename.key", (Object)include);
                ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
                List<SourceReference> list = Collections.singletonList(ref);
                return list;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public boolean isSourcedToItem(MEdge edge, Item sourceItem) {
        if ("com.ibm.etools.model2.diagram.struts.ActionInputItem".equals(sourceItem.getType()) && "com.ibm.etools.model2.diagram.struts.ActionInput".equals(edge.getType())) {
            return true;
        }
        if ("com.ibm.etools.model2.diagram.struts.StaticForwardItem".equals(sourceItem.getType()) && "com.ibm.etools.model2.diagram.struts.StaticForward".equals(edge.getType())) {
            return true;
        }
        if ("com.ibm.etools.model2.diagram.struts.StaticIncludeItem".equals(sourceItem.getType()) && "com.ibm.etools.model2.diagram.struts.StaticInclude".equals(edge.getType())) {
            return true;
        }
        if ("com.ibm.etools.model2.diagram.struts.StaticIncludeItem".equals(sourceItem.getType()) && "com.ibm.etools.model2.diagram.struts.StaticInclude".equals(edge.getType())) {
            return true;
        }
        String edgeName = StrutsArtifactReferenceGenerator.getStringProperty((String)"web.edgename.key", (IPropertyHolder)edge);
        String edgeTarget = StrutsTargetUtilities.getTargetNodePath(edge.getSource(), edge.getTarget());
        if (edge.getTarget() == null) {
            return false;
        }
        if (edgeName == null || edgeName.length() == 0) {
            return false;
        }
        if (edgeTarget == null || edgeTarget.length() == 0) {
            return false;
        }
        if ("com.ibm.etools.model2.diagram.struts.LocalForwardItem".equals(sourceItem.getType()) || "com.ibm.etools.model2.diagram.struts.GlobalForwardItem".equals(sourceItem.getType())) {
            ILink sourceLink = (ILink)sourceItem.getAdapter(ILink.class);
            boolean matches = false;
            if (sourceLink != null) {
                ILink target;
                String name = sourceLink.getName();
                if (edgeName.equals(name) && (target = StrutsProvider.getStrutsItemTargetLink(sourceItem, edgeTarget)) != null && target.equals(edge.getTarget().getAdapter(ILink.class))) {
                    int dupCount = StrutsArtifactReferenceGenerator.calculateForwardItemIndexInCompartmentByType(sourceItem, edgeTarget);
                    MEdge edgeToCompare = StrutsArtifactReferenceGenerator.getEdgeForTargetByTypeAtIndex((String)edge.getType(), (String)"web.edgename.key", (String)name, (MNode)edge.getTarget(), (List)sourceItem.getNode().getOutput(), (int)dupCount);
                    if (edge.equals(edgeToCompare)) {
                        matches = true;
                    }
                }
                return matches;
            }
        } else if ("com.ibm.etools.model2.diagram.struts.LocalExceptionItem".equals(sourceItem.getType()) || "com.ibm.etools.model2.diagram.struts.GlobalExceptionItem".equals(sourceItem.getType())) {
            ILink sourceLink = (ILink)sourceItem.getAdapter(ILink.class);
            boolean matches = false;
            if (sourceLink != null) {
                ILink target;
                String name = AbstractWebProvider.trimQuotes((String)sourceLink.getLinkText());
                if (edgeName.equals(name) && (target = StrutsProvider.getStrutsItemTargetLink(sourceItem, edgeTarget)) != null && target.equals(edge.getTarget().getAdapter(ILink.class))) {
                    int dupCount = StrutsArtifactReferenceGenerator.calculateItemIndexInCompartmentByType(sourceItem, edgeTarget);
                    MEdge edgeToCompare = StrutsArtifactReferenceGenerator.getEdgeForTargetByTypeAtIndex((String)edge.getType(), (String)"web.edgename.key", (String)name, (MNode)edge.getTarget(), (List)sourceItem.getNode().getOutput(), (int)dupCount);
                    if (edge.equals(edgeToCompare)) {
                        matches = true;
                    }
                }
                return matches;
            }
        }
        return false;
    }
}

