/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.SubItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.providers.reverse.StrutsGlobalMarker;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.jspeditor.vct.dialog.ActionDialogElement;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavConcreteActionMappingNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class StrutsActionConfiguratorProvider
extends StrutsProvider
implements IConfiguratorProvider {
    public void configureExisting(CommonElement element, Object existing, Map options) {
        block23: {
            MNode node;
            block22: {
                boolean updatedModule;
                String actionPath = null;
                String module = null;
                if (StrutsProvider.isActionMapping((TypedElement)element)) {
                    module = WebProvider.getStringProperty((String)"struts.module.name.key", (IPropertyHolder)element);
                    if (module == null) {
                        module = StrutsProvider.getModuleName((CommonElement)((MNode)element).getParent());
                    }
                } else {
                    module = StrutsProvider.getModuleName((CommonElement)((MNode)element).getParent());
                }
                ILink handle = null;
                if (existing instanceof ActionDialogElement) {
                    ActionDialogElement adElement = (ActionDialogElement)existing;
                    actionPath = adElement.getPath();
                    module = adElement.getModule();
                } else if (existing instanceof IAdaptable) {
                    handle = (ILink)((IAdaptable)existing).getAdapter(ILink.class);
                    if (handle == null) {
                        if (existing instanceof StrutsGlobalMarker) {
                            Property property = DiagramModelFactory.eINSTANCE.createProperty();
                            property.setName("struts.action.global.name.key");
                            property.setValue(Messages.StrutsGlobal);
                            property.setEditable(false);
                            element.getTransientProperties().add((Object)property);
                            element.setTitleProperty(property);
                        }
                    } else {
                        actionPath = handle.getName();
                        ActionMappingWildcardUtil wcUtil = new ActionMappingWildcardUtil(handle.getContainer().getResource().getProject(), actionPath);
                        if (wcUtil.actionHasWildcards() && existing instanceof StrutsProjNavConcreteActionMappingNode) {
                            actionPath = ((StrutsProjNavConcreteActionMappingNode)existing).getReferenceURL();
                        }
                        try {
                            module = StrutsSearchUtil.getModuleForILink((ILink)handle, null);
                        }
                        catch (ReferenceException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (existing instanceof String) {
                    actionPath = (String)existing;
                }
                node = (MNode)element;
                if (!"nodePhase".equals(options.get("configure phase"))) break block22;
                if (actionPath == null) {
                    return;
                }
                boolean updatedName = WebProvider.updateStringProperty((String)"struts.action.name.key", (String)actionPath, (IPropertyHolder)node);
                if (!updatedName) {
                    Property property = DiagramModelFactory.eINSTANCE.createProperty();
                    property.setName("struts.action.name.key");
                    property.setValue(actionPath);
                    property.setEditable(true);
                    element.getPersistedProperties().add((Object)property);
                    element.setTitleProperty(property);
                }
                if (!(updatedModule = WebProvider.updateStringProperty((String)"struts.module.name.key", (String)module, (IPropertyHolder)node))) {
                    Property moduleName = DiagramModelFactory.eINSTANCE.createProperty();
                    moduleName.setName("struts.module.name.key");
                    moduleName.setValue(module);
                    element.getPersistedProperties().add((Object)moduleName);
                }
                if (StrutsActionConfiguratorProvider.isActionInDiagramModule((MNode)element)) break block23;
                EList compartments = ((MNode)element).getCompartments();
                Iterator iter = compartments.iterator();
                while (iter.hasNext()) {
                    Compartment c = (Compartment)iter.next();
                    if (!"com.ibm.etools.model2.diagram.struts.ForwardsCompartment".equals(c.getType()) && !"com.ibm.etools.model2.diagram.web.DataCompartment".equals(c.getType())) continue;
                    iter.remove();
                }
                break block23;
            }
            if ("edgePhase".equals(options.get("configure phase")) && Boolean.TRUE.equals(options.get("use defaults"))) {
                ArrayList nodes = new ArrayList(node.getParent().getNodes());
                nodes.remove(node);
                EList compartments = node.getCompartments();
                for (Compartment compartment : compartments) {
                    EList items = compartment.getSortedItems();
                    for (NodeItem nodeItem : items) {
                        this.processItem(options, node, nodes, (Item)nodeItem);
                        EList subItems = nodeItem.getChildren();
                        for (SubItem subItem : subItems) {
                            this.processItem(options, node, nodes, (Item)subItem);
                        }
                    }
                }
            }
        }
    }

    public void configureLoad(CommonElement element) {
        if ("com.ibm.etools.model2.diagram.struts.StrutsGlobalNode".equals(((MNode)element).getType())) {
            Property property = DiagramModelFactory.eINSTANCE.createProperty();
            property.setName("struts.action.global.name.key");
            property.setValue(Messages.StrutsGlobal);
            property.setEditable(false);
            element.getTransientProperties().add((Object)property);
            element.setTitleProperty(property);
        }
        if (!StrutsActionConfiguratorProvider.isActionInDiagramModule((MNode)element)) {
            EList compartments = ((MNode)element).getCompartments();
            Iterator iter = compartments.iterator();
            while (iter.hasNext()) {
                Compartment c = (Compartment)iter.next();
                if (!"com.ibm.etools.model2.diagram.struts.ForwardsCompartment".equals(c.getType()) && !"com.ibm.etools.model2.diagram.web.DataCompartment".equals(c.getType())) continue;
                iter.remove();
            }
        }
    }

    public void configureNew(CommonElement element) {
        MNode nodeToConfigure = (MNode)element;
        String module = StrutsProvider.getModuleName((CommonElement)nodeToConfigure.getParent());
        if ("com.ibm.etools.model2.diagram.struts.StrutsActionNode".equals(nodeToConfigure.getType())) {
            String newPath = "/action";
            int increment = 1;
            while (!this.isUniquePath(nodeToConfigure, newPath, increment)) {
                ++increment;
            }
            Property property = DiagramModelFactory.eINSTANCE.createProperty();
            property.setName("struts.action.name.key");
            property.setValue(this.createPath(newPath, increment));
            element.getPersistedProperties().add((Object)property);
            property.setEditable(true);
            Property firstDropProperty = DiagramModelFactory.eINSTANCE.createProperty();
            firstDropProperty.setName("struts.action.create.new.key");
            firstDropProperty.setValue(Boolean.TRUE.toString());
            element.getPersistedProperties().add((Object)firstDropProperty);
            firstDropProperty.setDisplayable(false);
            firstDropProperty.setEditable(true);
            element.setTitleProperty(property);
            Property moduleName = DiagramModelFactory.eINSTANCE.createProperty();
            moduleName.setName("struts.module.name.key");
            moduleName.setValue(module);
            element.getPersistedProperties().add((Object)moduleName);
        } else if ("com.ibm.etools.model2.diagram.struts.StrutsGlobalNode".equals(nodeToConfigure.getType())) {
            Property property = DiagramModelFactory.eINSTANCE.createProperty();
            property.setName("struts.action.global.name.key");
            property.setValue(Messages.StrutsGlobal);
            property.setEditable(false);
            element.getTransientProperties().add((Object)property);
            element.setTitleProperty(property);
        }
    }

    private String createPath(String newPath, int suffix) {
        if (suffix > 0) {
            return String.valueOf(newPath) + suffix;
        }
        return newPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUniquePath(MNode nodeToConfigure, String newPath, int suffix) {
        MDiagram d = nodeToConfigure.getParent();
        String incedPath = this.createPath(newPath, suffix);
        EList nodes = d.getNodes();
        for (MNode node : nodes) {
            String nodePath;
            if (!StrutsActionConfiguratorProvider.isActionMapping((TypedElement)node) || !incedPath.equals(nodePath = StrutsActionConfiguratorProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)node))) continue;
            return false;
        }
        IProject project = WebProvider.getProjectForElement((CommonElement)nodeToConfigure);
        String module = StrutsProvider.getModuleName((CommonElement)d);
        try {
            Object element;
            ILink handle;
            Set handles = StrutsSearchUtil.getAllActionsForModule((IProject)project, (String)module, null);
            Iterator iterator = handles.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!incedPath.equals((handle = (ILink)(element = iterator.next())).getName()));
            return false;
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void processItem(Map<Object, Object> options, MNode node, List nodes, Item nodeItem) {
        List list = EdgeGeneratorService.getInstance().getGenerableEdgeTypes(nodeItem);
        for (IElementType edgeType : list) {
            List references = EdgeGeneratorService.getInstance().generateExistingReferences(nodeItem, edgeType, nodeItem.getElementType());
            for (SourceReference reference : references) {
                for (MNode otherNode : nodes) {
                    IElementType otherNodeType = otherNode.getElementType();
                    List resolvableEdgeTypes = EdgeResolverService.getInstance().getResolvableEdgeTypes(otherNodeType);
                    if (!resolvableEdgeTypes.contains(edgeType) || !EdgeResolverService.getInstance().isResolvable(otherNode, reference)) continue;
                    List outputs = EdgeGeneratorService.getInstance().getItemsEdges(nodeItem);
                    boolean foundMatch = false;
                    for (MEdge edge : outputs) {
                        if (!otherNode.equals(edge.getTarget()) || !edgeType.getId().equals(edge.getType())) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    CreateRelationshipRequest req = new CreateRelationshipRequest((EObject)node.getParent().getModel(), (EObject)node, (EObject)otherNode, edgeType);
                    IElementType webDiagramType = node.getParent().getElementType();
                    req.addParameters(options);
                    req.setParameter("existing edge", (Object)Boolean.TRUE);
                    req.setParameter("source reference", (Object)reference);
                    ICommand cmd = webDiagramType.getEditCommand((IEditCommandRequest)req);
                    try {
                        cmd.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

