/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.providers;

import com.ibm.etools.diagram.model.internal.commands.ReorientEdgeCommand;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsProvider
extends WebProvider {
    public static int calculateForwardItemIndexInCompartmentByType(Item item, String concretePath) {
        return StrutsProvider.calculateItemIndexInCompartmentByType(item, concretePath, true);
    }

    public static int calculateItemIndexInCompartmentByType(Item baseItem) {
        return StrutsProvider.calculateItemIndexInCompartmentByType(baseItem, null, false);
    }

    public static int calculateItemIndexInCompartmentByType(Item baseItem, boolean useTitle) {
        return StrutsProvider.calculateItemIndexInCompartmentByType(baseItem, null, useTitle);
    }

    public static int calculateItemIndexInCompartmentByType(Item item, String concretePath) {
        return StrutsProvider.calculateItemIndexInCompartmentByType(item, concretePath, false);
    }

    public static int calculateItemIndexInCompartmentByType(Item item, String concretePath, boolean useTitleProperty) {
        ILink itemTargetLink = StrutsProvider.getStrutsItemTargetLink(item, concretePath);
        Compartment compartment = (Compartment)item.eContainer();
        EList sortedItemsInCompartment = compartment.getSortedItems();
        int dupCount = 0;
        for (Item otherItem : sortedItemsInCompartment) {
            ILink otherItemTargetLink;
            if (otherItem == item) break;
            if (!item.getType().equals(otherItem.getType()) || !Model2Util.isEqualOrBothNull((Object)itemTargetLink, (Object)(otherItemTargetLink = StrutsProvider.getStrutsItemTargetLink(otherItem, concretePath))) || useTitleProperty && !item.getTitleProperty().getValue().equals(otherItem.getTitleProperty().getValue())) continue;
            ++dupCount;
        }
        return dupCount;
    }

    public static IStatus checkNewEdgeValidity(MEdge edge) {
        IStatus status = Status.OK_STATUS;
        MNode sourceNode = edge.getSource();
        if (sourceNode != null && !sourceNode.isRealized()) {
            if (StrutsProvider.isActionMapping((TypedElement)sourceNode)) {
                EList existingOutEdges = sourceNode.getOutput();
                if (existingOutEdges != null && existingOutEdges.size() > 1) {
                    String type = null;
                    HashMap<String, String> incompatibleTypes = new HashMap<String, String>();
                    if (StrutsProvider.isStaticForwardEdge((TypedElement)edge) || StrutsProvider.isStaticIncludeEdge((TypedElement)edge)) {
                        type = StrutsProvider.isStaticForwardEdge((TypedElement)edge) ? Messages.StaticForwards : Messages.StaticIncludes;
                        incompatibleTypes.put("com.ibm.etools.model2.diagram.struts.ActionInput", Messages.ActionInput);
                        incompatibleTypes.put("com.ibm.etools.model2.diagram.struts.LocalException", Messages.LocalException);
                        incompatibleTypes.put("com.ibm.etools.model2.diagram.struts.LocalForward", Messages.LocalForward);
                    } else if (StrutsProvider.isActionInputEdge((TypedElement)edge)) {
                        type = Messages.ActionInputs;
                        incompatibleTypes.put("com.ibm.etools.model2.diagram.struts.ActionInput", Messages.ActionInput);
                    } else if (StrutsProvider.isLocalForwardEdge((TypedElement)edge)) {
                        type = Messages.LocalForwards;
                    } else if (StrutsProvider.isLocalExceptionEdge((TypedElement)edge)) {
                        type = Messages.LocalExceptions;
                    }
                    incompatibleTypes.put("com.ibm.etools.model2.diagram.struts.StaticForward", Messages.StaticForward);
                    incompatibleTypes.put("com.ibm.etools.model2.diagram.struts.StaticInclude", Messages.StaticInclude);
                    for (MEdge existingEdge : existingOutEdges) {
                        String otherType;
                        if (edge == existingEdge || (otherType = (String)incompatibleTypes.get(existingEdge.getType())) == null) continue;
                        return new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), -1, NLS.bind((String)Messages.NewEdgeNotCompatibleWithExistingEdgesOfUnrealizedNodeMessage, (Object[])new String[]{type, otherType}), null);
                    }
                }
            } else if (!StrutsProvider.isGlobalActionMapping((TypedElement)sourceNode) && !StrutsProvider.isWebPageNode((TypedElement)sourceNode)) {
                StrutsProvider.isWebApplicationNode((TypedElement)sourceNode);
            }
        }
        return status;
    }

    public static void ensureUptodate(IProject project) {
        Collection files = StrutsSearchUtil.getStrutsConfigIFiles((IProject)project);
        ArrayList<ResourceChange> rChanges = new ArrayList<ResourceChange>();
        for (IFile file : files) {
            rChanges.add(new ResourceChange((IResource)file, 4));
        }
        ReferenceManager.getReferenceManager().requestChangeAnalysis(rChanges, null);
    }

    public static ILink getActionMappingTarget(Item sourceItem) {
        return StrutsProvider.getActionMappingTarget(sourceItem, null);
    }

    public static ILink getActionMappingTarget(Item sourceItem, String concretePath) {
        if (sourceItem == null) {
            return null;
        }
        String targetModule = StrutsProvider.getItemTargetModule(sourceItem);
        String targetPath = StrutsProvider.getItemTargetPath(sourceItem);
        targetPath = URIUtil.parse((String)targetPath).path;
        ILink sourceLink = (ILink)sourceItem.getAdapter(ILink.class);
        if (sourceLink != null) {
            Collection rrs;
            if ("struts.exception.link".equals(sourceLink.getSpecializedType().getId())) {
                sourceLink = StrutsSearchUtil.getExceptionPathLinkForException((ILink)sourceLink);
            }
            if (!(rrs = sourceLink.resolveReference("struts.action.ref", null)).isEmpty()) {
                if (targetPath != null) {
                    IProject project;
                    String pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)sourceItem), (String)targetPath);
                    if (pathTargetModule.equals(targetModule)) {
                        targetPath = targetPath.substring(targetModule.length());
                    }
                    if ((targetPath = StrutsSearchUtil.depatternActionString((IProject)(project = sourceLink.getContainer().getResource().getProject()), (String)targetPath, null)) != null && !targetPath.startsWith("/")) {
                        targetPath = "/" + targetPath;
                    }
                    for (IResolvedReference rr : rrs) {
                        ILink target;
                        if (rr.getBrokenStatus() == BrokenStatus.BROKEN || rr.getBrokenStatus() == BrokenStatus.IGNORED || (target = rr.getTarget()) == null) continue;
                        String actionModule = StrutsSearchUtil.getModuleForILink((ILink)target, null);
                        String actionPath = target.getName();
                        ActionMappingWildcardUtil wcu = new ActionMappingWildcardUtil(project, actionPath = StrutsSearchUtil.depatternActionString((IProject)project, (String)actionPath, null));
                        if (wcu.actionHasWildcards() && concretePath == null) {
                            if (targetModule.equals(actionModule) && wcu.actionPathMatchesPattern(targetPath)) {
                                return target;
                            }
                        } else if (concretePath != null && wcu.actionPathMatchesPattern(concretePath)) {
                            actionPath = concretePath;
                            actionPath = StrutsSearchUtil.depatternActionString((IProject)project, (String)actionPath, null);
                        }
                        if (!targetModule.equals(actionModule) || !actionPath.equals(targetPath)) continue;
                        return target;
                    }
                } else {
                    return ((IResolvedReference)rrs.iterator().next()).getTarget();
                }
            }
        }
        return null;
    }

    public static IFile getFileForNode(MNode node) {
        ILink actionLink;
        if (StrutsProvider.isActionMapping((TypedElement)node) && (actionLink = (ILink)node.getAdapter(ILink.class)) != null) {
            return (IFile)actionLink.getContainer().getResource();
        }
        return WebProvider.getFileForNode((MNode)node);
    }

    public static MEdge getForwardEdgeForTargetByTypeAtIndex(String edgeType, MNode edgeTarget, String edgeName, List<MEdge> outgoingEdgesOnSourceNode, int itemIndexByType) {
        ArrayList<MEdge> sorted = new ArrayList<MEdge>();
        for (MEdge outGoingEdge : outgoingEdgesOnSourceNode) {
            String edgeIndexByType;
            String otherEdgeName = StrutsProvider.getStringProperty((String)"web.edgename.key", (IPropertyHolder)outGoingEdge);
            if (!edgeType.equals(outGoingEdge.getType()) || !edgeTarget.equals(outGoingEdge.getTarget()) || !edgeName.equals(otherEdgeName) || (edgeIndexByType = StrutsProvider.getStringProperty((String)"web.dup.index", (IPropertyHolder)outGoingEdge)) == null) continue;
            sorted.add(outGoingEdge);
        }
        Collections.sort(sorted, new Comparator<MEdge>(){

            @Override
            public int compare(MEdge edge1, MEdge edge2) {
                Integer edge1Index = Integer.valueOf(StrutsProvider.getStringProperty((String)"web.dup.index", (IPropertyHolder)edge1));
                Integer edge2Index = Integer.valueOf(StrutsProvider.getStringProperty((String)"web.dup.index", (IPropertyHolder)edge2));
                return edge1Index.compareTo(edge2Index);
            }
        });
        return itemIndexByType <= sorted.size() - 1 ? (MEdge)sorted.get(itemIndexByType) : null;
    }

    public static Compartment getForwardsCompartment(MNode node) {
        EList compartments = node.getCompartments();
        for (Compartment compartment : compartments) {
            if (!StrutsProvider.isForwardsCompartment(compartment)) continue;
            return compartment;
        }
        return null;
    }

    public static ILink getHandleForNode(CommonElement element) {
        ILink fromWeb = StrutsProvider.getHandleForNodeFromWeb(element);
        if (fromWeb == null && StrutsProvider.isActionMapping((TypedElement)element)) {
            return (ILink)element.getAdapter(ILink.class);
        }
        return fromWeb;
    }

    public static ILink getHandleForNodeFromWeb(CommonElement element) {
        if (StrutsProvider.isWebPageNode((TypedElement)element)) {
            return (ILink)element.getAdapter(ILink.class);
        }
        if (StrutsProvider.isWebApplicationNode((TypedElement)element)) {
            return (ILink)element.getAdapter(ILink.class);
        }
        return null;
    }

    public static String getItemTargetModule(Item sourceItem) {
        ILink sourceLink = (ILink)sourceItem.getAdapter(ILink.class);
        return StrutsSearchUtil.getModuleForLinkTarget((ILink)sourceLink, null);
    }

    public static final String getItemTargetPath(Item item) {
        ILink itemLink;
        if (item != null && (itemLink = (ILink)item.getAdapter(ILink.class)) != null) {
            if ("struts.exception.link".equals(itemLink.getSpecializedType().getId())) {
                if ((itemLink = StrutsSearchUtil.getExceptionPathLinkForException((ILink)itemLink)) == null) {
                    return null;
                }
                return AbstractWebProvider.trimQuotes((String)itemLink.getLinkText());
            }
            MNode parentNode = item.getNode();
            ILink parentNodeLink = (ILink)parentNode.getAdapter(ILink.class);
            if (parentNodeLink != null && parentNodeLink.getSpecializedType().getId().equals("struts.action.link")) {
                return new ActionMappingWildcardUtil(parentNodeLink.getContainer().getResource().getProject(), parentNodeLink.getName()).getConcreteAttributeValue(AbstractWebProvider.trimQuotes((String)itemLink.getLinkText()), StrutsProvider.getName((CommonElement)parentNode));
            }
            return AbstractWebProvider.trimQuotes((String)itemLink.getLinkText());
        }
        return "";
    }

    public static String getModuleName(CommonElement element) {
        String result = "";
        CommonElement testElement = element;
        if (StrutsProvider.isGlobalExceptionItem(testElement) || StrutsProvider.isGlobalForwardItem(testElement)) {
            testElement = ((Item)testElement).getNode().getParent();
        } else if (element.getType().equals("com.ibm.etools.model2.diagram.struts.StrutsGlobalNode")) {
            testElement = ((MNode)element).getParent();
        } else if (testElement instanceof Item) {
            testElement = ((Item)testElement).getNode();
        }
        if (StrutsProvider.isActionMapping((TypedElement)testElement) || StrutsProvider.isDiagram((TypedElement)testElement)) {
            result = StrutsProvider.getStringProperty((String)"struts.module.name.key", (IPropertyHolder)testElement);
            if (result == null || result.length() == 0) {
                result = "";
            }
        } else if (StrutsProvider.isWebPageNode((TypedElement)testElement)) {
            IPath fullTargetPath;
            Set modules = StrutsSearchUtil.getModulesForProject((IProject)StrutsProvider.getProjectForElement((CommonElement)testElement), null);
            IFile targetFile = StrutsProvider.getFileForNode((MNode)testElement);
            IVirtualComponent component = StrutsProvider.getVirtualComponent((EObject)testElement);
            IPath webRoot = Model2Util.getWorkspaceRelativeDocRootPath((IVirtualComponent)component);
            if (webRoot != null && targetFile != null && (fullTargetPath = targetFile.getFullPath()) != null) {
                if (fullTargetPath.segmentCount() > 0) {
                    fullTargetPath = fullTargetPath.removeLastSegments(1);
                }
                IPath targetModulePath = fullTargetPath.removeFirstSegments(webRoot.matchingFirstSegments(fullTargetPath));
                String targetModule = targetModulePath.toString();
                if (modules != null && targetModule != null) {
                    if (!targetModule.equals("") && !targetModule.startsWith("/")) {
                        targetModule = "/" + targetModule;
                    }
                    for (String m : modules) {
                        if (!m.equals(targetModule)) continue;
                        return targetModule;
                    }
                }
            }
        }
        return result;
    }

    public static String getName(CommonElement element) {
        return StrutsProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)element);
    }

    public static IFile getStrutsConfigFile(CommonElement node) {
        IFile[] files;
        String module = "";
        if (node instanceof MNode) {
            module = StrutsProvider.getModuleName((CommonElement)((MNode)node).getParent());
        }
        if ((files = ConfigFileIdentifierQuizMaster.getStrutsConfigFilesForModule((IVirtualComponent)WebProvider.getVirtualComponent((EObject)node), (String)module)).length > 0) {
            return files[0];
        }
        return null;
    }

    public static ILink getStrutsItemTargetLink(Item source) {
        return StrutsProvider.getStrutsItemTargetLink(source, null);
    }

    public static ILink getStrutsItemTargetLink(Item source, String concretePath) {
        ILink newSource = (ILink)source.getAdapter(ILink.class);
        if (newSource == null) {
            return null;
        }
        if ("struts.exception.link".equals(newSource.getSpecializedType().getId())) {
            newSource = StrutsSearchUtil.getExceptionPathLinkForException((ILink)newSource);
        }
        if (newSource == null) {
            return null;
        }
        String targetPath = null;
        targetPath = concretePath != null ? concretePath : StrutsProvider.getItemTargetPath(source);
        targetPath = URIUtil.parse((String)targetPath).path;
        ILink target = StrutsSearchUtil.getFileTarget((ILink)newSource, (String)targetPath);
        if (target == null) {
            target = StrutsProvider.getActionMappingTarget(source, concretePath);
        }
        return target;
    }

    public static IVirtualComponent getVirtualComponent(EObject element) {
        if (element.eResource() == null) {
            return null;
        }
        IFile diagramFile = WorkspaceSynchronizer.getFile((Resource)element.eResource());
        IVirtualComponent component = Model2Util.findComponent((IResource)diagramFile.getProject());
        return component;
    }

    public static boolean isActionClassPresent(IAdaptable adaptable) {
        ILink handle = (ILink)adaptable.getAdapter(ILink.class);
        if (handle != null) {
            return "type".equals(handle.getParameter("attributeParam"));
        }
        return false;
    }

    public static boolean isActionInDiagramModule(MNode node) {
        String nodeModule = StrutsProvider.getModuleName((CommonElement)node);
        String diagramModule = StrutsProvider.getModuleName((CommonElement)node.getParent());
        return nodeModule.equals(diagramModule);
    }

    public static boolean isActionInputEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.ActionInput".equals(element.getType());
    }

    public static boolean isActionInputItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.ActionInputItem".equals(element.getType());
    }

    public static boolean isActionMapping(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StrutsActionNode".equals(element.getType());
    }

    public static boolean isExceptionEdge(TypedElement element) {
        return element == null ? false : StrutsProvider.isGlobalExceptionEdge(element) || StrutsProvider.isLocalExceptionEdge(element);
    }

    public static boolean isExceptionItem(Object object) {
        TypedElement element;
        TypedElement typedElement = element = object instanceof TypedElement ? (TypedElement)object : null;
        return StrutsProvider.isLocalExceptionItem(element) || StrutsProvider.isGlobalExceptionItem(element);
    }

    public static boolean isFormBeanItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.FormBeanItem".equals(element.getType());
    }

    public static boolean isForwardEdge(TypedElement element) {
        return element == null ? false : StrutsProvider.isGlobalForwardEdge(element) || StrutsProvider.isLocalForwardEdge(element);
    }

    public static boolean isForwardItem(Object object) {
        TypedElement element;
        TypedElement typedElement = element = object instanceof TypedElement ? (TypedElement)object : null;
        return StrutsProvider.isLocalForwardItem(element) || StrutsProvider.isGlobalForwardItem(element);
    }

    public static boolean isForwardsCompartment(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.ForwardsCompartment".equals(element.getType());
    }

    public static boolean isGlobalActionMapping(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StrutsGlobalNode".equals(element.getType());
    }

    public static boolean isGlobalExceptionEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.GlobalException".equals(element.getType());
    }

    public static boolean isGlobalExceptionItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.GlobalExceptionItem".equals(element.getType());
    }

    public static boolean isGlobalForwardEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.GlobalForward".equals(element.getType());
    }

    public static boolean isGlobalForwardItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.GlobalForwardItem".equals(element.getType());
    }

    public static boolean isHtmlFormEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StrutsFormLink".equals(element.getType());
    }

    public static boolean isHtmlFormItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.HtmlFormItem".equals(element.getType());
    }

    public static boolean isHtmlLinkEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StrutsLink".equals(element.getType());
    }

    public static boolean isHtmlLinkItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.HtmlLinkItem".equals(element.getType());
    }

    public static boolean isLocalExceptionEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.LocalException".equals(element.getType());
    }

    public static boolean isLocalExceptionItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.LocalExceptionItem".equals(element.getType());
    }

    public static boolean isLocalForwardEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.LocalForward".equals(element.getType());
    }

    public static boolean isLocalForwardItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.LocalForwardItem".equals(element.getType());
    }

    public static boolean isStaticForwardEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StaticForward".equals(element.getType());
    }

    public static boolean isStaticForwardItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StaticForwardItem".equals(element.getType());
    }

    public static boolean isStaticIncludeEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StaticInclude".equals(element.getType());
    }

    public static boolean isStaticIncludeItem(Object object) {
        TypedElement element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : "com.ibm.etools.model2.diagram.struts.StaticIncludeItem".equals(element.getType());
    }

    public static boolean isStrutsEdge(TypedElement element) {
        return element == null ? false : StrutsProvider.isActionInputEdge(element) || StrutsProvider.isForwardEdge(element) || StrutsProvider.isExceptionEdge(element) || StrutsProvider.isHtmlFormEdge(element) || StrutsProvider.isHtmlLinkEdge(element) || StrutsProvider.isStaticForwardEdge(element) || StrutsProvider.isStaticIncludeEdge(element);
    }

    public static boolean isStrutsItem(Object object) {
        TypedElement element;
        TypedElement typedElement = element = object instanceof TypedElement ? (TypedElement)object : null;
        return element == null ? false : StrutsProvider.isForwardItem(element) || StrutsProvider.isExceptionItem(element) || StrutsProvider.isHtmlLinkItem(element) || StrutsProvider.isHtmlFormItem(element) || StrutsProvider.isStaticIncludeItem(element) || StrutsProvider.isStaticForwardItem(element) || StrutsProvider.isActionInputItem(element) || StrutsProvider.isFormBeanItem(element);
    }

    private static boolean isValidStrutsEditableItemTargetRequest(Item sourceItem, MNode target) {
        if (target.isRealized()) {
            String sourceModule = StrutsProvider.getModuleName((CommonElement)sourceItem);
            String targetModule = StrutsProvider.getModuleName((CommonElement)target);
            if (StrutsProvider.isHtmlFormItem(sourceItem)) {
                return sourceModule.equals(targetModule) && StrutsProvider.isActionMapping((TypedElement)target);
            }
            if (StrutsProvider.isExceptionItem(sourceItem) || StrutsProvider.isActionInputItem(sourceItem) || StrutsProvider.isStaticForwardItem(sourceItem) || StrutsProvider.isStaticIncludeItem(sourceItem)) {
                return sourceModule.equals(targetModule) || "".equals(sourceModule);
            }
            if (StrutsProvider.isForwardItem(sourceItem) || StrutsProvider.isHtmlLinkItem(sourceItem)) {
                return true;
            }
        } else {
            String sourceValue = StrutsProvider.getItemTargetPath(sourceItem);
            if (sourceValue == null || sourceValue.equals("")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidStrutsItemTargetRequest(CreateRelationshipRequest req) {
        if (req.getSource() instanceof Item) {
            Boolean existingEdgeTargetSame;
            Item sourceItem = (Item)req.getSource();
            MNode target = (MNode)req.getTarget();
            if (!(target == null || (existingEdgeTargetSame = (Boolean)req.getParameter("existing edge")) != null && existingEdgeTargetSame.booleanValue())) {
                return StrutsProvider.isValidStrutsWildcardItemTargetRequest(sourceItem, target);
            }
        }
        return true;
    }

    public static boolean isValidStrutsItemTargetRequest(ReorientRelationshipRequest req) {
        MNode target = ReorientEdgeCommand.getTargetNode((EObject)req.getNewRelationshipEnd());
        if (target != null) {
            MEdge edge = (MEdge)req.getRelationship();
            MNode source = edge.getSource();
            Compartment links = null;
            links = StrutsProvider.isWebPageNode((TypedElement)source) ? StrutsProvider.getLinksCompartment((MNode)edge.getSource()) : (StrutsProvider.isActionMapping((TypedElement)source) ? StrutsProvider.getForwardsCompartment(source) : StrutsProvider.getForwardsCompartment(source));
            Item sourceItem = EdgeGeneratorService.getInstance().getEdgesItem(Collections.singletonList(links), edge);
            if (sourceItem != null) {
                return StrutsProvider.isValidStrutsWildcardItemTargetRequest(sourceItem, target);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidStrutsWildcardItemTargetRequest(Item sourceItem, MNode target) {
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            ILink sourceNodeHandle = (ILink)sourceItem.getNode().getAdapter(ILink.class);
            if (StrutsProvider.isActionMapping((TypedElement)sourceItem.getNode()) && sourceNodeHandle != null && new ActionMappingWildcardUtil(sourceNodeHandle.getContainer().getResource().getProject(), sourceNodeHandle.getName()).actionHasWildcards()) {
                String sourceTargetPath = StrutsSearchUtil.depatternActionString((IProject)((ILink)sourceItem.getAdapter(ILink.class)).getContainer().getResource().getProject(), (String)StrutsProvider.getItemTargetPath(sourceItem), null);
                if (sourceTargetPath == null || sourceTargetPath.isEmpty()) return true;
                boolean sourceItemTargetsMapping = StrutsProvider.targetPathIsAnActionPath(sourceTargetPath);
                String targetModule = StrutsProvider.getModuleName((CommonElement)target);
                String sourceModule = StrutsProvider.getModuleName((CommonElement)sourceItem);
                if (StrutsProvider.isWebPageNode((TypedElement)target) && !sourceItemTargetsMapping) {
                    IFile targetFile = StrutsProvider.getFileForNode(target);
                    String targetLocation = targetFile.getFullPath().toString();
                    boolean bl = targetLocation != null && targetModule != null && targetModule.equals(sourceModule) && targetLocation.endsWith(sourceTargetPath);
                    return bl;
                }
                if (!StrutsProvider.isActionMapping((TypedElement)target) || !sourceItemTargetsMapping) return false;
                String targetMapping = StrutsProvider.getName((CommonElement)target);
                boolean bl = targetModule != null && targetMapping != null && targetModule.equals(sourceModule) && targetMapping.equals(sourceTargetPath);
                return bl;
            }
            boolean bl = StrutsProvider.isValidStrutsEditableItemTargetRequest(sourceItem, target);
            return bl;
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public static boolean openOnlyOneAndWildcardTypeDialog(String type) {
        Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), -1, NLS.bind((String)Messages.ThereCanOnlyBeOne1PerNodeAndWildcard, (Object)type), null);
        StatusManager.getManager().handle((IStatus)status, 4);
        return false;
    }

    public static boolean openOnlyOneTypeDialog(String type) {
        Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), -1, NLS.bind((String)Messages.ThereCanOnlyBeOne1PerNode, (Object)type), null);
        StatusManager.getManager().handle((IStatus)status, 4);
        return false;
    }

    public static void refreshNode(MNode element) {
        StrutsProvider.asyncRefreshNode((MNode)element);
    }

    public static void setForwardEdgeIndexByType(MNode source, MEdge edge, String forwardName) {
        if (forwardName != null) {
            int maxIndex = -1;
            MNode target = edge.getTarget();
            EList outputs = source.getOutput();
            for (MEdge possibleDup : outputs) {
                int possibleDupIndex;
                if (possibleDup == edge || !edge.getType().equals(possibleDup.getType()) || !target.equals(possibleDup.getTarget()) || (possibleDupIndex = Integer.parseInt(StrutsProvider.getStringProperty((String)"web.dup.index", (IPropertyHolder)possibleDup))) < maxIndex) continue;
                maxIndex = possibleDupIndex;
            }
            Property property = DiagramModelFactory.eINSTANCE.createProperty();
            property.setName("web.dup.index");
            property.setValue(Integer.toString(++maxIndex));
            edge.getPersistedProperties().add((Object)property);
        } else {
            WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
        }
    }

    public static boolean targetPathIsAnActionPath(String inputString) {
        if (inputString != null && inputString.length() > 0) {
            return !inputString.endsWith(".jsp") && !inputString.endsWith(".html") && !inputString.endsWith(".htm");
        }
        return false;
    }

    public boolean provides(IOperation operation) {
        return false;
    }
}

