/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateActionInputResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateGlobalExceptionResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateGlobalForwardResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateLocalExceptionResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateLocalForwardResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStaticForwardResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStaticIncludeResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStrutsFormResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStrutsLinkResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateActionInputResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateExceptionPathResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateForwardPathResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStaticForwardResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStaticIncludeResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStrutsSourceResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.nodes.CreateActionMappingResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateDupIndexProperty;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgeNameProperty;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.RefreshEdgeRealizationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.jspeditor.vct.dialog.ActionDialogElement;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;

public class RealizeActionCommand
extends CompositeCommand
implements IWorkspaceLockMarker {
    public RealizeActionCommand(TransactionalEditingDomain domain, MNode node, Object newValue, boolean createResource) {
        super(Messages.CreateStrutsAction);
        String targetPath = this.getTargetPath(newValue, node);
        if (StrutsProvider.isActionMapping((TypedElement)node)) {
            if (createResource) {
                CreateActionMappingResourceCommand cmd = new CreateActionMappingResourceCommand(node);
                this.compose((IUndoableOperation)cmd);
            } else {
                node.removeAdapter(ILink.class);
                node.removeAdapter(IFile.class);
                this.compose((IUndoableOperation)IdentityCommand.INSTANCE);
            }
        } else {
            this.compose((IUndoableOperation)IdentityCommand.INSTANCE);
        }
        if (createResource) {
            EList inputEdges = node.getInput();
            for (MEdge edge : inputEdges) {
                if (!edge.getSource().isRealized() || !StrutsProvider.isStrutsEdge((TypedElement)edge)) continue;
                String targetModule = StrutsProvider.getModuleName((CommonElement)edge.getTarget());
                targetPath = StrutsTargetUtilities.getTargetNodePath(edge.getSource(), edge.getTarget());
                this.addEdgeRealizationCommands(domain, edge, targetPath, targetModule);
            }
            EList outputEdges = node.getOutput();
            for (MEdge edge : outputEdges) {
                if (!edge.getTarget().isRealized() || !StrutsProvider.isStrutsEdge((TypedElement)edge)) continue;
                String targetModule = StrutsProvider.getModuleName((CommonElement)edge.getTarget());
                targetPath = StrutsTargetUtilities.getTargetNodePath(edge.getSource(), edge.getTarget());
                this.addEdgeRealizationCommands(domain, edge, targetPath, targetModule);
            }
        }
    }

    private void addEdgeRealizationCommands(TransactionalEditingDomain domain, MEdge edge, String targetPath, String targetModule) {
        Item item = EdgeGeneratorService.getInstance().getEdgesItem((List)edge.getSource().getCompartments(), edge);
        ILink itemLink = null;
        if (item != null) {
            itemLink = (ILink)item.getAdapter(ILink.class);
        }
        if (StrutsProvider.isActionInputEdge((TypedElement)edge)) {
            UpdateEdgeNameProperty updateEdgeProperties = new UpdateEdgeNameProperty(domain, edge, targetPath, null, false);
            this.compose((IUndoableOperation)updateEdgeProperties);
            if (item != null) {
                UpdateActionInputResourceCommand cmd = new UpdateActionInputResourceCommand((IAdaptable)item.getNode(), targetPath, null);
                this.compose((IUndoableOperation)cmd);
            } else {
                CreateActionInputResourceCommand cmd = new CreateActionInputResourceCommand(targetPath, (IAdaptable)edge.getSource());
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isStaticForwardEdge((TypedElement)edge)) {
            UpdateEdgeNameProperty updateEdgeProperties = new UpdateEdgeNameProperty(domain, edge, targetPath, null, false);
            this.compose((IUndoableOperation)updateEdgeProperties);
            if (item != null) {
                UpdateStaticForwardResourceCommand cmd = new UpdateStaticForwardResourceCommand((IAdaptable)item.getNode(), targetPath, null);
                this.compose((IUndoableOperation)cmd);
            } else {
                CreateStaticForwardResourceCommand cmd = new CreateStaticForwardResourceCommand(targetPath, (IAdaptable)edge.getSource());
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isStaticIncludeEdge((TypedElement)edge)) {
            UpdateEdgeNameProperty updateEdgeProperties = new UpdateEdgeNameProperty(domain, edge, targetPath, null, false);
            this.compose((IUndoableOperation)updateEdgeProperties);
            if (item != null) {
                UpdateStaticIncludeResourceCommand cmd = new UpdateStaticIncludeResourceCommand((IAdaptable)item.getNode(), targetPath, null);
                this.compose((IUndoableOperation)cmd);
            } else {
                CreateStaticIncludeResourceCommand cmd = new CreateStaticIncludeResourceCommand(targetPath, (IAdaptable)edge.getSource(), false);
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isGlobalExceptionEdge((TypedElement)edge)) {
            String exceptionClass = "java.lang.Exception";
            String edgeName = WebProvider.getStringProperty((String)"web.edgename.key", (IPropertyHolder)edge);
            if (edgeName != null) {
                exceptionClass = edgeName;
            }
            UpdateEdgeNameProperty updateEdgeProperties = new UpdateEdgeNameProperty(domain, edge, exceptionClass, null, true);
            this.compose((IUndoableOperation)updateEdgeProperties);
            if (item != null) {
                UpdateExceptionPathResourceCommand cmd = new UpdateExceptionPathResourceCommand((IAdaptable)item, targetPath, null);
                this.compose((IUndoableOperation)cmd);
            } else {
                CreateGlobalExceptionResourceCommand cmd = new CreateGlobalExceptionResourceCommand(exceptionClass, targetPath, edge.getSource(), false);
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isLocalExceptionEdge((TypedElement)edge)) {
            String exceptionClass = "java.lang.Exception";
            String edgeName = WebProvider.getStringProperty((String)"web.edgename.key", (IPropertyHolder)edge);
            if (edgeName != null) {
                exceptionClass = edgeName;
            }
            UpdateEdgeNameProperty updateEdgeProperties = new UpdateEdgeNameProperty(domain, edge, exceptionClass, null, true);
            this.compose((IUndoableOperation)updateEdgeProperties);
            if (item != null) {
                UpdateExceptionPathResourceCommand cmd = new UpdateExceptionPathResourceCommand((IAdaptable)item, targetPath, null);
                this.compose((IUndoableOperation)cmd);
            } else {
                CreateLocalExceptionResourceCommand cmd = new CreateLocalExceptionResourceCommand(exceptionClass, targetPath, (IAdaptable)edge.getSource(), false);
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isLocalForwardEdge((TypedElement)edge)) {
            if (itemLink != null) {
                boolean hasText;
                String trimmed = AbstractWebProvider.trimQuotes((String)itemLink.getLinkText());
                boolean bl = hasText = trimmed != null;
                if (item != null && hasText) {
                    UpdateForwardPathResourceCommand cmd = new UpdateForwardPathResourceCommand((IAdaptable)item, targetPath, targetModule, null);
                    this.compose((IUndoableOperation)cmd);
                } else {
                    CreateLocalForwardResourceCommand cmd = new CreateLocalForwardResourceCommand(domain, null, (IAdaptable)edge.getSource(), edge, true);
                    this.compose((IUndoableOperation)cmd);
                }
            } else {
                CreateLocalForwardResourceCommand cmd = new CreateLocalForwardResourceCommand(domain, null, (IAdaptable)edge.getSource(), edge, false);
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isGlobalForwardEdge((TypedElement)edge)) {
            if (itemLink != null) {
                boolean hasText;
                String trimmed = AbstractWebProvider.trimQuotes((String)itemLink.getLinkText());
                boolean bl = hasText = trimmed != null;
                if (item != null && hasText) {
                    UpdateForwardPathResourceCommand cmd = new UpdateForwardPathResourceCommand((IAdaptable)item, targetPath, targetModule, null);
                    this.compose((IUndoableOperation)cmd);
                } else {
                    CreateGlobalForwardResourceCommand cmd = new CreateGlobalForwardResourceCommand(domain, null, targetPath, (IAdaptable)edge.getSource(), edge, true);
                    this.compose((IUndoableOperation)cmd);
                }
            } else {
                CreateGlobalForwardResourceCommand cmd = new CreateGlobalForwardResourceCommand(domain, null, targetPath, (IAdaptable)edge.getSource(), edge, false);
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isHtmlFormEdge((TypedElement)edge)) {
            if (item != null) {
                UpdateStrutsSourceResourceCommand cmd = new UpdateStrutsSourceResourceCommand((IAdaptable)item, targetPath, targetModule, edge.getTarget(), null);
                this.compose((IUndoableOperation)cmd);
            } else {
                if (edge.getSource().isRealized()) {
                    boolean hasUntargetted = this.hasUntargetted(edge, false);
                    if (hasUntargetted) {
                        UpdateDupIndexProperty updateindex = new UpdateDupIndexProperty(domain, edge, "0", null, true);
                        this.compose((IUndoableOperation)updateindex);
                    } else {
                        this.addUpdateDupIndexCommand(domain, edge);
                    }
                } else {
                    this.addUpdateDupIndexCommand(domain, edge);
                }
                IFile file = WebProvider.getFileForNode((MNode)edge.getSource());
                CreateStrutsFormResourceCommand cmd = new CreateStrutsFormResourceCommand(file, targetPath, false);
                this.compose((IUndoableOperation)cmd);
            }
        } else if (StrutsProvider.isHtmlLinkEdge((TypedElement)edge)) {
            String pathTargetModule;
            if (targetPath != null && targetModule != null && (pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)item), (String)targetPath)).equals(targetModule)) {
                targetPath = targetPath.substring(targetModule.length());
            }
            if (item != null) {
                IProject project = WebProvider.getProjectForElement((CommonElement)edge);
                UpdateStrutsSourceResourceCommand cmd = null;
                cmd = StrutsProjectCoreUtil.isStruts1_1((IProject)project) ? new UpdateStrutsSourceResourceCommand((IAdaptable)item, String.valueOf(targetModule) + targetPath, null, edge.getTarget(), null) : new UpdateStrutsSourceResourceCommand((IAdaptable)item, targetPath, targetModule, edge.getTarget(), null);
                this.compose((IUndoableOperation)cmd);
            } else {
                CreateStrutsLinkResourceCommand cmd = new CreateStrutsLinkResourceCommand(edge.getSource(), edge.getTarget(), false);
                if (edge.getSource().isRealized()) {
                    boolean hasUntargetted = this.hasUntargetted(edge, true);
                    if (hasUntargetted) {
                        UpdateDupIndexProperty updateindex = new UpdateDupIndexProperty(domain, edge, "0", null, true);
                        this.compose((IUndoableOperation)updateindex);
                    } else {
                        this.addUpdateDupIndexCommand(domain, edge);
                    }
                } else {
                    this.addUpdateDupIndexCommand(domain, edge);
                }
                this.compose((IUndoableOperation)cmd);
            }
        }
        this.compose((IUndoableOperation)new RefreshEdgeRealizationCommand(edge));
    }

    private void addUpdateDupIndexCommand(TransactionalEditingDomain domain, MEdge edge) {
        int dupIndex = 0;
        EList outputs = edge.getSource().getOutput();
        for (MEdge outputEdge : outputs) {
            if (edge == outputEdge) break;
            ++dupIndex;
        }
        UpdateDupIndexProperty updateindex = new UpdateDupIndexProperty(domain, edge, Integer.toString(dupIndex), null, true);
        this.compose((IUndoableOperation)updateindex);
    }

    private String getTargetPath(Object newValue, MNode node) {
        IFile file;
        IPath path;
        if (newValue instanceof String) {
            if (StrutsProvider.isActionMapping((TypedElement)node)) {
                String modulePrefix = StrutsProvider.getModuleName((CommonElement)node);
                String path2 = (String)newValue;
                String pathTargetModule = StrutsSearchUtil.parseModuleFromPath((IProject)WebProvider.getProjectForElement((CommonElement)node), (String)path2);
                if (modulePrefix != null && !"".equals(modulePrefix) && pathTargetModule.equals(modulePrefix)) {
                    path2 = path2.substring(modulePrefix.length());
                }
                return path2;
            }
            if (WebProvider.isWebPageNode((TypedElement)node)) {
                String s = (String)newValue;
                if (s.length() > 0 && s.charAt(0) != '/') {
                    s = String.valueOf('/') + s;
                }
                return s;
            }
            return (String)newValue;
        }
        if (newValue instanceof ILink) {
            String name = ((ILink)newValue).getName();
            return name;
        }
        if (newValue instanceof ActionDialogElement) {
            return ((ActionDialogElement)newValue).getPath();
        }
        if (newValue instanceof IFile && (path = Model2Util.getDocRootRelativePath((IFile)(file = (IFile)newValue))) != null) {
            String name = path.toString();
            return name;
        }
        return null;
    }

    private boolean hasUntargetted(MEdge edge, boolean linkItem) {
        boolean hasUntargetted = false;
        MNode source = edge.getSource();
        Iterator iter = source.getCompartments().iterator();
        block0: while (iter.hasNext() && !hasUntargetted) {
            Compartment compartment = (Compartment)iter.next();
            if (!WebProvider.isLinkCompartment((TypedElement)compartment)) continue;
            for (Item aItem : compartment.getItems()) {
                ILink handle = (ILink)aItem.getAdapter(ILink.class);
                if (handle == null) continue;
                String rawLink = AbstractWebProvider.trimQuotes((String)handle.getLinkText());
                if (linkItem) {
                    if (!StrutsProvider.isHtmlLinkItem(aItem) || rawLink != null && !"".equals(rawLink) && !"/".equals(rawLink)) continue;
                    hasUntargetted = true;
                    continue block0;
                }
                if (!StrutsProvider.isHtmlFormItem(aItem) || rawLink != null && !"".equals(rawLink)) continue;
                hasUntargetted = true;
            }
        }
        return hasUntargetted;
    }
}

