/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.osgi.util.NLS;

public class DeleteActionMappingCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private IFile file;
    private IFile javaClassFile;
    private final DestroyElementRequest request;
    private StrutsChangeCommand strutsChangeCommand;

    public DeleteActionMappingCommand(String label, DestroyElementRequest request) {
        super(label);
        this.request = request;
    }

    public boolean canExecute() {
        if (this.getNode().isRealized()) {
            return super.canExecute();
        }
        return true;
    }

    private void deleteActionMapping(IProgressMonitor progressMonitor) {
        IFile strutsConfig;
        final ILink actionMappingHandle = (ILink)this.getNode().getAdapter(ILink.class);
        if (actionMappingHandle != null && (strutsConfig = this.getFileToModify()) != null && strutsConfig.exists()) {
            String concreteActionName = WebProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)this.getNode());
            this.javaClassFile = this.getJavaClassFile(actionMappingHandle, concreteActionName);
            List resourcesToDelete = (List)this.request.getParameter("resources to delete");
            if (resourcesToDelete != null) {
                boolean found = false;
                for (Object o : resourcesToDelete) {
                    if (!(o instanceof ILink)) continue;
                    ILink linkToDelete = (ILink)o;
                    if (!actionMappingHandle.getName().equals(linkToDelete.getName())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

                        @Override
                        protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                            ActionMapping mapping = (ActionMapping)StrutsLinksSearchUtil.getCorrespondingEObject((EClass)StrutsconfigPackage.eINSTANCE.getActionMapping(), (EObject)strutsConfig, (ILink)actionMappingHandle);
                            if (mapping != null) {
                                strutsConfig.getActionMappings().remove((Object)mapping);
                            }
                            return true;
                        }
                    };
                    this.strutsChangeCommand = StrutsChangeCommand.getStrutsCommand(strutsConfig, changes, true);
                    if (this.strutsChangeCommand != null) {
                        this.strutsChangeCommand.execute();
                    }
                }
                if (this.javaClassFile != null && resourcesToDelete.contains(this.javaClassFile)) {
                    try {
                        this.javaClassFile.delete(true, true, progressMonitor);
                    }
                    catch (CoreException e) {
                        DiagramStrutsPlugin.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.deleteActionMapping(progressMonitor);
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null && this.strutsChangeCommand.canUndo()) {
            this.strutsChangeCommand.undo();
        }
        if (this.javaClassFile != null) {
            try {
                IFileState[] state = this.javaClassFile.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.javaClassFile.create(state[0].getContents(), false, progressMonitor);
                }
            }
            catch (CoreException e) {
                StrutsPlugin.getDefault().getLog().log(e.getStatus());
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public ResourceTree getDeletionTree() {
        ResourceTree tree = new ResourceTree();
        ILink actionMappingLink = (ILink)this.getNode().getAdapter(ILink.class);
        if (actionMappingLink != null) {
            ActionMappingWildcardUtil wcUtil;
            String concreteActionName = WebProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)this.getNode());
            IFile javaClass = this.getJavaClassFile(actionMappingLink, concreteActionName);
            ResourceDescriptor classResource = null;
            if (javaClass != null && javaClass.exists()) {
                classResource = new ResourceDescriptor((Object)javaClass);
                classResource.setDisplayText(NLS.bind((String)Messages.RemoveActionClassX, (Object)javaClass.getProjectRelativePath().makeAbsolute().toString()));
            }
            if (!(wcUtil = new ActionMappingWildcardUtil(actionMappingLink.getContainer().getResource().getProject(), actionMappingLink.getName())).actionHasWildcards()) {
                ResourceDescriptor mappingResource = new ResourceDescriptor((Object)actionMappingLink);
                IFile file = (IFile)actionMappingLink.getContainer().getResource();
                mappingResource.setDisplayText(NLS.bind((String)Messages.RemoveActionXinX, (Object)actionMappingLink.getName(), (Object)file.getProjectRelativePath().makeAbsolute().toString()));
                tree.addChild(mappingResource);
            }
            if (classResource != null) {
                tree.addChild(classResource);
            }
            if (tree.recursiveSize() > 0) {
                return tree;
            }
        }
        return null;
    }

    protected IFile getFileToModify() {
        ILink actionMappingHandle;
        if (this.file == null && (actionMappingHandle = (ILink)this.getNode().getAdapter(ILink.class)) != null) {
            return (IFile)actionMappingHandle.getContainer().getResource();
        }
        return this.file;
    }

    private IFile getJavaClassFile(ILink actionMappingLink, String concreteActionName) {
        LinkNode container;
        String rawType;
        ActionMappingWildcardUtil wcUtil;
        String concreteType;
        ILink target;
        if (actionMappingLink != null && (target = StrutsSearchUtil.getActionJavaTarget((ILink)actionMappingLink, (String)(concreteType = (wcUtil = new ActionMappingWildcardUtil(actionMappingLink.getContainer().getResource().getProject(), actionMappingLink.getName())).getConcreteAttributeValue(rawType = AbstractWebProvider.trimQuotes((String)actionMappingLink.getLinkText()), concreteActionName)))) != null && (container = target.getContainer()) != null) {
            return (IFile)container.getResource();
        }
        return null;
    }

    private MNode getNode() {
        return (MNode)this.request.getElementToDestroy();
    }
}

