/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.items;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.requests.CreateNonModelElementRequest;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.StrutsChangeCommand;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.dialog.FormBeanSelectionDialog;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.RequestScope;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CreateStrutsFormBeanCommand
extends ResourceModificationCommand {
    private final CreateNonModelElementRequest request;
    private StrutsChangeCommand strutsChangeCommand;

    public CreateStrutsFormBeanCommand(String label, CreateNonModelElementRequest request) {
        super(label);
        this.request = request;
    }

    public void dispose() {
        super.dispose();
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.dispose();
        }
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        String webModulePath;
        final MNode actionMapping = (MNode)this.request.getContainer();
        final String moduleName = StrutsProvider.getModuleName((CommonElement)actionMapping);
        ILink actionMappingHandle = (ILink)actionMapping.getAdapter(ILink.class);
        IVirtualComponent component = Model2Util.findComponent((IResource)actionMappingHandle.getContainer().getResource());
        final String actionMappingName = WebProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)actionMapping);
        ILink formBeanHandle = StrutsSearchUtil.getFormBeanLinkForAction((ILink)actionMappingHandle);
        if (formBeanHandle != null) {
            Status error = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), -1, Messages.OnlyOneFormBeanPerAction, null);
            StatusManager.getManager().handle((IStatus)error, 4);
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        final boolean[] canceled = new boolean[1];
        final String[] nameHolder = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FormBeanSelectionDialog dialog1 = new FormBeanSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), WebProvider.getProjectForElement((CommonElement)actionMapping), moduleName);
                if (dialog1.open() != 0) {
                    canceled[0] = true;
                } else {
                    canceled[0] = false;
                    ILink selectedHandle = (ILink)dialog1.getResult()[0];
                    nameHolder[0] = selectedHandle.getName();
                }
            }
        });
        if (canceled[0]) {
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        IFile strutsConfigFile = (IFile)actionMappingHandle.getContainer().getResource();
        String fullPath = strutsConfigFile.getProjectRelativePath().makeAbsolute().toString();
        if (fullPath.startsWith(webModulePath = Model2Util.getProjectRelativeDocRootPath((IVirtualComponent)component).toString())) {
            StrutsChangeCommand.StrutsChanges changes = new StrutsChangeCommand.StrutsChanges(){

                @Override
                protected boolean doStrutsChanges(StrutsConfig strutsConfig) {
                    for (ActionMapping actionMapping : strutsConfig.getActionMappings()) {
                        if (!actionMapping.getPath().equals(actionMappingName)) continue;
                        actionMapping.setName(nameHolder[0]);
                        actionMapping.setScope(RequestScope.get((String)"request"));
                        return true;
                    }
                    return false;
                }
            };
            this.strutsChangeCommand = StrutsChangeCommand.getStrutsCommand(strutsConfigFile, changes, true);
            if (this.strutsChangeCommand != null) {
                this.strutsChangeCommand.execute();
            }
        }
        Collection c = EMFCoreUtil.getReferencers((EObject)actionMapping, null);
        for (EObject object : c) {
            if (!(object instanceof Node)) continue;
            Node n = (Node)object;
            EList children = n.getChildren();
            for (View v : children) {
                DrawerStyle style;
                if (!WebProvider.isDataCompartment((TypedElement)((TypedElement)v.getElement())) || (style = (DrawerStyle)v.getStyle(NotationPackage.eINSTANCE.getDrawerStyle())) == null || !style.isCollapsed()) continue;
                style.setCollapsed(false);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null) {
            this.strutsChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.strutsChangeCommand != null && this.strutsChangeCommand.canUndo()) {
            this.strutsChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected IFile getFileToModify() {
        MNode actionMapping = (MNode)this.request.getContainer();
        ILink actionMappingHandle = (ILink)actionMapping.getAdapter(ILink.class);
        if (actionMappingHandle == null) {
            return null;
        }
        return (IFile)actionMappingHandle.getContainer().getResource();
    }
}

