/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateActionInputResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateExceptionPathResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateForwardPathResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStaticForwardResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStaticIncludeResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStrutsSourceResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;

public class DeleteActionMappingReferencesCommand
extends AbstractCommand
implements IWorkspaceLockMarker {
    private final MEdge edge;
    private IFile file;
    private final List<ResourceModificationCommand> cmds = new ArrayList<ResourceModificationCommand>();

    public DeleteActionMappingReferencesCommand(MEdge edge) {
        super(Messages.DeleteReferences);
        this.edge = edge;
    }

    public void dispose() {
        for (ICommand iCommand : this.cmds) {
            iCommand.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IFile file;
        this.cmds.clear();
        NodeItem item = (NodeItem)EdgeGeneratorService.getInstance().getEdgesItem((List)this.edge.getSource().getCompartments(), this.edge);
        if (item != null && (file = this.getFile(item.getNode())) != null) {
            if (StrutsProvider.isForwardItem(item)) {
                UpdateForwardPathResourceCommand updateForwardPathResourceCommand = new UpdateForwardPathResourceCommand((IAdaptable)item, "", null, null);
                this.cmds.add(updateForwardPathResourceCommand);
            }
            if (StrutsProvider.isExceptionItem(item)) {
                UpdateExceptionPathResourceCommand updateExceptionPathResourceCommand = new UpdateExceptionPathResourceCommand((IAdaptable)item, "", null);
                this.cmds.add(updateExceptionPathResourceCommand);
            }
            if (StrutsProvider.isActionInputItem(item)) {
                UpdateActionInputResourceCommand updateActionInputResourceCommand = new UpdateActionInputResourceCommand((IAdaptable)item.getNode(), "", null);
                this.cmds.add(updateActionInputResourceCommand);
            }
            if (StrutsProvider.isStaticForwardItem(item)) {
                UpdateStaticForwardResourceCommand updateStaticForwardResourceCommand = new UpdateStaticForwardResourceCommand((IAdaptable)item.getNode(), "", null);
                this.cmds.add(updateStaticForwardResourceCommand);
            }
            if (StrutsProvider.isStaticIncludeItem(item)) {
                UpdateStaticIncludeResourceCommand updateStaticIncludeResourceCommand = new UpdateStaticIncludeResourceCommand((IAdaptable)item.getNode(), "", null);
                this.cmds.add(updateStaticIncludeResourceCommand);
            }
            if (StrutsProvider.isHtmlFormItem(item) || StrutsProvider.isHtmlLinkItem(item)) {
                UpdateStrutsSourceResourceCommand updateStrutsSourceResourceCommand = new UpdateStrutsSourceResourceCommand((IAdaptable)item, "", null, this.edge.getTarget(), null);
                this.cmds.add(updateStrutsSourceResourceCommand);
            }
        }
        for (ICommand iCommand : this.cmds) {
            iCommand.execute(progressMonitor, info);
            if (iCommand.getCommandResult().getStatus().isOK()) continue;
            return iCommand.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        for (ICommand iCommand : this.cmds) {
            iCommand.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        for (ICommand iCommand : this.cmds) {
            iCommand.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    private IFile getFile(MNode node) {
        if (this.file == null) {
            this.file = StrutsProvider.getStrutsConfigFile((CommonElement)node);
        }
        return this.file;
    }
}

