/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineerConstants;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStrutsFormResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStrutsSourceResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgeNameProperty;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgePropertyCommand;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.ui.statushandlers.StatusManager;

public class CreateStrutsFormCommand
extends AbstractTransactionalCommand
implements IWorkspaceLockMarker {
    private final CreateRelationshipRequest request;
    private AbstractCommand updateSource;
    private boolean askedRetargetAndAffirmative;

    public CreateStrutsFormCommand(String label, CreateRelationshipRequest request) {
        super(request.getEditingDomain(), label, CreateStrutsFormCommand.getWorkspaceFiles((List)request.getElementsToEdit()));
        this.request = request;
    }

    public void dispose() {
        if (this.updateSource != null) {
            this.updateSource.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        String targetModule;
        MEdge edge = (MEdge)this.request.getNewElement();
        MNode target = edge.getTarget();
        MNode source = edge.getSource();
        String targetString = null;
        IFile sourceFile = StrutsProvider.getFileForNode(source);
        String sourceModule = StrutsSearchUtil.getModuleForIFile((IFile)sourceFile, null);
        if (!sourceModule.equals(targetModule = StrutsProvider.getModuleName((CommonElement)target))) {
            if (Boolean.TRUE.equals(this.request.getParameter(ReverseEngineerConstants.REVERSE_ENGINEERING))) {
                return CommandResult.newOKCommandResult();
            }
            Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.CannotCreateStrutsFormLinksInDiffModule, null);
            StatusManager.getManager().handle((IStatus)status, 4);
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        targetString = StrutsTargetUtilities.getTargetNodePath(source, target);
        IFile file = WebProvider.getFileForNode((MNode)source);
        Boolean isExisting = (Boolean)this.request.getParameter("existing edge");
        if (isExisting == null || !isExisting.booleanValue()) {
            if (source.isRealized()) {
                ILink handle;
                if (!target.isRealized()) {
                    targetString = "";
                }
                ArrayList<MEdge> existingEdges = new ArrayList<MEdge>();
                boolean retargettingEdge = false;
                NodeItem sourceItem = (NodeItem)this.request.getParameter("source node item");
                String rawPath = StrutsProvider.getItemTargetPath((Item)sourceItem);
                String query = "";
                if (rawPath != null) {
                    query = URIUtil.parse((String)rawPath).query;
                    query = query != null && !query.isEmpty() ? "?" + query : "";
                }
                targetString = String.valueOf(targetString) + query;
                ILink oldTargetLink = null;
                if (sourceItem != null && (handle = (ILink)sourceItem.getAdapter(ILink.class)) != null) {
                    oldTargetLink = StrutsProvider.getStrutsItemTargetLink((Item)sourceItem);
                }
                if (sourceItem != null) {
                    List itemTarges = EdgeGeneratorService.getInstance().getItemsEdges((Item)sourceItem);
                    for (MEdge existingEdge : itemTarges) {
                        if (target.equals(existingEdge.getTarget())) continue;
                        retargettingEdge = true;
                        existingEdges.add(existingEdge);
                    }
                    if (!retargettingEdge) {
                        boolean bl = retargettingEdge = oldTargetLink != null && !oldTargetLink.equals(edge.getTarget().getAdapter(ILink.class));
                    }
                }
                if (retargettingEdge) {
                    boolean allowRetarget;
                    boolean bl = allowRetarget = !this.askedRetargetAndAffirmative ? WebProvider.allowRetargetDialog() : this.askedRetargetAndAffirmative;
                    if (!allowRetarget) {
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    this.askedRetargetAndAffirmative = true;
                    MNode oldTarget = null;
                    List edges = EdgeGeneratorService.getInstance().getItemsEdges((Item)sourceItem);
                    if (edges.size() == 1) {
                        oldTarget = ((MEdge)edges.get(0)).getTarget();
                    }
                    if (oldTarget != null && oldTarget.getAdapter(ILink.class) != null) {
                        oldTargetLink = (ILink)oldTarget.getAdapter(ILink.class);
                    }
                    for (MEdge existingEdge : existingEdges) {
                        DestroyElementRequest request = new DestroyElementRequest((EObject)existingEdge, false);
                        ICommand deleteCommand = existingEdge.getElementType().getEditCommand((IEditCommandRequest)request);
                        deleteCommand.execute(progressMonitor, info);
                        if (deleteCommand.getCommandResult().getStatus().isOK()) continue;
                        return deleteCommand.getCommandResult();
                    }
                    this.updateSource = new UpdateStrutsSourceResourceCommand((IAdaptable)sourceItem, targetString, null, target, null);
                    this.updateSource.execute(progressMonitor, info);
                    if (!this.updateSource.getCommandResult().getStatus().isOK()) {
                        return this.updateSource.getCommandResult();
                    }
                    WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                } else {
                    if (target.isRealized()) {
                        if (sourceItem == null) {
                            this.updateSource = new CreateStrutsFormResourceCommand(file, targetString, true);
                            this.updateSource.execute(progressMonitor, info);
                            if (!this.updateSource.getCommandResult().getStatus().isOK()) {
                                return this.updateSource.getCommandResult();
                            }
                        } else {
                            this.updateSource = new UpdateStrutsSourceResourceCommand((IAdaptable)sourceItem, targetString, null, target, null);
                            this.updateSource.execute(progressMonitor, info);
                            if (!this.updateSource.getCommandResult().getStatus().isOK()) {
                                return this.updateSource.getCommandResult();
                            }
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)edge, (String)"web.edgename.key", (String)targetString, null, (boolean)true);
                        }
                    }
                    WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                }
            } else {
                IStatus status = StrutsProvider.checkNewEdgeValidity(edge);
                if (status.getSeverity() != 0) {
                    StatusManager.getManager().handle(status, 4);
                    progressMonitor.setCanceled(true);
                    return CommandResult.newCancelledCommandResult();
                }
            }
        } else if (target.isRealized()) {
            SourceReference reference = (SourceReference)this.request.getParameter("source reference");
            if (reference != null) {
                Integer dupIndex;
                UpdateEdgeNameProperty updateProperties = new UpdateEdgeNameProperty(this.getEditingDomain(), edge, targetString, null, true);
                updateProperties.execute(progressMonitor, info);
                if (!updateProperties.getCommandResult().getStatus().isOK()) {
                    return updateProperties.getCommandResult();
                }
                Item sourceItem = reference.getSource();
                String rawPath = StrutsProvider.getItemTargetPath(sourceItem);
                String query = "";
                if (rawPath != null) {
                    query = URIUtil.parse((String)rawPath).query;
                    query = query != null && !query.isEmpty() ? "?" + query : "";
                }
                targetString = String.valueOf(targetString) + query;
                if (!Boolean.TRUE.equals(this.request.getParameter(ReverseEngineerConstants.REVERSE_ENGINEERING))) {
                    this.updateSource = new UpdateStrutsSourceResourceCommand((IAdaptable)sourceItem, targetString, null, target, null);
                    this.updateSource.execute(progressMonitor, info);
                    if (!this.updateSource.getCommandResult().getStatus().isOK()) {
                        return this.updateSource.getCommandResult();
                    }
                }
                if ((dupIndex = (Integer)reference.getParameter("web.dup.index")) != null) {
                    if (!WebProvider.updateStringProperty((String)"web.dup.index", (String)dupIndex.toString(), (IPropertyHolder)edge)) {
                        Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                        indexProperty.setName("web.dup.index");
                        indexProperty.setValue(dupIndex.toString());
                        edge.getPersistedProperties().add((Object)indexProperty);
                    }
                } else {
                    WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                }
            }
        } else {
            Item item;
            SourceReference reference = (SourceReference)this.request.getParameter("source reference");
            if (reference != null && (item = reference.getSource()) != null) {
                ILink link = (ILink)item.getAdapter(ILink.class);
                String rawLink = AbstractWebProvider.trimQuotes((String)link.getLinkText());
                rawLink = StrutsSearchUtil.depatternActionString((IProject)link.getContainer().getResource().getProject(), (String)rawLink, null);
                rawLink = URIUtil.parse((String)rawLink).path;
                WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                if (StrutsProvider.isActionMapping((TypedElement)target)) {
                    if (rawLink != null && rawLink.length() > 0 && !"/".equals(rawLink) && !WebProvider.updateStringProperty((String)"struts.action.name.key", (String)rawLink, (IPropertyHolder)target)) {
                        Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                        indexProperty.setName("struts.action.name.key");
                        indexProperty.setValue(rawLink);
                        target.getPersistedProperties().add((Object)indexProperty);
                    }
                } else if (WebProvider.isWebPageNode((TypedElement)target) && !rawLink.equals("") && !rawLink.equals("/") && !WebProvider.updateStringProperty((String)"web.path.key", (String)(rawLink = "/" + rawLink), (IPropertyHolder)target)) {
                    Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                    indexProperty.setName("web.path.key");
                    indexProperty.setValue(rawLink);
                    target.getPersistedProperties().add((Object)indexProperty);
                }
            }
        }
        edge.refreshRealization();
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doRedo(monitor, info);
        this.doRedoWithResult(monitor, info);
        return status;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateSource != null) {
            this.updateSource.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.doUndoWithResult(monitor, info);
        return super.doUndo(monitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateSource != null) {
            this.updateSource.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }
}

