/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineerConstants;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateStaticForwardResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateStaticForwardResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgePropertyCommand;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class CreateStaticForwardCommand
extends AbstractTransactionalCommand
implements IWorkspaceLockMarker {
    private final CreateRelationshipRequest request;
    private UpdateStaticForwardResourceCommand updateForward;
    private CreateStaticForwardResourceCommand createForward;
    private boolean askedRetargetAndAffirmative;

    public CreateStaticForwardCommand(String label, CreateRelationshipRequest request) {
        super(request.getEditingDomain(), label, CreateStaticForwardCommand.getWorkspaceFiles((List)request.getElementsToEdit()));
        this.request = request;
    }

    public void dispose() {
        if (this.createForward != null) {
            this.createForward.dispose();
        }
        if (this.updateForward != null) {
            this.updateForward.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createForward != null) {
            this.createForward.dispose();
        }
        if (this.updateForward != null) {
            this.updateForward.dispose();
        }
        MEdge edge = (MEdge)this.request.getNewElement();
        MNode target = edge.getTarget();
        MNode source = edge.getSource();
        String sModule = StrutsProvider.getModuleName((CommonElement)source);
        String tModule = StrutsProvider.getModuleName((CommonElement)target);
        if (!"".equals(sModule) && !sModule.equals(tModule)) {
            if (Boolean.TRUE.equals(this.request.getParameter(ReverseEngineerConstants.REVERSE_ENGINEERING))) {
                return CommandResult.newOKCommandResult();
            }
            if ("".equals(tModule)) {
                tModule = Messages.DefaultModule;
            }
            Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.CannotCreateStrutsElementInDiffModule, (Object[])new String[]{Messages.StaticForwards, sModule, tModule}), null);
            StatusManager.getManager().handle((IStatus)status, 4);
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        String targetString = StrutsTargetUtilities.getTargetNodePath(source, target);
        ILink actionMappingHandle = (ILink)source.getAdapter(ILink.class);
        Boolean isExisting = (Boolean)this.request.getParameter("existing edge");
        if (isExisting == null || !isExisting.booleanValue()) {
            Item sourceItem = (Item)this.request.getParameter("source node item");
            String rawPath = StrutsProvider.getItemTargetPath(sourceItem);
            String query = "";
            if (rawPath != null) {
                query = URIUtil.parse((String)rawPath).query;
                query = query != null && !query.isEmpty() ? "?" + query : "";
            }
            if (source.isRealized()) {
                if (sourceItem == null) {
                    if ("forward".equals(actionMappingHandle.getParameter("attributeParam"))) {
                        StrutsProvider.openOnlyOneTypeDialog(Messages.StaticForward);
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    if ("include".equals(actionMappingHandle.getParameter("attributeParam"))) {
                        Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), -1, Messages.CannotCreateStaticForwardIfStaticInclude, null);
                        StatusManager.getManager().handle((IStatus)status, 4);
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                }
                ArrayList<MEdge> existingEdges = new ArrayList<MEdge>();
                boolean retargettingEdge = false;
                if (sourceItem != null) {
                    ILink handle;
                    List itemTarges = EdgeGeneratorService.getInstance().getItemsEdges(sourceItem);
                    for (MEdge existingEdge : itemTarges) {
                        if (target.equals(existingEdge.getTarget())) continue;
                        retargettingEdge = true;
                        existingEdges.add(existingEdge);
                    }
                    if (!retargettingEdge && (handle = (ILink)sourceItem.getAdapter(ILink.class)) != null) {
                        ILink handleTarget = StrutsProvider.getStrutsItemTargetLink(sourceItem);
                        retargettingEdge = handleTarget != null && !handleTarget.equals(edge.getTarget().getAdapter(ILink.class));
                    }
                } else {
                    EList compartments = source.getCompartments();
                    Iterator iter = compartments.iterator();
                    while (iter.hasNext() && !retargettingEdge) {
                        Compartment compartment = (Compartment)iter.next();
                        Iterator iterator = compartment.getItems().iterator();
                        while (iterator.hasNext() && !retargettingEdge) {
                            List edges;
                            Item item = (Item)iterator.next();
                            if ("com.ibm.etools.model2.diagram.struts.StaticForwardItem".equals(item.getType())) {
                                retargettingEdge = true;
                                sourceItem = item;
                                edges = EdgeGeneratorService.getInstance().getItemsEdges(item);
                                edges.remove(edge);
                                existingEdges.addAll(edges);
                                continue;
                            }
                            if (!"com.ibm.etools.model2.diagram.struts.StaticIncludeItem".equals(item.getType())) continue;
                            retargettingEdge = true;
                            edges = EdgeGeneratorService.getInstance().getItemsEdges(item);
                            edges.remove(edge);
                            existingEdges.addAll(edges);
                        }
                    }
                }
                if (retargettingEdge) {
                    boolean allowRetarget;
                    boolean bl = allowRetarget = sourceItem != null && !new ActionMappingWildcardUtil(((ILink)sourceItem.getNode().getAdapter(ILink.class)).getContainer().getResource().getProject(), ((ILink)sourceItem.getNode().getAdapter(ILink.class)).getName()).actionHasWildcards();
                    if (!allowRetarget) {
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    boolean bl2 = allowRetarget = !this.askedRetargetAndAffirmative ? WebProvider.allowRetargetDialog() : this.askedRetargetAndAffirmative;
                    if (!allowRetarget) {
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    this.askedRetargetAndAffirmative = true;
                    for (MEdge existingEdge : existingEdges) {
                        DestroyElementRequest request = new DestroyElementRequest((EObject)existingEdge, false);
                        ICommand deleteCommand = existingEdge.getElementType().getEditCommand((IEditCommandRequest)request);
                        deleteCommand.execute(progressMonitor, info);
                        if (deleteCommand.getCommandResult().getStatus().isOK()) continue;
                        return deleteCommand.getCommandResult();
                    }
                    if (sourceItem == null) {
                        this.createForward = new CreateStaticForwardResourceCommand(targetString, (IAdaptable)source);
                        this.createForward.execute(progressMonitor, info);
                        if (!this.createForward.getCommandResult().getStatus().isOK()) {
                            return this.createForward.getCommandResult();
                        }
                    } else {
                        this.updateForward = new UpdateStaticForwardResourceCommand((IAdaptable)actionMappingHandle, targetString, null);
                        this.updateForward.execute(progressMonitor, info);
                        if (!this.updateForward.getCommandResult().getStatus().isOK()) {
                            return this.updateForward.getCommandResult();
                        }
                    }
                } else if (target.isRealized()) {
                    if (sourceItem == null) {
                        this.createForward = new CreateStaticForwardResourceCommand(targetString, (IAdaptable)source);
                        this.createForward.execute(progressMonitor, info);
                        if (!this.createForward.getCommandResult().getStatus().isOK()) {
                            return this.createForward.getCommandResult();
                        }
                    } else {
                        this.updateForward = new UpdateStaticForwardResourceCommand((IAdaptable)actionMappingHandle, targetString, null);
                        this.updateForward.execute(progressMonitor, info);
                        if (!this.updateForward.getCommandResult().getStatus().isOK()) {
                            return this.updateForward.getCommandResult();
                        }
                    }
                }
            } else {
                IStatus status = StrutsProvider.checkNewEdgeValidity(edge);
                if (status.getSeverity() != 0) {
                    StatusManager.getManager().handle(status, 4);
                    progressMonitor.setCanceled(true);
                    return CommandResult.newCancelledCommandResult();
                }
            }
        } else {
            SourceReference reference = (SourceReference)this.request.getParameter("source reference");
            Item sourceItem = null;
            if (reference != null) {
                sourceItem = reference.getSource();
                List edges = EdgeGeneratorService.getInstance().getItemsEdges(sourceItem);
                if (edges.size() > 1) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            StrutsProvider.openOnlyOneTypeDialog(Messages.StaticForward);
                        }
                    });
                    progressMonitor.setCanceled(true);
                    return CommandResult.newCancelledCommandResult();
                }
            } else {
                sourceItem = (NodeItem)this.request.getParameter("source node item");
            }
            if (sourceItem != null) {
                ILink handle;
                String rawPath = StrutsProvider.getItemTargetPath(sourceItem);
                String query = "";
                if (rawPath != null) {
                    query = URIUtil.parse((String)rawPath).query;
                    query = query != null && !query.isEmpty() ? "?" + query : "";
                }
                targetString = String.valueOf(targetString) + query;
                if (!target.isRealized() && (handle = (ILink)sourceItem.getAdapter(ILink.class)) != null) {
                    String inputString = StrutsProvider.getItemTargetPath(sourceItem);
                    if (WebProvider.isWebPageNode((TypedElement)target)) {
                        if (inputString != null && inputString.length() > 0) {
                            if (inputString.endsWith(".jsp") || inputString.endsWith(".html") || inputString.endsWith(".htm")) {
                                UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"web.path.key", (String)inputString, null, (boolean)true);
                            } else {
                                UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"web.path.key", (String)(String.valueOf(inputString) + ".jsp"), null, (boolean)true);
                            }
                        }
                    } else {
                        String targetModule = StrutsProvider.getItemTargetModule(sourceItem);
                        ILink actionTarget = StrutsProvider.getActionMappingTarget(sourceItem);
                        if (actionTarget != null) {
                            String action = actionTarget.getName();
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.action.name.key", (String)action, null, (boolean)true);
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.module.name.key", (String)targetModule, null, (boolean)true);
                        } else if (inputString != null && inputString.length() > 0) {
                            inputString = StrutsSearchUtil.depatternActionString((IProject)WebProvider.getProjectForElement((CommonElement)source), (String)inputString, null);
                            String mod = StrutsProvider.getModuleName((CommonElement)source.getParent());
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.module.name.key", (String)mod, null, (boolean)true);
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.action.name.key", (String)inputString, null, (boolean)true);
                        }
                    }
                }
            }
        }
        edge.refreshRealization();
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doRedo(monitor, info);
        this.doRedoWithResult(monitor, info);
        return status;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createForward != null) {
            this.createForward.redo(progressMonitor, info);
        }
        if (this.updateForward != null) {
            this.updateForward.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.doUndoWithResult(monitor, info);
        return super.doUndo(monitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateForward != null) {
            this.updateForward.undo(progressMonitor, info);
        }
        if (this.createForward != null) {
            this.createForward.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }
}

