/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineerConstants;
import com.ibm.etools.model2.diagram.struts.internal.DiagramStrutsPlugin;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.StrutsTargetUtilities;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateGlobalExceptionResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.CreateLocalExceptionResourceCommand;
import com.ibm.etools.model2.diagram.struts.internal.resource.cmds.items.UpdateExceptionPathResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgePropertyCommand;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class CreateExceptionCommand
extends AbstractTransactionalCommand
implements IWorkspaceLockMarker {
    private boolean askedRetargetAndAffirmative;
    private ICommand createCommand;
    private String exceptionClass = "java.lang.Exception";
    private final CreateRelationshipRequest request;
    private UpdateExceptionPathResourceCommand updateException;

    public CreateExceptionCommand(String label, CreateRelationshipRequest request) {
        super(request.getEditingDomain(), label, CreateExceptionCommand.getWorkspaceFiles((List)request.getElementsToEdit()));
        this.request = request;
    }

    public void dispose() {
        if (this.updateException != null) {
            this.updateException.dispose();
        }
        if (this.createCommand != null) {
            this.createCommand.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateException != null) {
            this.updateException.dispose();
        }
        if (this.createCommand != null) {
            this.createCommand.dispose();
        }
        MEdge edge = (MEdge)this.request.getNewElement();
        String edgeName = WebProvider.getStringProperty((String)"web.edgename.key", (IPropertyHolder)edge);
        MNode target = edge.getTarget();
        MNode source = edge.getSource();
        String sModule = StrutsProvider.getModuleName((CommonElement)source);
        String tModule = StrutsProvider.getModuleName((CommonElement)target);
        if (!"".equals(sModule) && !sModule.equals(tModule)) {
            if (Boolean.TRUE.equals(this.request.getParameter(ReverseEngineerConstants.REVERSE_ENGINEERING))) {
                return CommandResult.newOKCommandResult();
            }
            if ("".equals(tModule)) {
                tModule = Messages.DefaultModule;
            }
            Status status = new Status(4, DiagramStrutsPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.CannotCreateStrutsElementInDiffModule, (Object[])new String[]{Messages.Local_Global_Exception, sModule, tModule}), null);
            StatusManager.getManager().handle((IStatus)status, 4);
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        String targetString = StrutsTargetUtilities.getTargetNodePath(source, target);
        ILink actionMappingHandle = (ILink)source.getAdapter(ILink.class);
        Boolean isExisting = (Boolean)this.request.getParameter("existing edge");
        if (isExisting == null || !isExisting.booleanValue()) {
            NodeItem sourceItem = (NodeItem)this.request.getParameter("source node item");
            String rawPath = StrutsProvider.getItemTargetPath((Item)sourceItem);
            String query = "";
            if (rawPath != null) {
                query = URIUtil.parse((String)rawPath).query;
                query = query != null && !query.isEmpty() ? "?" + query : "";
            }
            targetString = String.valueOf(targetString) + query;
            if (source.isRealized()) {
                if (!target.isRealized()) {
                    targetString = "";
                }
                ArrayList<MEdge> existingEdges = new ArrayList<MEdge>();
                boolean retargettingEdge = false;
                if (sourceItem != null) {
                    ILink link;
                    ILink handle = (ILink)sourceItem.getAdapter(ILink.class);
                    if (handle != null) {
                        this.exceptionClass = AbstractWebProvider.trimQuotes((String)handle.getLinkText());
                    }
                    List itemTarges = EdgeGeneratorService.getInstance().getItemsEdges((Item)sourceItem);
                    for (MEdge existingEdge : itemTarges) {
                        if (target.equals(existingEdge.getTarget())) continue;
                        retargettingEdge = true;
                        existingEdges.add(existingEdge);
                    }
                    if (!retargettingEdge && (link = (ILink)sourceItem.getAdapter(ILink.class)) != null) {
                        ILink handleTarget = StrutsProvider.getStrutsItemTargetLink((Item)sourceItem);
                        ILink edgeTarget = (ILink)edge.getTarget().getAdapter(ILink.class);
                        edgeTarget = StrutsSearchUtil.getExceptionPathLinkForException((ILink)edgeTarget);
                        boolean bl = retargettingEdge = handleTarget != null && !handleTarget.equals(edgeTarget);
                    }
                }
                if (retargettingEdge) {
                    boolean allowRetarget;
                    boolean bl = allowRetarget = actionMappingHandle == null || !new ActionMappingWildcardUtil(actionMappingHandle.getContainer().getResource().getProject(), actionMappingHandle.getName()).actionHasWildcards();
                    if (!allowRetarget) {
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    boolean bl2 = allowRetarget = !this.askedRetargetAndAffirmative ? WebProvider.allowRetargetDialog() : this.askedRetargetAndAffirmative;
                    if (!allowRetarget) {
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    this.askedRetargetAndAffirmative = true;
                    for (MEdge existingEdge : existingEdges) {
                        DestroyElementRequest request = new DestroyElementRequest((EObject)existingEdge, false);
                        ICommand deleteCommand = existingEdge.getElementType().getEditCommand((IEditCommandRequest)request);
                        if (!deleteCommand.canExecute()) continue;
                        deleteCommand.execute(progressMonitor, info);
                        if (deleteCommand.getCommandResult().getStatus().isOK()) continue;
                        return deleteCommand.getCommandResult();
                    }
                    this.updateException = new UpdateExceptionPathResourceCommand((IAdaptable)sourceItem, targetString, null);
                    this.updateException.execute(progressMonitor, info);
                    if (!this.updateException.getCommandResult().getStatus().isOK()) {
                        return this.updateException.getCommandResult();
                    }
                    if (!WebProvider.updateStringProperty((String)"web.edgename.key", (String)this.exceptionClass, (IPropertyHolder)edge)) {
                        Property edgeProperty = DiagramModelFactory.eINSTANCE.createProperty();
                        edgeProperty.setName("web.edgename.key");
                        edgeProperty.setValue(this.exceptionClass);
                        edge.getPersistedProperties().add((Object)edgeProperty);
                        WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                    }
                } else {
                    Property edgeProperty;
                    if (target.isRealized()) {
                        if (sourceItem != null) {
                            if (!Boolean.TRUE.equals(this.request.getParameter(ReverseEngineerConstants.REVERSE_ENGINEERING))) {
                                this.updateException = new UpdateExceptionPathResourceCommand((IAdaptable)sourceItem, targetString, null);
                                this.updateException.execute(progressMonitor, info);
                                if (!this.updateException.getCommandResult().getStatus().isOK()) {
                                    return this.updateException.getCommandResult();
                                }
                            }
                            if (!WebProvider.updateStringProperty((String)"web.edgename.key", (String)this.exceptionClass, (IPropertyHolder)edge)) {
                                edgeProperty = DiagramModelFactory.eINSTANCE.createProperty();
                                edgeProperty.setName("web.edgename.key");
                                edgeProperty.setValue(this.exceptionClass);
                                edge.getPersistedProperties().add((Object)edgeProperty);
                            }
                            SourceReference reference = (SourceReference)this.request.getParameter("source reference");
                            Integer dupIndex = null;
                            if (reference != null) {
                                dupIndex = (Integer)reference.getParameter("web.dup.index");
                            }
                            if (dupIndex != null) {
                                if (!WebProvider.updateStringProperty((String)"web.dup.index", (String)dupIndex.toString(), (IPropertyHolder)edge)) {
                                    Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                                    indexProperty.setName("web.dup.index");
                                    indexProperty.setValue(dupIndex.toString());
                                    edge.getPersistedProperties().add((Object)indexProperty);
                                }
                            } else {
                                WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                            }
                        } else {
                            this.createCommand = "com.ibm.etools.model2.diagram.struts.GlobalException".equals(edge.getType()) ? new CreateGlobalExceptionResourceCommand(this.exceptionClass, targetString, edge.getSource(), true) : new CreateLocalExceptionResourceCommand(this.exceptionClass, targetString, (IAdaptable)actionMappingHandle, true);
                            if (this.createCommand != null) {
                                this.createCommand.execute(progressMonitor, info);
                                if (!this.createCommand.getCommandResult().getStatus().isOK()) {
                                    return this.createCommand.getCommandResult();
                                }
                            }
                            if (edgeName == null || edgeName.length() == 0) {
                                edgeName = this.exceptionClass;
                                if (!WebProvider.updateStringProperty((String)"web.edgename.key", (String)this.exceptionClass, (IPropertyHolder)edge)) {
                                    edgeProperty = DiagramModelFactory.eINSTANCE.createProperty();
                                    edgeProperty.setName("web.edgename.key");
                                    edgeProperty.setValue(this.exceptionClass);
                                    edge.getPersistedProperties().add((Object)edgeProperty);
                                    WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                                }
                            }
                        }
                    } else if (sourceItem != null && this.exceptionClass != null && !WebProvider.updateStringProperty((String)"web.edgename.key", (String)this.exceptionClass, (IPropertyHolder)edge)) {
                        edgeProperty = DiagramModelFactory.eINSTANCE.createProperty();
                        edgeProperty.setName("web.edgename.key");
                        edgeProperty.setValue(this.exceptionClass);
                        edge.getPersistedProperties().add((Object)edgeProperty);
                    }
                    WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                }
            } else {
                IStatus status = StrutsProvider.checkNewEdgeValidity(edge);
                if (status.getSeverity() != 0) {
                    StatusManager.getManager().handle(status, 4);
                    progressMonitor.setCanceled(true);
                    return CommandResult.newCancelledCommandResult();
                }
            }
        } else {
            String query;
            String rawPath;
            Item sourceItem = null;
            String newEdgeName = null;
            SourceReference reference = (SourceReference)this.request.getParameter("source reference");
            if (reference != null) {
                sourceItem = reference.getSource();
                rawPath = StrutsProvider.getItemTargetPath(sourceItem);
                query = "";
                if (rawPath != null) {
                    query = URIUtil.parse((String)rawPath).query;
                    query = query != null && !query.isEmpty() ? "?" + query : "";
                }
                targetString = String.valueOf(targetString) + query;
                newEdgeName = (String)reference.getParameter("web.edgename.key");
                if (newEdgeName == null && sourceItem != null) {
                    newEdgeName = WebProvider.getStringProperty((String)"struts.exception.name.key", (IPropertyHolder)sourceItem);
                }
            } else {
                sourceItem = (Item)this.request.getParameter("source node item");
                rawPath = StrutsProvider.getItemTargetPath(sourceItem);
                query = "";
                if (rawPath != null) {
                    query = URIUtil.parse((String)rawPath).query;
                    query = query != null && !query.isEmpty() ? "?" + query : "";
                }
                targetString = String.valueOf(targetString) + query;
                newEdgeName = WebProvider.getStringProperty((String)"struts.exception.name.key", (IPropertyHolder)sourceItem);
            }
            if (sourceItem != null) {
                ILink handle;
                if (edgeName == null) {
                    Property property = DiagramModelFactory.eINSTANCE.createProperty();
                    property.setName("web.edgename.key");
                    property.setValue(newEdgeName);
                    edge.getPersistedProperties().add((Object)property);
                    WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
                }
                if ((handle = (ILink)sourceItem.getAdapter(ILink.class)) != null && !target.isRealized()) {
                    ILink exceptionPath = StrutsSearchUtil.getExceptionPathLinkForException((ILink)handle);
                    String brokenPath = AbstractWebProvider.trimQuotes((String)exceptionPath.getLinkText());
                    if (WebProvider.isWebPageNode((TypedElement)target)) {
                        if (brokenPath != null && brokenPath.length() > 0) {
                            if (brokenPath.endsWith(".jsp") || brokenPath.endsWith(".html") || brokenPath.endsWith(".htm")) {
                                UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"web.path.key", (String)brokenPath, null, (boolean)true);
                            } else {
                                UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"web.path.key", (String)(String.valueOf(brokenPath) + ".jsp"), null, (boolean)true);
                            }
                        }
                    } else {
                        String targetModuleFromSource = StrutsProvider.getItemTargetModule(sourceItem);
                        ILink actionTarget = StrutsProvider.getActionMappingTarget(sourceItem);
                        if (actionTarget == null) {
                            if (brokenPath != null && brokenPath.length() > 0) {
                                brokenPath = StrutsSearchUtil.depatternActionString((IProject)WebProvider.getProjectForElement((CommonElement)source), (String)brokenPath, null);
                                String mod = StrutsProvider.getModuleName((CommonElement)source.getParent());
                                UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.module.name.key", (String)mod, null, (boolean)true);
                                UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.action.name.key", (String)brokenPath, null, (boolean)true);
                            }
                        } else {
                            String action = actionTarget.getName();
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.action.name.key", (String)action, null, (boolean)true);
                            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)target, (String)"struts.module.name.key", (String)targetModuleFromSource, null, (boolean)true);
                        }
                    }
                }
                WebProvider.setEdgeIndexByType((MNode)source, (MEdge)edge);
            }
        }
        edge.refreshRealization();
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doRedo(monitor, info);
        this.doRedoWithResult(monitor, info);
        return status;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createCommand != null) {
            this.createCommand.redo(progressMonitor, info);
        }
        if (this.updateException != null) {
            this.updateException.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.doUndoWithResult(monitor, info);
        return super.doUndo(monitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateException != null) {
            this.updateException.undo(progressMonitor, info);
        }
        if (this.createCommand != null) {
            this.createCommand.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }
}

