/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.TaglibUtil;
import com.ibm.etools.model2.diagram.struts.internal.edithelper.cmds.LinkOrFormElement;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebDiagramCommandHelper;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebTargetTypeUtilities;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.jspeditor.StrutsTaglibUtil;
import com.ibm.etools.struts.jspeditor.vct.palette.actions.StrutsCommandUtil;
import com.ibm.etools.struts.util.StrutsUtil;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.AbstractNodeFactory;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.util.ITaglibDirective;
import com.ibm.etools.webtools.model.util.ModelUtil;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StrutsTargetUtilities {
    public static void addStrutsForm(IFile jspFile, String targetPath) throws Exception {
        StrutsTargetUtilities.addStrutsLinkOrForm(jspFile, StrutsLinkType.FORM, "action", null, targetPath);
    }

    public static void addStrutsLink(IFile jspFile, String attributeName, String targetModule, String targetPath) throws Exception {
        StrutsTargetUtilities.addStrutsLinkOrForm(jspFile, StrutsLinkType.LINK, attributeName, targetModule, targetPath);
    }

    private static void addStrutsLinkOrForm(IFile jspFile, StrutsLinkType type, String attributeName, String targetModule, String targetPath) throws Exception {
        HTMLEditDomain editDomain = null;
        try {
            editDomain = ModelUtil.getEditDomain((IFile)jspFile);
            CompoundHTMLCommand taglibCommand = new CompoundHTMLCommand("add struts taglibs");
            String prefix = StrutsTaglibUtil.addTaglibIfNecessary((String)"html", (HTMLEditDomain)editDomain, (CompoundHTMLCommand)taglibCommand);
            String htmlELement = null;
            switch (type) {
                case FORM: {
                    htmlELement = "html:form";
                    break;
                }
                case LINK: {
                    htmlELement = "html:link";
                }
            }
            CustomTagFactory factory = StrutsCommandUtil.getFactory((String)prefix, (String)htmlELement);
            factory.pushAttribute(attributeName, targetPath);
            if (targetModule != null) {
                factory.pushAttribute("module", targetModule);
            }
            if (type == StrutsLinkType.LINK) {
                factory.setTextSourceAsChild(Messages.StrutsLinkLabel);
            }
            if (taglibCommand.getCommandList().size() == 0) {
                WebDiagramCommandHelper.addLink((HTMLEditDomain)editDomain, (AbstractNodeFactory)factory, null);
            } else {
                WebDiagramCommandHelper.addLink((HTMLEditDomain)editDomain, (AbstractNodeFactory)factory, (HTMLCommand)taglibCommand);
            }
        }
        finally {
            ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)editDomain);
        }
    }

    private static Element getMatchingDOMElement(IDOMDocument doc, int whichOne, String tagName, Collection<String> attributes, String targetModule, String targetPath, boolean useModule) {
        NodeList list = doc.getElementsByTagName(tagName);
        int matched = 0;
        int i = 0;
        while (i < list.getLength()) {
            Element e = (Element)list.item(i);
            for (String attribute : attributes) {
                String tempPath = e.getAttribute(attribute);
                if (tempPath == null || !tempPath.equals(targetPath)) continue;
                String tempModule = e.getAttribute("module");
                if (targetModule != null) {
                    if ((tempModule == null || !tempModule.equals(targetModule)) && useModule) continue;
                    if (whichOne == matched) {
                        return e;
                    }
                    ++matched;
                    continue;
                }
                if (tempModule != null && useModule) continue;
                if (whichOne == matched) {
                    return e;
                }
                ++matched;
            }
            ++i;
        }
        return null;
    }

    public static final String getTargetNodePath(MNode source, MNode target) {
        String targetString = "";
        if (target == null) {
            return targetString;
        }
        if (StrutsProvider.isActionMapping((TypedElement)target)) {
            String path = WebProvider.getStringProperty((String)"struts.action.name.key", (IPropertyHolder)target);
            targetString = StrutsTargetUtilities.getTargetNodePath(source, target, path);
        } else {
            targetString = StrutsTargetUtilities.getTargetNodePath(source, target, null);
        }
        if (WebProvider.isWebPageNode((TypedElement)target)) {
            targetString = WebProvider.externalPathModification((String)targetString, (IProject)WebProvider.getProjectForElement((CommonElement)target));
        } else if (WebProvider.isWebApplicationNode((TypedElement)target)) {
            targetString = WebTargetTypeUtilities.getTargetNodePath((MNode)source, (MNode)target);
        }
        return targetString;
    }

    private static final String getTargetNodePath(MNode source, MNode target, String targetPath) {
        if (target == null) {
            return "";
        }
        String result = null;
        IFile file = StrutsProvider.getFileForNode(source);
        String modOfSource = null;
        modOfSource = !source.isRealized() || file == null || source.getType().equals("com.ibm.etools.model2.diagram.struts.StrutsGlobalNode") ? StrutsProvider.getModuleName((CommonElement)source.getParent()) : StrutsSearchUtil.getModuleForIFile((IFile)file, null);
        String modOfTarget = StrutsProvider.getModuleName((CommonElement)target);
        if (StrutsProvider.isActionMapping((TypedElement)target)) {
            if (!WebProvider.isWebPageNode((TypedElement)source)) {
                IProject project = WebProvider.getProjectForElement((CommonElement)source);
                IVirtualComponent component = WebProvider.getVirtualComponent((EObject)target);
                String removedPattern = StrutsSearchUtil.depatternActionString((IProject)project, (String)targetPath, null);
                if (removedPattern != null) {
                    targetPath = removedPattern;
                }
                result = StrutsUtil.getPatterenedPathForActionServlet((IVirtualComponent)component, (String)modOfTarget, (String)targetPath);
            } else {
                result = targetPath;
            }
            if (!modOfSource.equals(modOfTarget)) {
                result = String.valueOf(modOfTarget) + result;
            }
        } else if (WebProvider.isWebPageNode((TypedElement)target)) {
            IFile targetFile = WebProvider.getFileForNode((MNode)target);
            if (StrutsProvider.isActionMapping((TypedElement)source)) {
                IVirtualComponent component = WebProvider.getVirtualComponent((EObject)source);
                IFolder handle = Model2Util.folderFor((IVirtualComponent)component, (String)modOfSource);
                if (handle != null) {
                    IPath wsRelative = handle.getFullPath();
                    IPath fullTargetPath = targetFile.getFullPath();
                    fullTargetPath = fullTargetPath.removeFirstSegments(fullTargetPath.matchingFirstSegments(wsRelative)).makeAbsolute();
                    result = fullTargetPath.toString();
                }
            } else {
                result = WebTargetTypeUtilities.getTargetNodePath((MNode)source, (MNode)target);
                if (result != null && !result.startsWith("/")) {
                    result = "/" + result;
                }
            }
        } else {
            result = WebTargetTypeUtilities.getTargetNodePath((MNode)source, (MNode)target);
        }
        return result;
    }

    public static LinkOrFormElement getUntargettedForm(IFile jspFile, String targetPath) throws Exception {
        return StrutsTargetUtilities.getUntargettedLinkOrForm(jspFile, StrutsLinkType.FORM, null, targetPath);
    }

    public static LinkOrFormElement getUntargettedLink(IFile jspFile, String targetModule, String targetPath) throws Exception {
        return StrutsTargetUtilities.getUntargettedLinkOrForm(jspFile, StrutsLinkType.LINK, targetModule, targetPath);
    }

    private static LinkOrFormElement getUntargettedLinkOrForm(IFile jspFile, StrutsLinkType type, String oldTargetModule, String oldTargetPath) throws Exception {
        LinkOrFormElement result = null;
        HTMLEditDomain editDomain = null;
        try {
            editDomain = ModelUtil.getEditDomain((IFile)jspFile);
            String tagName = null;
            HashSet<String> oldAttributeNames = new HashSet<String>();
            String actualPrefix = null;
            String uri = null;
            IProject project = TaglibUtil.getFile((HTMLEditDomain)editDomain).getProject();
            uri = StrutsTaglibUtil.getUri((String)"html", (IProject)project);
            ITaglibDirective directive = TaglibUtil.getTaglibDirective((HTMLEditDomain)editDomain, (String)uri);
            if (directive != null) {
                actualPrefix = directive.getPrefix();
            }
            switch (type) {
                case LINK: {
                    tagName = String.valueOf(actualPrefix) + "html:link".substring("html:link".indexOf(58));
                    oldAttributeNames.add("action");
                    oldAttributeNames.add("page");
                    break;
                }
                case FORM: {
                    tagName = String.valueOf(actualPrefix) + "html:form".substring("html:form".indexOf(58));
                    oldAttributeNames.add("action");
                }
            }
            String targetPath = oldTargetPath;
            IDOMDocument doc = editDomain.getActiveModel().getDocument();
            Element e = StrutsTargetUtilities.getMatchingDOMElement(doc, 0, tagName, oldAttributeNames, oldTargetModule, targetPath, true);
            if (e == null && (e = StrutsTargetUtilities.getMatchingDOMElement(doc, 0, tagName, oldAttributeNames, null, targetPath = "/", false)) == null) {
                targetPath = "";
                e = StrutsTargetUtilities.getMatchingDOMElement(doc, 0, tagName, oldAttributeNames, null, targetPath, false);
            }
            if (e != null) {
                result = new LinkOrFormElement();
                result.targetPath = targetPath;
                result.targetModule = e.getAttribute("module");
            }
        }
        finally {
            ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)editDomain);
        }
        return result;
    }

    public static final boolean isTargetAndSourceModuleDifferent(MNode source, MNode target) {
        String sourceModule = StrutsProvider.getModuleName((CommonElement)source);
        String targetModule = StrutsProvider.getModuleName((CommonElement)target);
        return sourceModule != null && targetModule != null && !sourceModule.equals(targetModule);
    }

    public static void removeStrutsForm(int whichOne, IFile jspFile, String targetPath) throws Exception {
        StrutsTargetUtilities.removeStrutsLinkOrForm(whichOne, jspFile, StrutsLinkType.FORM, null, targetPath);
    }

    public static void removeStrutsLink(int whichOne, IFile jspFile, String targetModule, String targetPath) throws Exception {
        StrutsTargetUtilities.removeStrutsLinkOrForm(whichOne, jspFile, StrutsLinkType.LINK, targetModule, targetPath);
    }

    private static void removeStrutsLinkOrForm(int whichOne, IFile jspFile, StrutsLinkType type, String targetModule, String targetPath) throws Exception {
        if (jspFile != null && jspFile.exists()) {
            HTMLEditDomain editDomain = null;
            try {
                IDOMDocument doc;
                Element e;
                editDomain = ModelUtil.getEditDomain((IFile)jspFile);
                String tagName = null;
                HashSet<String> oldAttributeNames = new HashSet<String>();
                String actualPrefix = null;
                String uri = null;
                IProject project = TaglibUtil.getFile((HTMLEditDomain)editDomain).getProject();
                uri = StrutsTaglibUtil.getUri((String)"html", (IProject)project);
                ITaglibDirective directive = TaglibUtil.getTaglibDirective((HTMLEditDomain)editDomain, (String)uri);
                if (directive != null) {
                    actualPrefix = directive.getPrefix();
                }
                switch (type) {
                    case LINK: {
                        tagName = String.valueOf(actualPrefix) + "html:link".substring("html:link".indexOf(58));
                        oldAttributeNames.add("action");
                        oldAttributeNames.add("page");
                        break;
                    }
                    case FORM: {
                        tagName = String.valueOf(actualPrefix) + "html:form".substring("html:form".indexOf(58));
                        oldAttributeNames.add("action");
                    }
                }
                if (targetPath != null && (e = StrutsTargetUtilities.getMatchingDOMElement(doc = editDomain.getActiveModel().getDocument(), whichOne, tagName, oldAttributeNames, targetModule, targetPath, true)) != null) {
                    e.getParentNode().removeChild(e);
                    editDomain.getModel().save();
                }
            }
            finally {
                ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)editDomain);
            }
        }
    }

    public static void updateStrutsForm(int whichOne, IFile jspFile, String oldTargetPath, String targetPath) throws Exception {
        StrutsTargetUtilities.updateStrutsLinkOrForm(whichOne, jspFile, StrutsLinkType.FORM, "action", null, oldTargetPath, null, targetPath);
    }

    public static void updateStrutsLink(int whichOne, IFile jspFile, String newAttribute, String oldTargetModule, String oldTargetPath, String targetModule, String targetPath) throws Exception {
        StrutsTargetUtilities.updateStrutsLinkOrForm(whichOne, jspFile, StrutsLinkType.LINK, newAttribute, oldTargetModule, oldTargetPath, targetModule, targetPath);
    }

    private static void updateStrutsLinkOrForm(int whichOne, IFile jspFile, StrutsLinkType type, String newAttribute, String oldTargetModule, String oldTargetPath, String targetModule, String targetPath) throws Exception {
        if (jspFile != null && jspFile.exists()) {
            HTMLEditDomain editDomain = null;
            try {
                IDOMDocument doc;
                Element e;
                editDomain = ModelUtil.getEditDomain((IFile)jspFile);
                String tagName = null;
                HashSet<String> oldAttributeNames = new HashSet<String>();
                String actualPrefix = null;
                String uri = null;
                IProject project = TaglibUtil.getFile((HTMLEditDomain)editDomain).getProject();
                uri = StrutsTaglibUtil.getUri((String)"html", (IProject)project);
                ITaglibDirective directive = TaglibUtil.getTaglibDirective((HTMLEditDomain)editDomain, (String)uri);
                if (directive != null) {
                    actualPrefix = directive.getPrefix();
                }
                switch (type) {
                    case LINK: {
                        tagName = String.valueOf(actualPrefix) + "html:link".substring("html:link".indexOf(58));
                        oldAttributeNames.add("action");
                        oldAttributeNames.add("page");
                        break;
                    }
                    case FORM: {
                        tagName = String.valueOf(actualPrefix) + "html:form".substring("html:form".indexOf(58));
                        oldAttributeNames.add("action");
                    }
                }
                if (targetPath != null && (e = StrutsTargetUtilities.getMatchingDOMElement(doc = editDomain.getActiveModel().getDocument(), whichOne, tagName, oldAttributeNames, oldTargetModule, oldTargetPath, true)) != null) {
                    if (e.hasAttribute(newAttribute) && e.getAttribute(newAttribute).equals(targetPath)) {
                        boolean skip = true;
                        if (targetModule == null) {
                            if (e.hasAttribute("module")) {
                                skip = false;
                            }
                        } else if (!targetModule.equals(e.getAttribute("module"))) {
                            skip = false;
                        }
                        if (skip) {
                            return;
                        }
                    }
                    e.removeAttribute("action");
                    e.removeAttribute("page");
                    e.removeAttribute("module");
                    e.setAttribute(newAttribute, targetPath);
                    if (targetModule != null) {
                        e.setAttribute("module", targetModule);
                    }
                    editDomain.getModel().save();
                }
            }
            finally {
                ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)editDomain);
            }
        }
    }

    private static enum StrutsLinkType {
        FORM,
        LINK;

    }
}

