/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.internal;

import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;

public class StrutsChangeCommand
extends ChangeCommand {
    private StrutsArtifactEdit edit;
    private final StrutsChanges runnable;
    protected boolean shouldForceSave;

    public StrutsChangeCommand(StrutsArtifactEdit edit, Notifier notifier, StrutsChanges runnable, boolean shouldForceSave) {
        super(notifier);
        this.edit = edit;
        this.runnable = runnable;
        this.shouldForceSave = shouldForceSave;
    }

    public static StrutsChangeCommand getStrutsCommand(IFile file, StrutsChanges runnable, boolean shouldForceSave) {
        return StrutsChangeCommand.getStrutsCommand(StrutsArtifactEdit.getStrutsArtifactEditForWrite((IFile)file), runnable, shouldForceSave);
    }

    private static StrutsChangeCommand getStrutsCommand(StrutsArtifactEdit edit, StrutsChanges runnable, boolean shouldForceSave) {
        try {
            StrutsConfig type = edit.getStrutsConfig();
            return new StrutsChangeCommand(edit, (Notifier)type, runnable, shouldForceSave);
        }
        catch (RuntimeException e) {
            if (edit != null) {
                edit.dispose();
            }
            e.printStackTrace();
            return null;
        }
    }

    public void dispose() {
        try {
            this.edit.dispose();
            this.edit = null;
        }
        finally {
            super.dispose();
        }
    }

    protected final void doExecute() {
        boolean succeeded = false;
        if (this.edit != null) {
            try {
                succeeded = this.runnable.doStrutsChanges(this.edit.getStrutsConfig());
            }
            finally {
                if (succeeded) {
                    if (this.shouldForceSave) {
                        this.edit.save(null);
                    } else {
                        this.edit.saveIfNecessary(null);
                    }
                }
            }
        }
    }

    public void redo() {
        try {
            super.redo();
        }
        finally {
            if (this.shouldForceSave) {
                this.edit.save(null);
            } else {
                this.edit.saveIfNecessary(null);
            }
        }
    }

    public void undo() {
        try {
            super.undo();
        }
        finally {
            if (this.shouldForceSave) {
                this.edit.save(null);
            } else {
                this.edit.saveIfNecessary(null);
            }
        }
    }

    public static abstract class StrutsChanges {
        protected abstract boolean doStrutsChanges(StrutsConfig var1);
    }
}

