/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.ui.internal.properties.sections;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.struts.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsDiagramLevelSection
extends AbstractNotationPropertiesSection {
    private Text combo;
    private Hyperlink link;

    public static String convertModulesToDisplayString(String module) {
        if ("".equals(module)) {
            return Messages.DefaultModule;
        }
        return module;
    }

    public IFile getDiagramFile() {
        if (this.getPart() == null) {
            return null;
        }
        View diagramView = (View)this.getPart().getAdapter(View.class);
        if (diagramView != null) {
            return WorkspaceSynchronizer.getFile((Resource)diagramView.eResource());
        }
        return null;
    }

    protected EObject getSemanticObject() {
        IGraphicalEditPart part = this.getSingleInput();
        if (part == null) {
            return null;
        }
        EObject o = part.resolveSemanticElement();
        if (o == null) {
            return null;
        }
        return o;
    }

    protected IFile getStrutsConfig() {
        String moduleName = StrutsProvider.getModuleName((CommonElement)((CommonElement)this.getSemanticObject()));
        MDiagram d = (MDiagram)this.getSemanticObject();
        if (d != null && moduleName != null) {
            IVirtualComponent component = WebProvider.getVirtualComponent((EObject)d);
            try {
                Set links = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)moduleName, null);
                if (!links.isEmpty()) {
                    return (IFile)((ILink)links.iterator().next()).getContainer().getResource();
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    protected void initializeControls(Composite parent) {
        Composite sectionComposite = this.getWidgetFactory().createComposite(parent, 0);
        sectionComposite.setLayout((Layout)new GridLayout());
        ExpandableComposite web = this.getWidgetFactory().createExpandableComposite(sectionComposite, 64);
        web.setLayout((Layout)new GridLayout());
        web.setLayoutData((Object)new GridData(4, 1, true, false));
        web.setText(Messages.Struts);
        Composite c = this.getWidgetFactory().createComposite((Composite)web, 0);
        GridLayout col2 = new GridLayout();
        col2.numColumns = 2;
        c.setLayout((Layout)col2);
        c.setLayoutData((Object)new GridData(4, 1, true, false));
        web.setClient((Control)c);
        this.getWidgetFactory().createLabel(c, Messages.StrutsConfigFile);
        this.link = this.getWidgetFactory().createHyperlink(c, "", 0);
        this.link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFile strutsconfig = StrutsDiagramLevelSection.this.getStrutsConfig();
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)strutsconfig);
                }
                catch (PartInitException e1) {
                    StatusManager.getManager().handle(e1.getStatus(), 3);
                }
            }
        });
        this.getWidgetFactory().createLabel(c, Messages.DefaultModuleForNewActions);
        this.combo = this.getWidgetFactory().createText(c, "", 0x800000);
        this.combo.setEditable(false);
        this.combo.setEnabled(false);
        this.combo.setLayoutData((Object)new GridData(768));
    }

    public void refresh() {
        IFile file;
        super.refresh();
        if (this.combo != null && (file = this.getDiagramFile()) != null) {
            String moduleName = StrutsProvider.getModuleName((CommonElement)((CommonElement)this.getSemanticObject()));
            IFile strutsConfig = this.getStrutsConfig();
            String strutsPath = Messages.Unknown;
            if (strutsConfig != null) {
                strutsPath = strutsConfig.getProjectRelativePath().makeAbsolute().toString();
            }
            this.link.setText(TextProcessor.process((String)strutsPath));
            moduleName = StrutsDiagramLevelSection.convertModulesToDisplayString(moduleName);
            this.combo.setText(moduleName);
        }
    }
}

