/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.ui.internal.actions;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.ui.internal.adapters.OpenAdapter;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class OpenFormbeanDefinition
extends Action
implements ISelectionListener {
    private final IWorkbenchPartDescriptor partDescriptor;

    public OpenFormbeanDefinition(IWorkbenchPartDescriptor partDescriptor) {
        this.partDescriptor = partDescriptor;
        this.setText(Messages.OpenFormbeanDef);
    }

    private Item getItemSelection() {
        EObject eObject;
        IStructuredSelection sel = (IStructuredSelection)this.partDescriptor.getPartPage().getSelection();
        Object first = sel.getFirstElement();
        if (first instanceof IAdaptable && (eObject = (EObject)((IAdaptable)first).getAdapter(EObject.class)) instanceof Item) {
            return (Item)eObject;
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        Item item = this.getItemSelection();
        if (item != null) {
            StrutsFormbeanDefOpenAdapter adapter = new StrutsFormbeanDefOpenAdapter(item);
            try {
                adapter.openEditor();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.isEnabled();
    }

    private static class StrutsFormbeanDefOpenAdapter
    extends OpenAdapter {
        private final Item item;

        public StrutsFormbeanDefOpenAdapter(Item item) {
            this.item = item;
        }

        public IFile getFileToOpen() {
            ILink handle = (ILink)this.item.getAdapter(ILink.class);
            if (handle != null) {
                IFile strutsConfig = (IFile)handle.getContainer().getResource();
                return strutsConfig;
            }
            if ("com.ibm.etools.model2.diagram.struts.StrutsGlobalNode".equals(this.item.getType())) {
                String module = StrutsProvider.getModuleName((CommonElement)this.item.getNode().getParent());
                IProject project = WebProvider.getProjectForElement((CommonElement)this.item);
                try {
                    Set sc = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)project, (String)module, null);
                    if (!sc.isEmpty()) {
                        return (IFile)((ILink)sc.iterator().next()).getContainer().getResource();
                    }
                }
                catch (ReferenceException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public ISelection getSelectionToReveal() {
            ILink handle = (ILink)this.item.getAdapter(ILink.class);
            return new StructuredSelection((Object)handle);
        }
    }
}

