/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds.nodes;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.faces.internal.resource.cmds.CreateManagedBeanFromTemplateCommand;
import com.ibm.etools.model2.diagram.faces.internal.resource.cmds.nodes.ManagedBeanClassAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.web.faces.FacesAction;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class CreateFacesActionNodeResourceCommand
extends AbstractCommand
implements IWorkspaceLockMarker {
    private final MNode node;
    private IFile javaFile;
    private FacesChangeCommand facesChangeCommand;
    private final String beanName;
    private final String actionName;
    private final CommandExecutionAprover addActionAprover;
    private final CommandExecutionAprover createManagedBeanAprover;
    private final ManagedBeanClassAdapter managedBeanClassAdapter;

    public CreateFacesActionNodeResourceCommand(MNode node, String facesActionName, CommandExecutionAprover addActionAprover, CommandExecutionAprover createManagedBeanAprover, ManagedBeanClassAdapter managedBeanClassAdapter) {
        super(ResourceHandler.CreateFacesAction);
        List<String> facesAction;
        this.node = node;
        this.addActionAprover = addActionAprover;
        this.createManagedBeanAprover = createManagedBeanAprover;
        this.managedBeanClassAdapter = managedBeanClassAdapter;
        String aName = WebProvider.getStringProperty((String)"faces.action.node.name", (IPropertyHolder)this.getNode());
        if (facesActionName != null) {
            aName = facesActionName;
        }
        if ((facesAction = FacesProvider.getNameSegments(aName)).size() > 1) {
            this.beanName = facesAction.get(0);
            this.actionName = facesAction.get(1);
        } else {
            this.beanName = null;
            this.actionName = null;
        }
    }

    private MNode getNode() {
        return this.node;
    }

    protected IFile getFileToModify() {
        return this.javaFile;
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.beanName == null || this.actionName == null) {
            return CommandResult.newCancelledCommandResult();
        }
        this.createFacesAction(progressMonitor);
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult createFacesAction(final IProgressMonitor monitor) {
        final IProject project = FacesProvider.getProjectForElement((CommonElement)this.getNode());
        monitor.beginTask("", 1500);
        monitor.subTask(ResourceHandler.CreatingFacesAction);
        IResource folder = FacesProvider.getDefaultFacesFolder((CommonElement)this.getNode().getParent());
        FacesConfigArtifactEdit edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForWrite((IResource)folder);
        try {
            if (edit.getFacesConfig() == null) {
                return CommandResult.newOKCommandResult();
            }
        }
        catch (RuntimeException e) {
            if (edit != null) {
                edit.dispose();
            }
            throw e;
        }
        FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

            @Override
            protected boolean doFacesChanges(FacesConfigType config) {
                EList list = config.getManagedBean();
                boolean beanFound = false;
                boolean actionFound = false;
                for (ManagedBeanType managedBean : list) {
                    if (!CreateFacesActionNodeResourceCommand.this.beanName.equals(managedBean.getManagedBeanName() == null ? null : managedBean.getManagedBeanName().getTextContent())) continue;
                    beanFound = true;
                    FacesAction facesActionHandle = (FacesAction)CreateFacesActionNodeResourceCommand.this.node.getAdapter(FacesAction.class);
                    if (facesActionHandle != null && CreateFacesActionNodeResourceCommand.this.actionName.equals(facesActionHandle.getActionName())) {
                        actionFound = true;
                        break;
                    }
                    CreateFacesActionNodeResourceCommand.this.managedBeanClassAdapter.setManagedBeanClass(managedBean.getManagedBeanClass() != null ? managedBean.getManagedBeanClass().getTextContent() : null);
                    IProject p = FacesProvider.getProjectForElement((CommonElement)CreateFacesActionNodeResourceCommand.this.getNode());
                    CreateFacesActionNodeResourceCommand.this.managedBeanClassAdapter.setProject(p);
                    IJavaProject project2 = JavaCore.create((IProject)p);
                    try {
                        IType type = project2.findType(managedBean.getManagedBeanClass() != null ? managedBean.getManagedBeanClass().getTextContent() : null);
                        if (type != null && type.exists()) {
                            CreateFacesActionNodeResourceCommand.this.managedBeanClassAdapter.setManagedBeanFile((IFile)type.getUnderlyingResource());
                            break;
                        }
                        CreateFacesActionNodeResourceCommand.this.createManagedBeanAprover.setProceed(true);
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                monitor.worked(100);
                if (!beanFound) {
                    String pkg = CreateManagedBeanFromTemplateCommand.getDefaultFacesActionPackageName(Model2Util.findComponent((IResource)project));
                    String typeName = String.valueOf(pkg) + "." + CreateManagedBeanFromTemplateCommand.getActionFromPath(CreateFacesActionNodeResourceCommand.this.beanName);
                    monitor.worked(100);
                    monitor.subTask(ResourceHandler.CreateFacesActionNodeResourceCommand_CreateManagedBeanEntry);
                    ManagedBeanType managedBean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
                    ManagedBeanNameType name = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
                    name.setTextContent(CreateFacesActionNodeResourceCommand.this.beanName);
                    managedBean.setManagedBeanName(name);
                    ManagedBeanClassType clazz = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
                    clazz.setTextContent(typeName);
                    managedBean.setManagedBeanClass(clazz);
                    ManagedBeanScopeType scope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
                    scope.setTextContent("request");
                    managedBean.setManagedBeanScope(scope);
                    config.getManagedBean().add((Object)managedBean);
                    CreateFacesActionNodeResourceCommand.this.createManagedBeanAprover.setProceed(true);
                } else if (!actionFound) {
                    CreateFacesActionNodeResourceCommand.this.addActionAprover.setProceed(true);
                }
                return true;
            }
        };
        this.facesChangeCommand = FacesChangeCommand.getFacesCommand(edit, changes, true);
        this.facesChangeCommand.execute();
        monitor.done();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.node.removeAdapter(FacesAction.class);
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }
}

