/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.FacesUtils;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.FacesTargetUtilities;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesAction;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class RenameFacesActionInvocationResourceCommand
extends AbstractCommand {
    private final IAdaptable linkHandleAdapter;
    private final int index;
    private final String oldAction;
    private final String newAction;
    private boolean renamedAction = false;
    private String oldBeanName = "";
    private String oldActionName = "";
    private String newBeanName = "";
    private String newActionName = "";
    private String classname;
    private boolean renamedFacesLink = false;
    private CompoundCommand facesChangeCommand;
    private IFile jspFile;
    private String path;
    private String tagName;
    private final boolean updateManagedBean;

    public RenameFacesActionInvocationResourceCommand(IAdaptable linkHandleAdapter, String newActionName, String oldActionName, int index, boolean updateManagedBean) {
        super(ResourceHandler.RenameFacesActionOutcome);
        this.index = index;
        this.linkHandleAdapter = linkHandleAdapter;
        this.newAction = newActionName;
        this.oldAction = oldActionName;
        this.updateManagedBean = updateManagedBean;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        List<String> facesAction = FacesProvider.getNameSegments(this.oldAction);
        this.oldBeanName = "";
        this.oldActionName = "";
        if (facesAction.size() > 1) {
            this.oldBeanName = facesAction.get(0);
            this.oldActionName = facesAction.get(1);
        }
        facesAction = FacesProvider.getNameSegments(this.newAction);
        this.newActionName = "";
        if (facesAction.size() > 1) {
            this.newBeanName = facesAction.get(0);
            this.newActionName = facesAction.get(1);
        } else {
            this.newBeanName = "";
        }
        if (!this.isValidFacesActionName(this.newBeanName, this.newActionName)) {
            return CommandResult.newCancelledCommandResult();
        }
        ILink linkHandle = (ILink)this.linkHandleAdapter.getAdapter(ILink.class);
        this.jspFile = this.getJspFile();
        this.path = AbstractWebProvider.trimQuotes((String)linkHandle.getLinkText());
        this.tagName = linkHandle.getParameter("tagname");
        try {
            FacesTargetUtilities.updateFacesLink(this.index, this.jspFile, this.path, this.tagName, BindingUtil.makeVbl((String)this.newAction));
        }
        catch (Exception e) {
            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
        }
        this.renamedFacesLink = true;
        if (this.updateManagedBean) {
            IFile facesConfigFile = this.getFileToModify();
            FacesAction handle = FacesLinkUtil.getFacesActionTarget((ILink)linkHandle);
            final ILink managedBeanHandle = FacesLinkUtil.getMBTarget((ILink)handle.managedbean);
            if (managedBeanHandle != null) {
                if (this.facesChangeCommand == null) {
                    if (!this.oldBeanName.equals(this.newBeanName) && facesConfigFile != null) {
                        FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

                            @Override
                            protected boolean doFacesChanges(FacesConfigType facesConfig) {
                                ManagedBeanNameType name = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
                                name.setTextContent(RenameFacesActionInvocationResourceCommand.this.newBeanName);
                                ManagedBeanType managedBean = (ManagedBeanType)FacesLinkUtil.getCorrespondingEObject((EClass)FacesConfigPackage.eINSTANCE.getManagedBeanType(), (EObject)facesConfig, (ILink)managedBeanHandle);
                                managedBean.setManagedBeanName(name);
                                return true;
                            }
                        };
                        FacesChangeCommand tmp = FacesChangeCommand.getFacesCommand(facesConfigFile, changes, true);
                        if (this.facesChangeCommand == null) {
                            this.facesChangeCommand = new CompoundCommand("RenameFacesActionInvocationResourceCommandCompound");
                        }
                        this.facesChangeCommand.append((Command)tmp);
                    }
                    if (this.facesChangeCommand != null) {
                        this.facesChangeCommand.execute();
                    }
                } else {
                    this.facesChangeCommand.redo();
                }
                if (!this.oldActionName.equals(this.newActionName) && facesConfigFile != null) {
                    this.classname = managedBeanHandle.getLinkText();
                    FacesUtils.renameManagedBeanAction(facesConfigFile.getProject(), this.classname, this.oldActionName, this.newActionName, progressMonitor);
                    this.renamedAction = true;
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    private IFile getJspFile() {
        if (this.jspFile == null) {
            Item item = (Item)this.linkHandleAdapter.getAdapter(Item.class);
            this.jspFile = WebProvider.getFileForNode((MNode)item.getNode());
        }
        return this.jspFile;
    }

    private boolean isValidFacesActionName(String newBeanName, String newActionName) {
        String errorMessage = null;
        if (newBeanName.length() == 0 || newActionName.length() == 0) {
            errorMessage = ResourceHandler.FacesActionStringMustHaveTheFormat;
        } else if (!JavaConventions.validateMethodName((String)newActionName).isOK()) {
            errorMessage = ResourceHandler.TheFacesActionMustHaveValidMethodName;
        } else if (!JavaConventions.validateFieldName((String)newBeanName).isOK()) {
            errorMessage = ResourceHandler.FacesBeanNameMustBeValidField;
        }
        if (errorMessage == null) {
            return true;
        }
        final String tErrorMessage = errorMessage;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 32);
                box.setText(ResourceHandler.InvalidRename);
                box.setMessage(tErrorMessage);
                box.open();
            }
        });
        return false;
    }

    protected IFile getFileToModify() {
        FacesAction action;
        ILink handle = (ILink)this.linkHandleAdapter.getAdapter(ILink.class);
        if (handle != null && (action = FacesLinkUtil.getFacesActionTarget((ILink)handle)) != null) {
            return (IFile)action.managedbean.getContainer().getResource();
        }
        return null;
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.renamedAction) {
            FacesUtils.renameManagedBeanAction(this.jspFile.getProject(), this.classname, this.newActionName, this.oldActionName, progressMonitor);
            this.renamedAction = false;
        }
        if (this.renamedFacesLink) {
            try {
                String tempAction = "";
                if (this.oldAction.length() > 0) {
                    tempAction = BindingUtil.makeVbl((String)this.oldAction);
                }
                FacesTargetUtilities.updateFacesLink(this.index, this.jspFile, this.newAction, this.tagName, tempAction);
            }
            catch (Exception e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }
}

