/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items;

import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.IPathModifier;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FacesPathModifier
implements IPathModifier {
    private final String preferredFacesServletPattern = "*.faces";

    private Set<String> getUrlMappings(IProject project) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{project});
        SearchPattern servletLinks = SearchPattern.createPattern((String)"javaee.webxml.servlet", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern facesLinkText = SearchPattern.createPattern((String)"javax.faces.webapp.FacesServlet", (SearchType)SearchType.BY_LINKTEXT, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        NullProgressMonitor m = new NullProgressMonitor();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(facesLinkText.and(servletLinks), scope, (SearchRequestor)requestor, (IProgressMonitor)m);
        Set matches = requestor.getMatches();
        Assert.isTrue((matches.size() <= 1 ? 1 : 0) != 0, (String)"Multi matches");
        HashSet<String> urlPatterns = new HashSet<String>();
        if (matches.size() > 0) {
            ILink facesServletLink = (ILink)matches.iterator().next();
            Collection incoming = facesServletLink.resolveIncomingReference("javaee.webxml.servlet.name.reference", null);
            for (IResolvedReference resolvedReference : incoming) {
                ILink alink = resolvedReference.getSource();
                if (!"javaee.webxml.smapping".equals(alink.getSpecializedType().getId())) continue;
                urlPatterns.add(alink.getName());
            }
        }
        return urlPatterns;
    }

    public String modifyPath(String path, IVirtualComponent component) {
        Set<String> patterns = this.getUrlMappings(component.getProject());
        String updatePattern = "*.faces";
        if (!this.hasPreferredPattern(patterns) && patterns.size() > 0) {
            updatePattern = patterns.iterator().next();
        }
        if (path == null) {
            return path;
        }
        if (this.isPrefixUrlPattern(updatePattern)) {
            String prefix = updatePattern.substring(0, updatePattern.length() - 1);
            if (prefix.length() > 0 && prefix.startsWith("/")) {
                prefix = prefix.substring(1);
            }
            int lastIndex = path.lastIndexOf(47);
            String folderPath = "";
            if (lastIndex > -1) {
                folderPath = path.substring(0, path.lastIndexOf(47) + 1);
                path = path.length() > lastIndex ? path.substring(path.lastIndexOf(47) + 1) : "";
            }
            path = String.valueOf(folderPath) + prefix + path;
        } else if (this.isSuffixUrlPattern(updatePattern) && updatePattern.length() > 2) {
            String suffix = updatePattern.substring(1, updatePattern.length());
            int lastIndex = path.lastIndexOf(46);
            if (lastIndex > -1) {
                path = path.substring(0, lastIndex);
            }
            path = String.valueOf(path) + suffix;
        }
        return path;
    }

    private boolean hasPreferredPattern(Collection<String> patterns) {
        return patterns.contains("*.faces");
    }

    private boolean isPrefixUrlPattern(String p) {
        if (p != null) {
            return p.endsWith("*");
        }
        return false;
    }

    private boolean isSuffixUrlPattern(String p) {
        if (p != null) {
            return p.startsWith("*");
        }
        return false;
    }
}

