/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.TargetNodeAdapter;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;

public class UpdateToViewCommand
extends AbstractCommand {
    private FacesChangeCommand facesChangeCommand;
    private final Item sourceItem;
    private final TargetNodeAdapter targetNodeAdapter;

    public UpdateToViewCommand(Item sourceItem, TargetNodeAdapter targetNodeAdapter) {
        super(ResourceHandler.CreateNavigationRule, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)sourceItem.eResource())));
        this.sourceItem = sourceItem;
        this.targetNodeAdapter = targetNodeAdapter;
    }

    private String getToView() {
        String toView = this.targetNodeAdapter.getTargetPath();
        toView = FacesLinkUtil.addLeadingSlash((String)toView);
        return toView;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        final FacesNavigation handle = (FacesNavigation)this.sourceItem.getAdapter(FacesNavigation.class);
        if (handle != null) {
            FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

                @Override
                protected boolean doFacesChanges(FacesConfigType facesConfig) {
                    FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
                    FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
                    ToViewIdType toViewId = facesConfigFactory.createToViewIdType();
                    toViewId.setTextContent(UpdateToViewCommand.this.getToView());
                    NavigationCaseType navCase = (NavigationCaseType)FacesLinkUtil.getCorrespondingEObject((EClass)facesConfigPackage.getNavigationCaseType(), (EObject)facesConfig, (ILink)handle.toView);
                    if (navCase != null) {
                        navCase.setToViewId(toViewId);
                    }
                    return true;
                }
            };
            this.facesChangeCommand = FacesChangeCommand.getFacesCommand((IFile)handle.navRule.getContainer().getResource(), changes, true);
            this.facesChangeCommand.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }
}

