/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.faces.internal.DiagramFacesPlugin;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.osgi.framework.Bundle;

public class CreateManagedBeanFromTemplateCommand
extends AbstractCommand {
    private final String path;
    private final IProject project;
    private final String actionName;
    private IFile javaFile;
    private final CommandExecutionAprover createManagedBeanAprover;

    public CreateManagedBeanFromTemplateCommand(String path, IProject project, String actionName, CommandExecutionAprover createManagedBeanAprover) {
        super(ResourceHandler.CreateManagedBean);
        this.path = path;
        this.project = project;
        this.actionName = actionName;
        this.createManagedBeanAprover = createManagedBeanAprover;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.createManagedBeanAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        progressMonitor.beginTask("", 1200);
        progressMonitor.subTask(ResourceHandler.CreateActionClass);
        IFolder folder = Model2Util.getSourceFolder((IProject)this.project);
        progressMonitor.worked(100);
        IJavaElement rootElement = JavaCore.create((IFolder)folder);
        progressMonitor.worked(100);
        if (rootElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)rootElement;
            try {
                String pkg = CreateManagedBeanFromTemplateCommand.getDefaultFacesActionPackageName(Model2Util.findComponent((IResource)this.project));
                progressMonitor.worked(100);
                SubProgressMonitor sub1 = new SubProgressMonitor(progressMonitor, 500, 4);
                IPackageFragment selectedFragment = root.createPackageFragment(pkg, false, (IProgressMonitor)sub1);
                String noFirstSlash = this.path.replaceFirst("/", "");
                String actionCUName = CreateManagedBeanFromTemplateCommand.getActionFromPath(noFirstSlash);
                if (!selectedFragment.getCompilationUnit(String.valueOf(actionCUName) + ".java").exists()) {
                    String template = this.readTemplateFile();
                    template = template.replaceAll("\\{\\$bean\\}", actionCUName);
                    template = template.replaceFirst("\\{\\$package\\}", pkg);
                    template = template.replaceFirst("\\{\\$actionMethod\\}", this.actionName);
                    template = template.replaceAll("\\{\\$success\\}", ResourceHandler.Success);
                    template = template.replaceAll("\\{\\$failure\\}", ResourceHandler.Failure);
                    SubProgressMonitor sub2 = new SubProgressMonitor(progressMonitor, 500, 4);
                    ICompilationUnit unit = selectedFragment.createCompilationUnit(String.valueOf(actionCUName) + ".java", template, false, (IProgressMonitor)sub2);
                    this.javaFile = (IFile)unit.getUnderlyingResource();
                } else {
                    progressMonitor.worked(500);
                }
            }
            catch (JavaModelException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        progressMonitor.done();
        return CommandResult.newOKCommandResult();
    }

    protected String readTemplateFile() {
        StringBuffer typeTemplate;
        block5: {
            typeTemplate = new StringBuffer();
            try {
                InputStream is = FileLocator.openStream((Bundle)DiagramFacesPlugin.getDefault().getBundle(), (IPath)new Path("templates/facesActionDefaultClass.template"), (boolean)false);
                if (is == null) break block5;
                byte[] buffer = new byte[1024];
                int read = 0;
                try {
                    while ((read = is.read(buffer, 0, 1024)) >= 0) {
                        typeTemplate.append(new String(buffer, 0, read));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException iOException) {}
        }
        return typeTemplate.toString();
    }

    public static String getActionFromPath(String path) {
        return JavaCodeUtil.capitalizeFirst((String)JavaCodeUtil.legalizeJavaIdentifier((String)path));
    }

    public static String getDefaultFacesActionPackageName(IVirtualComponent component) {
        String pkg = Model2ProjectPropertyUtils.getPackagePrefix((IProject)component.getProject());
        if (pkg.length() > 0) {
            pkg = String.valueOf(pkg) + ".";
        }
        pkg = String.valueOf(pkg) + "actions";
        IProject project = component.getProject();
        IFolder folder = Model2Util.getSourceFolder((IProject)project);
        IJavaElement rootElement = JavaCore.create((IFolder)folder);
        if (rootElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)rootElement;
            try {
                IJavaElement[] e = root.getChildren();
                int i = 0;
                while (i < e.length) {
                    IPackageFragment frag;
                    String fName;
                    IJavaElement javaElement = e[i];
                    if (javaElement.getElementType() == 4 && (fName = (frag = (IPackageFragment)javaElement).getElementName()).equalsIgnoreCase(pkg)) {
                        pkg = fName;
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return pkg;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.javaFile != null) {
            try {
                IFileState[] state = this.javaFile.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.javaFile.create(state[0].getContents(), false, progressMonitor);
                }
            }
            catch (CoreException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.javaFile != null) {
            try {
                this.javaFile.delete(true, true, progressMonitor);
            }
            catch (CoreException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

