/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.references;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class DiagramFacesLinkDetector
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            TreeWalker iter = ((DocumentTraversal)document).createTreeWalker((Node)document, 1, null, false);
            HashMap<String, IDOMElement> elementToIdMap = new HashMap<String, IDOMElement>();
            Node n = iter.nextNode();
            while (n != null) {
                if ("xmi:XMI".equals(n.getNodeName())) {
                    n = iter.firstChild();
                    continue;
                }
                if ("DiagramModel:Model".equals(n.getNodeName())) {
                    n = iter.firstChild();
                    continue;
                }
                if ("diagram".equals(n.getNodeName())) {
                    links.addAll(this.processDiagramNode(iter, factory, elementToIdMap));
                    n = iter.nextSibling();
                    continue;
                }
                if ("edges".equals(n.getNodeName())) {
                    links.addAll(this.processEdgesNode(iter, factory, elementToIdMap));
                    n = iter.nextSibling();
                    continue;
                }
                n = iter.nextSibling();
            }
        }
        return links;
    }

    private List<ILink> processEdgesNode(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        IDOMElement edge = (IDOMElement)iter.getCurrentNode();
        String type = this.getAttribute((Node)edge, "type");
        String source = this.getAttribute((Node)edge, "source");
        IDOMElement sourceNode = elementToIdMap.get(source);
        if ("com.ibm.etools.model2.diagram.faces.PageNavigationEdge".equals(type)) {
            IDOMElement child = (IDOMElement)iter.firstChild();
            while (child != null) {
                if ("persistedProperties".equals(child.getNodeName())) {
                    ILink link;
                    String linkType;
                    if ("web.edgename.key".equals(this.getAttribute((Node)child, "name"))) {
                        linkType = "wdeWebPath";
                        link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                        links.add(link);
                    } else if ("pagecode.outcome.edge.action.key".equals(this.getAttribute((Node)child, "name"))) {
                        linkType = "wdeFacesAction";
                        link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                        links.add(link);
                    } else if ("pagecode.outcome.edge.outcome.key".equals(this.getAttribute((Node)child, "name"))) {
                        linkType = "wdeFacesOutcome";
                        link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                        String action = this.getAction((IDOMElement)child.getParentNode());
                        String fromView = this.getWebPageName(sourceNode);
                        if (fromView != null) {
                            fromView = "/" + fromView;
                        }
                        factory.addParam(link, "jsf.param.action", action);
                        factory.addParam(link, "jsf.param.fromview", fromView);
                        links.add(link);
                    }
                }
                child = (IDOMElement)iter.nextSibling();
            }
            iter.parentNode();
        } else if ("com.ibm.etools.model2.diagram.faces.FacesActionOutcomeEdge".equals(type)) {
            IDOMElement child = (IDOMElement)iter.firstChild();
            while (child != null) {
                if ("persistedProperties".equals(child.getNodeName())) {
                    ILink link;
                    String linkType;
                    if ("faces.action.outcome.edge.fromview".equals(this.getAttribute((Node)child, "name"))) {
                        linkType = "wdeWebPath";
                        link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                        links.add(link);
                    } else if ("faces.action.outcome.edge.outcome".equals(this.getAttribute((Node)child, "name"))) {
                        linkType = "wdeFacesOutcome";
                        link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                        String action = this.getAction((IDOMElement)child.getParentNode());
                        String fromView = this.getFromView((IDOMElement)child.getParentNode());
                        factory.addParam(link, "jsf.param.action", action);
                        factory.addParam(link, "jsf.param.fromview", fromView);
                        links.add(link);
                    } else if ("faces.action.outcome.edge.action".equals(this.getAttribute((Node)child, "name"))) {
                        linkType = "wdeFacesAction";
                        link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                        links.add(link);
                    }
                }
                child = (IDOMElement)iter.nextSibling();
            }
            iter.parentNode();
        } else if ("com.ibm.etools.model2.diagram.faces.FacesActionInvocationEdge".equals(type)) {
            IDOMElement child = (IDOMElement)iter.firstChild();
            while (child != null) {
                if ("persistedProperties".equals(child.getNodeName()) && "faces.action.invocation.edge.action.key".equals(this.getAttribute((Node)child, "name"))) {
                    String linkType = "wdeFacesAction";
                    ILink link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)child, (IDOMAttr)((IDOMAttr)child.getAttributeNode("value")), (String)linkType, null);
                    links.add(link);
                }
                child = (IDOMElement)iter.nextSibling();
            }
            iter.parentNode();
        }
        return links;
    }

    public String getWebPageName(IDOMElement element) {
        String result = null;
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            IDOMElement e;
            Node n = list.item(i);
            if (n instanceof IDOMElement && "persistedProperties".equals((e = (IDOMElement)n).getNodeName()) && "web.path.key".equals(this.getAttribute((Node)e, "name"))) {
                result = this.getAttribute((Node)e, "value");
                break;
            }
            ++i;
        }
        return result == null ? "" : result;
    }

    private String getFromView(IDOMElement parentNode) {
        String result = null;
        NodeList list = parentNode.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            IDOMElement e;
            Node n = list.item(i);
            if (n instanceof IDOMElement && "persistedProperties".equals((e = (IDOMElement)n).getNodeName())) {
                if ("web.edgename.key".equals(this.getAttribute((Node)e, "name"))) {
                    result = this.getAttribute((Node)e, "value");
                    break;
                }
                if ("pagecode.outcome.edge.action.key".equals(this.getAttribute((Node)e, "name"))) {
                    result = this.getAttribute((Node)e, "value");
                    break;
                }
            }
            ++i;
        }
        return result == null ? "" : result;
    }

    private String getAction(IDOMElement parentNode) {
        String result = null;
        NodeList list = parentNode.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            IDOMElement e;
            Node n = list.item(i);
            if (n instanceof IDOMElement && "persistedProperties".equals((e = (IDOMElement)n).getNodeName()) && ("pagecode.outcome.edge.action.key".equals(this.getAttribute((Node)e, "name")) || "faces.action.outcome.edge.action".equals(this.getAttribute((Node)e, "name")))) {
                result = this.getAttribute((Node)e, "value");
                break;
            }
            ++i;
        }
        return result == null ? "" : result;
    }

    private List<ILink> processDiagramNode(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        Node child = iter.firstChild();
        while (child != null) {
            if ("nodes".equals(child.getNodeName())) {
                links.addAll(this.processNodes(iter, factory, elementToIdMap));
            }
            child = iter.nextSibling();
        }
        iter.parentNode();
        return links;
    }

    private List<ILink> processNodes(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        Node current = iter.getCurrentNode();
        while (current != null) {
            String id = this.getAttribute(current, "xmi:id");
            if (id != null) {
                elementToIdMap.put(id, (IDOMElement)current);
            }
            if ("com.ibm.etools.model2.diagram.faces.FacesActionNode".equals(this.getAttribute(current, "type"))) {
                Node child = iter.firstChild();
                while (child != null) {
                    if ("faces.action.node.name".equals(this.getAttribute(child, "name"))) {
                        ILink link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)((IDOMElement)child), (IDOMAttr)((IDOMAttr)((IDOMElement)child).getAttributeNode("value")), (String)"wdeFacesAction", null);
                        links.add(link);
                    }
                    child = iter.nextSibling();
                }
                iter.parentNode();
            }
            current = iter.nextSibling();
        }
        return links;
    }

    private String getAttribute(Node node, String attribute) {
        return ((IDOMElement)node).getAttribute(attribute);
    }
}

