/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.refactoring;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.refactoring.DiagramChange;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class DiagramJDTRefactoringParticipant
extends RenameParticipant
implements ISharableParticipant {
    private final List<ObjectAndArgs> argsList = new ArrayList<ObjectAndArgs>();

    public void addElement(Object element, RefactoringArguments arguments) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = (RenameArguments)arguments;
        args.element = element;
        this.argsList.add(args);
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (ObjectAndArgs args : this.argsList) {
            if (!args.args.getUpdateReferences()) continue;
            IMethod method = (IMethod)args.element;
            SearchPattern pattern = SearchPattern.createPattern((String)method.getParent().getElementName(), (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            pattern = pattern.and(SearchPattern.createPattern((String)"javaee.javatype.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
            SearchScope scope = SearchEngine.createSearchScope((IPath[])new IPath[]{method.getPath()});
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            new SearchEngine().search(pattern, scope, (SearchRequestor)req, null);
            Set links = req.getMatches();
            Iterator iterator = links.iterator();
            while (iterator.hasNext()) {
                ILink link = (ILink)iterator.next();
                if ("javaee.javatype.nodeid".equals(link.getSpecializedType().getId())) continue;
                iterator.remove();
            }
            String beanName = null;
            if (req.getMatches().size() == 1) {
                ILink methodLink = (ILink)req.getMatches().iterator().next();
                Collection incoming = methodLink.resolveIncomingReference(null, null);
                for (IResolvedReference resolvedReference : incoming) {
                    ILink source = resolvedReference.getSource();
                    if (source == null || !"jsf.managedbean".equals(source.getSpecializedType().getId())) continue;
                    beanName = source.getName();
                }
            }
            if (beanName == null) continue;
            changes.addAll(this.renameAction(beanName, method.getElementName(), args.args.getNewName()));
        }
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange change = new CompositeChange(ResourceHandler.DiagramJDTRefactoringParticipant_DiagramChanges, changes.toArray(new Change[changes.size()]));
        return change;
    }

    private List<Change> renameAction(String oldBeanName, String oldActionName, String newActionName) {
        ArrayList<Change> changes = new ArrayList<Change>();
        List resources = WDEEditingDomainManager.INSTANCE.getModelRoots();
        for (Resource resource : resources) {
            TreeIterator itr = resource.getAllContents();
            while (itr.hasNext()) {
                Change change;
                EObject object = (EObject)itr.next();
                if (!"http://www.ibm.com/etools/7.0/DiagramModel".equals(object.eClass().getEPackage().getNsURI())) continue;
                if (object instanceof MNode) {
                    MNode node = (MNode)object;
                    if (!FacesProvider.isFacesActionNode((TypedElement)node) || (change = this.updateFacesAction(oldBeanName, oldActionName, newActionName, (IPropertyHolder)node, "faces.action.node.name", false)) == null) continue;
                    changes.add(change);
                    continue;
                }
                if (!(object instanceof MEdge)) continue;
                MEdge edge = (MEdge)object;
                if (FacesProvider.isPageGlobalEdge((TypedElement)edge)) {
                    change = this.updateFacesAction(oldBeanName, oldActionName, newActionName, (IPropertyHolder)edge, "pagecode.outcome.edge.action.key", true);
                    if (change == null) continue;
                    changes.add(change);
                    continue;
                }
                if (FacesProvider.isActionOutcomeEdge((TypedElement)edge)) {
                    change = this.updateFacesAction(oldBeanName, oldActionName, newActionName, (IPropertyHolder)edge, "faces.action.outcome.edge.action", true);
                    if (change == null) continue;
                    changes.add(change);
                    continue;
                }
                if (!FacesProvider.isActionInvocationEdge((TypedElement)edge) || (change = this.updateFacesAction(oldBeanName, oldActionName, newActionName, (IPropertyHolder)edge, "faces.action.invocation.edge.action.key", true)) == null) continue;
                changes.add(change);
            }
        }
        return changes;
    }

    private Change updateFacesAction(String oldBeanName, String oldActionName, String newActionName, IPropertyHolder node, String propertyName, boolean addVBL) {
        String bean;
        String[] beanAction;
        String beanActionRaw = WebProvider.getStringProperty((String)propertyName, (IPropertyHolder)node);
        if (beanActionRaw == null) {
            return null;
        }
        if (addVBL) {
            beanActionRaw = BindingUtil.removeVbl((String)beanActionRaw);
        }
        String action = (beanAction = beanActionRaw.split("\\.")).length == 2 ? beanAction[1] : null;
        String string = bean = beanAction.length == 2 ? beanAction[0] : null;
        if (bean == null || action == null) {
            return null;
        }
        if (oldActionName.equals(action) && oldBeanName.equals(bean)) {
            String newValue = String.valueOf(beanAction[0]) + "." + newActionName;
            if (addVBL) {
                newValue = BindingUtil.makeVbl((String)newValue);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(propertyName, newValue);
            DiagramChange change = new DiagramChange(node, map);
            return change;
        }
        return null;
    }

    public String getName() {
        return ResourceHandler.DiagramJDTRefactoringParticipant_DiagramChanges;
    }

    protected boolean initialize(Object element) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = this.getArguments();
        args.element = element;
        this.argsList.add(args);
        return true;
    }

    private class ObjectAndArgs {
        public Object element;
        public RenameArguments args;

        private ObjectAndArgs() {
        }
    }
}

