/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.providers.config;

import com.ibm.etools.diagram.model.internal.ItemOffset;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.Map;

public class FacesItemConfiguratorProvider
extends FacesProvider
implements IConfiguratorProvider {
    public void configureNew(CommonElement element) {
        this.addAdapters((Item)element);
    }

    public void configureLoad(CommonElement element) {
        this.addAdapters((Item)element);
    }

    public void configureExisting(CommonElement element, Object existing, Map options) {
    }

    private void addAdapters(final Item item) {
        if (FacesProvider.isActionInvocationItem((TypedElement)item)) {
            ItemOffset offsetAdapter = new ItemOffset(){

                public int getOffset() {
                    ILink linkHandle = (ILink)item.getAdapter(ILink.class);
                    if (linkHandle != null) {
                        return linkHandle.getLinkLocation().getOffset();
                    }
                    return 0;
                }
            };
            item.addAdapter((Object)offsetAdapter, ItemOffset.class);
            item.addAdapter((Object)new StringComparator(), Comparator.class);
        } else if (FacesProvider.isFacesRequestLinkItem((TypedElement)item)) {
            ItemOffset offsetAdapter = new ItemOffset(){

                public int getOffset() {
                    ILink linkHandle = (ILink)item.getAdapter(ILink.class);
                    if (linkHandle != null) {
                        return linkHandle.getLinkLocation().getOffset();
                    }
                    return 0;
                }
            };
            item.addAdapter((Object)offsetAdapter, ItemOffset.class);
            item.addAdapter((Object)new StringComparator(), Comparator.class);
        } else if (FacesProvider.isFacesActionFromViewItem((TypedElement)item)) {
            item.addAdapter((Object)new StringComparator(), Comparator.class);
        } else if (FacesProvider.isFacesPageGlobalItem((TypedElement)item)) {
            item.addAdapter((Object)new StringComparator(), Comparator.class);
        }
    }

    private static class StringComparator
    implements Comparator {
        private static final Collator collator = Collator.getInstance();

        private StringComparator() {
        }

        public int compare(Object source, Object target) {
            Property prop;
            Object s = source;
            Object t = target;
            if (s instanceof IPropertyHolder && (prop = ((IPropertyHolder)s).getTitleProperty()) != null) {
                s = prop.getValue();
            }
            if (t instanceof IPropertyHolder && (prop = ((IPropertyHolder)t).getTitleProperty()) != null) {
                t = prop.getValue();
            }
            if (s == null) {
                return -1;
            }
            if (t == null) {
                return 1;
            }
            if (s == t) {
                return 0;
            }
            return collator.compare(s, t);
        }
    }
}

