/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class FacesChangeCommand
extends ChangeCommand {
    private FacesConfigArtifactEdit edit;
    private final FacesChanges runnable;
    private final boolean shouldForceSave;

    public static FacesChangeCommand getFacesCommand(IFile file, FacesChanges runnable, boolean shouldForceSave) {
        String fileString;
        IPath filePath;
        IPath modulePath = ComponentCore.createComponent((IProject)file.getProject()).getRootFolder().getWorkspaceRelativePath();
        if (modulePath.isPrefixOf(filePath = file.getFullPath()) && (fileString = filePath.removeFirstSegments(modulePath.segmentCount()).makeAbsolute().toString()) != null && fileString.startsWith("/")) {
            FacesConfigArtifactEdit edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)file.getProject(), (String)fileString.substring(1));
            try {
                FacesConfigType type = edit.getFacesConfig();
                return new FacesChangeCommand(edit, (Notifier)type, runnable, shouldForceSave);
            }
            catch (RuntimeException runtimeException) {
                if (edit != null) {
                    edit.dispose();
                }
                return null;
            }
        }
        return null;
    }

    public static FacesChangeCommand getFacesCommand(FacesConfigArtifactEdit edit, FacesChanges runnable, boolean shouldForceSave) {
        FacesConfigType type = edit.getFacesConfig();
        return new FacesChangeCommand(edit, (Notifier)type, runnable, shouldForceSave);
    }

    public FacesChangeCommand(FacesConfigArtifactEdit edit, Notifier notifier, FacesChanges runnable, boolean shouldForceSave) {
        super(notifier);
        this.edit = edit;
        this.runnable = runnable;
        this.shouldForceSave = shouldForceSave;
    }

    protected final void doExecute() {
        boolean succeeded = false;
        if (this.edit != null && (succeeded = this.runnable.doFacesChanges(this.edit.getFacesConfig()))) {
            if (this.shouldForceSave) {
                this.edit.save(null);
            } else {
                this.edit.saveIfNecessary(null);
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.shouldForceSave) {
            this.edit.save(null);
        } else {
            this.edit.saveIfNecessary(null);
        }
    }

    public void redo() {
        super.redo();
        if (this.shouldForceSave) {
            this.edit.save(null);
        } else {
            this.edit.saveIfNecessary(null);
        }
    }

    public void dispose() {
        this.edit.dispose();
        this.edit = null;
        super.dispose();
    }

    public static abstract class FacesChanges {
        protected abstract boolean doFacesChanges(FacesConfigType var1);
    }
}

