/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.model2.base.Model2BasePlugin;
import com.ibm.etools.model2.base.nls.ResourceHandler;
import com.ibm.etools.model2.base.util.Accessor;
import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.wizards.IModel2RegionData;
import com.ibm.etools.webtools.wizards.WebtoolsWizardsPlugin;
import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.JMethod;
import com.ibm.etools.webtools.wizards.basic.JParameter;
import com.ibm.etools.webtools.wizards.basic.TypeDataUtil;
import com.ibm.etools.webtools.wizards.basic.TypeWizardUtil;
import com.ibm.etools.webtools.wizards.cgen.impl.WebRegionCodeGenModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WizardUtils
extends TypeDataUtil {
    private static final String BASE_CATEGORY = "Model2BasePlugin";
    protected static final String STRUTS = "org.apache.struts.action";
    protected static final String SERVLET = "javax.servlet";
    protected static final String SERVLET_HTTP = "javax.servlet.http";
    protected static final String IO = "java.io";
    public static final String DOT = ".";
    public static final char DOT_CHAR = '.';
    public static final String STAR = "*";
    public static final char SLASH_CHAR = '/';
    public static final String SLASH_STRING = "/";
    public static final String SPACE = " ";
    public static final String EMPTY_TYPE = "";
    public static final String EMPTY_PATH = "";
    protected static final String EMPTY_NAME = "";
    public static final String SOURCE_SUFFIX = "java";
    public static final String PUBLIC_MODIFIER = "public";
    public static final String ABSTRACT = "abstract";
    public static final String CGM = "cgm";
    public static final String CONFIG_FILE = "configFile";
    public static final String CONSTRUCTORS_FROM_SUPERCLASS = "cFS";
    public static final String DEFAULT_CONSTRUCTOR = "dc";
    public static final String DESTINATION_FOLDER = "destinationFolder";
    public static final String FINAL = "final";
    public static final String GENERATE_RADIO = "generateRadio";
    public static final String INHERITED_ABSTRACT_METHODS = "iAMs";
    public static final String MODEL = "model";
    public static final String PACKAGE_FRAGMENT = "packageFragment";
    public static final String PREFIX = "prefix";
    public static final String PROJECT = "project";
    public static final String PUBLIC = "public";
    public static final String REUSE_RADIO = "reuseRadio";
    public static final String REUSE_TYPE_NAME = "reuseTypeName";
    public static final String SUPERCLASS = "superclass";
    public static final String SUPERCLASS_NAME = "superclassName";
    public static final String SUPERCLASS_TYPE = "superclassType";

    public WizardUtils(ITypeRegionData rd, TypeWizardUtil wu) {
        super(rd, wu);
    }

    public static String addLeadingSlash(String path) {
        if (path.charAt(0) != '/') {
            path = new StringBuffer(SLASH_STRING).append(path).toString();
        }
        return path;
    }

    public static void addNature(String natureId, IProject project) {
        assert (project != null);
        assert (natureId != null && natureId.length() > 0);
        try {
            if (project.hasNature(natureId)) {
                return;
            }
            if (ResourcesPlugin.getWorkspace().getNatureDescriptor(natureId) != null) {
                ProjectUtilities.addNatureToProject((IProject)project, (String)natureId);
            }
        }
        catch (CoreException coreException) {}
    }

    public static String areModifiersInvalid(ITypeRegionData rd) {
        assert (rd != null);
        if (rd.isAbstract() && rd.isFinal()) {
            return ResourceHandler.wizards_common_error_badmodifier;
        }
        return null;
    }

    public static boolean booleansEqual(boolean one, boolean other) {
        return !(one ^ other);
    }

    public static boolean cgmsEqual(WebRegionCodeGenModel one, WebRegionCodeGenModel other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        String oneId = one.getId();
        if (other == null) {
            return false;
        }
        return oneId.equals(other.getId());
    }

    public static String dotAppend(List strings) {
        return WizardUtils.dotAppend(strings.toArray(new String[strings.size()]));
    }

    public static String dotAppend(String s0, String s1) {
        return new StringBuffer(s0).append(DOT).append(s1).toString();
    }

    public static String dotAppend(String[] strings) {
        StringBuffer sb = new StringBuffer(strings[0]);
        int len = strings.length;
        if (len > 1) {
            int i = 1;
            while (i < len) {
                sb.append(DOT).append(strings[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static int dots(String s) {
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '.') {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static String dotsToSlashes(String s) {
        int index = s.indexOf(DOT);
        while (index != -1) {
            s = String.valueOf(s.substring(0, index)) + SLASH_STRING + s.substring(index + 1);
            index = s.indexOf(DOT);
        }
        return s;
    }

    public static String extendClassname(String cn) {
        return WizardUtils.dotAppend(cn, SOURCE_SUFFIX);
    }

    public static String fqcn2cn(String fqcn) {
        int i = fqcn.lastIndexOf(46);
        if (i == -1) {
            return fqcn;
        }
        return fqcn.substring(i + 1);
    }

    public static String fqcn2pkg(String fqcn) {
        int i = fqcn.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return fqcn.substring(0, i);
    }

    protected static String getCategory() {
        return BASE_CATEGORY;
    }

    protected static String getClassname(IModel2RegionData srd, String cn) {
        assert (srd != null);
        assert (cn != null && cn.length() > 0);
        StringBuffer ret = new StringBuffer();
        String pn = WizardUtils.getJavaPackageName(srd);
        if (!WizardUtils.isEmpty(pn)) {
            ret.append(pn).append(DOT);
        }
        ret.append(cn);
        return ret.toString();
    }

    public static String[] getCodeGenModelIds(IModel2RegionData m2rd) {
        return WizardUtils.getCodeGenModelIds(m2rd.getCodeGenModels());
    }

    public static String[] getCodeGenModelIds(WebRegionCodeGenModel[] cgms) {
        String[] ret = null;
        if (!WizardUtils.isEmpty(cgms)) {
            int cgmslen = cgms.length;
            ret = new String[cgmslen];
            int i = 0;
            while (i < cgmslen) {
                WebRegionCodeGenModel cgm = cgms[i];
                assert (cgm != null);
                ret[i] = cgm.getId();
                ++i;
            }
        }
        return ret;
    }

    public static int getCodeGenModelIndex(IModel2RegionData m2rd, WebRegionCodeGenModel cgm) {
        assert (m2rd != null);
        assert (cgm != null);
        String cgmId = cgm.getId();
        assert (cgmId != null && cgmId.length() > 0);
        String[] cgmi = WizardUtils.getCodeGenModelIds(m2rd);
        assert (cgmi != null);
        List<String> cgml = Arrays.asList(cgmi);
        if (!WizardUtils.isEmpty(cgml)) {
            return cgml.indexOf(cgmId);
        }
        return -1;
    }

    public static int getColumnIndex(Event e, TableItem ti, int nc) {
        int ret = -1;
        Point p = new Point(e.x, e.y);
        int i = 0;
        while (i < nc) {
            Rectangle r = ti.getBounds(i);
            if (r.contains(p)) {
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public static IVirtualComponent getComponent() {
        IVirtualComponent ret = WizardUtils.selection2VirtualComponent(WizardUtils.getCurrentSelection());
        return ret;
    }

    public static IVirtualComponent getComponent(IModel2RegionData srd) {
        IVirtualComponent ret = srd.getComponent();
        if (ret == null && (ret = WizardUtils.getComponent()) != null) {
            srd.setComponent(ret);
        }
        return ret;
    }

    public static IVirtualComponent[] getComponents() {
        return ComponentUtilities.getAllWorkbenchComponents();
    }

    public static IConfigurationElement[] getConfigurationElementsFor(String extId) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = reg.getConfigurationElementsFor(extId);
        if (elems.length > 0) {
            return elems;
        }
        return null;
    }

    protected static ISelection getCurrentSelection() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return null;
        }
        ISelectionService ss = w.getSelectionService();
        ISelection s = ss.getSelection();
        if (s instanceof IStructuredSelection) {
            return s;
        }
        return s;
    }

    public static IPackageFragment getDefaultJavaPackageFragment(IModel2RegionData rd) {
        String oldDjpp = WizardUtils.getDefaultJavaPackagePrefix(rd);
        String oldDjps = WizardUtils.getDefaultJavaPackageSuffix(rd);
        StringBuffer buffer = new StringBuffer(oldDjpp);
        if (!WizardUtils.isEmpty(oldDjpp) && !WizardUtils.isEmpty(oldDjps)) {
            buffer.append('.');
        }
        buffer.append(oldDjps);
        if (WizardUtils.isEmpty(buffer)) {
            return null;
        }
        IPackageFragmentRoot oldJpfr = WizardUtils.getJavaPackageFragmentRoot(rd);
        if (oldJpfr == null) {
            return null;
        }
        return oldJpfr.getPackageFragment(buffer.toString());
    }

    public static String getDefaultJavaPackagePrefix(IModel2RegionData rd) {
        IVirtualComponent component = WizardUtils.getComponent(rd);
        if (component != null) {
            return Model2ProjectPropertyUtils.getPackagePrefix(rd.getProject());
        }
        return "";
    }

    public static String getDefaultJavaPackageSuffix(IModel2RegionData rd) {
        String ret = rd.getDefaultJavaPackageSuffix();
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public static String getDefaultSuperclassName(IModel2RegionData srd) {
        return srd.getDefaultSuperClassName();
    }

    public static IContainer getDestinationFolder(IModel2RegionData srd) {
        IVirtualComponent webModule;
        assert (srd != null);
        IContainer df = srd.getDestinationFolder();
        if (df == null && (webModule = WizardUtils.getComponent(srd)) != null) {
            df = Model2Util.getSourceFolder(webModule);
            srd.setDestinationFolder(df);
        }
        return df;
    }

    protected static String getFQClassname(IModel2RegionData srd) {
        return WizardUtils.getFQClassname(srd, WizardUtils.getPrefix(srd));
    }

    protected static String getFQClassname(IModel2RegionData srd, String cn) {
        assert (srd != null);
        StringBuffer ret = new StringBuffer();
        String pn = WizardUtils.getJavaPackageName(srd);
        if (!WizardUtils.isEmpty(pn)) {
            ret.append(pn).append(DOT);
        }
        ret.append(cn);
        return ret.toString();
    }

    public static IPackageFragment getJavaPackageFragment(IModel2RegionData srd) {
        IPackageFragment ipf = srd.getJavaPackageFragment();
        if (ipf == null) {
            ipf = WizardUtils.getDefaultJavaPackageFragment(srd);
        }
        return ipf;
    }

    public static IPackageFragmentRoot getJavaPackageFragmentRoot(IModel2RegionData trd) {
        return trd.getJavaPackageFragmentRoot();
    }

    public static String getJavaPackageName(IModel2RegionData rd) {
        String oldPN;
        assert (rd != null);
        String newPN = oldPN = rd.getJavaPackageName();
        IPackageFragment pf = rd.getJavaPackageFragment();
        if (pf == null) {
            pf = WizardUtils.getDefaultJavaPackageFragment(rd);
        }
        if (!Model2Util.isEqualOrBothNull(oldPN, newPN = pf.getElementName())) {
            rd.setJavaPackageName(newPN);
        }
        return newPN;
    }

    public static IJavaProject getJavaProject(IModel2RegionData regionData) {
        IProject project;
        assert (regionData != null);
        IVirtualComponent component = WizardUtils.getComponent(regionData);
        if (component != null && (project = component.getProject()) != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IFolder getJavaSourceFolder(IModel2RegionData srd, IProject ip) {
        IFolder ret;
        block4: {
            ret = null;
            Assert.isNotNull((Object)srd);
            Assert.isNotNull((Object)ip);
            IJavaProject project = JavaCore.create((IProject)ip);
            try {
                IPackageFragmentRoot[] roots;
                if (project == null) break block4;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (!packageFragmentRoot.isExternal()) {
                        ret = (IFolder)packageFragmentRoot.getUnderlyingResource();
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return ret;
    }

    public static IVirtualComponent[] getNonEarModules() {
        Object[] ret = ComponentUtilities.getAllWorkbenchComponents();
        if (!WizardUtils.isEmpty(ret)) {
            ArrayList<Object> retL = new ArrayList<Object>(ret.length);
            retL.addAll(Arrays.asList(ret));
            if (WizardUtils.isEmpty(retL)) {
                return null;
            }
            List<IProject> ears = Arrays.asList(J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ear"));
            if (WizardUtils.isEmpty(ears)) {
                return ret;
            }
            retL.removeAll(ears);
            if (!WizardUtils.isEmpty(retL)) {
                ret = retL.toArray(new IVirtualComponent[retL.size()]);
            }
        }
        return ret;
    }

    public static IPackageFragment getPackageFragment(IModel2RegionData srd) {
        return WizardUtils.getJavaPackageFragment(srd);
    }

    public static String getPrefix(ITypeRegionData srd) {
        assert (srd != null);
        return srd.getPrefix();
    }

    public static String getProjectName(IModel2RegionData srd) {
        String ret = "";
        IVirtualComponent component = WizardUtils.getComponent(srd);
        if (component == null && WizardUtils.getComponent() == null) {
            return ret;
        }
        ret = component.getName();
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static String[] getSubclasses(IType t, ITypeHierarchy th, boolean inclusive) {
        int i;
        IType[] subts = th.getSubclasses(t);
        if (subts == null) {
            return null;
        }
        int len = subts.length;
        if (len <= 0) {
            return new String[0];
        }
        String[] ret = null;
        if (inclusive) {
            i = 1;
            ret = new String[++len];
            ret[0] = t.getFullyQualifiedName();
        } else {
            i = 0;
            ret = new String[len];
        }
        int j = 0;
        while (i < len) {
            ret[i] = subts[j].getFullyQualifiedName();
            assert (ret[i] != null && ret[i].length() > 0);
            ++i;
            ++j;
        }
        return ret;
    }

    public static IType getSuperClass(IModel2RegionData srd) {
        return WizardUtils.getSuperClass(srd, null);
    }

    public static IType getSuperClass(IModel2RegionData srd, String defaultSCN) {
        assert (srd != null);
        IType ret = srd.getSuperClass();
        if (ret == null) {
            IJavaProject jp;
            if (defaultSCN == null) {
                defaultSCN = WizardUtils.getDefaultSuperclassName(srd);
            }
            if ((jp = srd.getJavaProject()) != null) {
                ret = Model2Util.getType(jp, defaultSCN);
            }
        }
        srd.setSuperClass(ret);
        return ret;
    }

    public static String getSuperClassName(IModel2RegionData ard) {
        assert (ard != null);
        String ret = ard.getSuperClassName();
        if (WizardUtils.isEmpty(ret)) {
            IType sct = ard.getSuperClass();
            if (sct != null) {
                ret = sct.getFullyQualifiedName();
            }
            if (WizardUtils.isEmpty(ret)) {
                ret = ard.getDefaultSuperClassName();
            }
        }
        return ret;
    }

    public static IType getType(IModel2RegionData mrd, String fqscn) {
        IType ret = null;
        if (mrd == null) {
            return null;
        }
        IJavaProject javaProject = mrd.getJavaProject();
        if (javaProject != null) {
            ret = Model2Util.getType(javaProject, fqscn);
        }
        return ret;
    }

    public static IStatus getWorstStatus(List iss) {
        IStatus ret = null;
        if (!WizardUtils.isEmpty(iss)) {
            for (IStatus is : iss) {
                if (!WizardUtils.isWorseThan(is, ret)) continue;
                ret = is;
            }
        }
        return ret;
    }

    public static boolean hasLeadingSlash(String path) {
        return !WizardUtils.isEmpty(path) && path.charAt(0) == '/';
    }

    public static boolean hasSelection(Viewer v) {
        return v != null && !WizardUtils.isEmpty(v.getSelection());
    }

    public static boolean isAtLeastError(IStatus is) {
        return is.getSeverity() >= 4;
    }

    public static boolean isAtLeastInfo(IStatus is) {
        return is.getSeverity() >= 1;
    }

    public static boolean isAtLeastWarning(IStatus is) {
        return is.getSeverity() >= 2;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(ISelection selection) {
        return selection == null || selection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmpty(StringBuffer stringBuffer) {
        return stringBuffer == null || stringBuffer.length() == 0;
    }

    public static boolean isError(IStatus is) {
        return is.getSeverity() == 4;
    }

    public static boolean isInfo(IStatus is) {
        return is.getSeverity() == 1;
    }

    public static String isJavaPackageNameInvalid(String p, ITypeRegionData trd) {
        IPackageFragmentRoot root;
        assert (p != null && p.length() > 0);
        String ret = null;
        IStatus val = JavaConventions.validatePackageName((String)p);
        if (val.getSeverity() == 4) {
            ret = NLS.bind((String)ResourceHandler.wizards_common_badpackage, (Object)val.getMessage());
        }
        if ((root = trd.getJavaPackageFragmentRoot()) != null) {
            IPackageFragment pack = root.getPackageFragment(p);
            try {
                IPath packagePath;
                IPath rootPath = root.getPath();
                IPath outputPath = root.getJavaProject().getOutputLocation();
                if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = pack.getUnderlyingResource().getFullPath())) {
                    ret = NLS.bind((String)ResourceHandler.wizards_common_badpackage, (Object)ResourceHandler.wizards_common_badpackage_include);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return ret;
    }

    public static boolean isPrimitive(String t) {
        return t.equals("boolean") || t.equals("byte") || t.equals("char") || t.equals("double") || t.equals("float") || t.equals("int") || t.equals("long") || t.equals("short");
    }

    public static boolean isQualified(String s) {
        if (WizardUtils.isEmpty(s)) {
            return false;
        }
        int i = s.lastIndexOf(DOT);
        return i > -1;
    }

    public static boolean isQualifiedClassname(String s) {
        return WizardUtils.isQualified(s) && WizardUtils.isValidJavaClassName(s);
    }

    public static boolean isRadio(Widget b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof Button)) {
            return false;
        }
        return (b.getStyle() & 0x10) != 0;
    }

    public static boolean isRealFQName(String s, IJavaProject jp) {
        if (WizardUtils.isQualified(s)) {
            IType t = null;
            try {
                t = jp.findType(s);
            }
            catch (JavaModelException javaModelException) {}
            if (t == null) {
                return false;
            }
            assert (s.equals(t.getFullyQualifiedName()));
            return true;
        }
        return false;
    }

    public static boolean isSimpleClassname(String s) {
        if (WizardUtils.isEmpty(s)) {
            return false;
        }
        int i = s.lastIndexOf(DOT);
        if (i > -1) {
            return false;
        }
        return WizardUtils.isValidJavaClassName(s);
    }

    public static boolean isValidJavaClassName(String cn) {
        return JavaConventions.validateJavaTypeName((String)cn).getSeverity() != 4;
    }

    public static boolean isValidSuperclassName(IModel2RegionData srd, String defSCN) {
        assert (srd != null);
        if (WizardUtils.isEmpty(defSCN)) {
            return false;
        }
        return WizardUtils.isValidJavaClassName(defSCN);
    }

    public static boolean isWarning(IStatus is) {
        return is.getSeverity() == 2;
    }

    public static boolean isWorseThan(IStatus first, IStatus second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return true;
        }
        return first.getSeverity() > second.getSeverity();
    }

    public static boolean isWrapper(String t) {
        return t.equals("Boolean") || t.equals("Byte") || t.equals("Character") || t.equals("Double") || t.equals("Float") || t.equals("Integer") || t.equals("Long") || t.equals("Short");
    }

    public static String lcfc(String s) {
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public static IType loadDefaultSuperClass(IModel2RegionData srd) {
        return WizardUtils.loadSuperClass(srd, WizardUtils.getDefaultSuperclassName(srd));
    }

    public static IType loadSuperClass(IModel2RegionData srd, String scn) {
        srd.setSuperClass(null);
        return WizardUtils.getSuperClass(srd, scn);
    }

    public static List makeList(String s) {
        if (s == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(s);
        return ret;
    }

    public static List makeList(String[] sa) {
        if (WizardUtils.isEmpty(sa)) {
            return Collections.EMPTY_LIST;
        }
        int l = sa.length;
        ArrayList<String> ret = new ArrayList<String>(l);
        int i = 0;
        while (i < l) {
            ret.add(sa[i]);
            ++i;
        }
        return ret;
    }

    public static String names2FQName(String pn, String sn) {
        return WizardUtils.dotAppend(new String[]{pn, sn});
    }

    public static IProject path2Project(IPath p) {
        if (p == null) {
            return null;
        }
        return WizardUtils.path2Project(p, true);
    }

    protected static IProject path2Project(IPath p, boolean junk) {
        if (p.segmentCount() <= 0) {
            return null;
        }
        String s = p.segment(0);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(s);
    }

    public static String prefix2filename(String prefix) {
        return new StringBuffer(prefix).append(DOT).append(SOURCE_SUFFIX).toString();
    }

    public static String primitive2Object(String t) {
        if (WizardUtils.isEmpty(t) || WizardUtils.isQualified(t)) {
            return null;
        }
        if (t.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (t.equals("byte")) {
            return "java.lang.Byte";
        }
        if (t.equals("char")) {
            return "java.lang.Character";
        }
        if (t.equals("double")) {
            return "java.lang.Double";
        }
        if (t.equals("float")) {
            return "java.lang.Float";
        }
        if (t.equals("int")) {
            return "java.lang.Integer";
        }
        if (t.equals("long")) {
            return "java.lang.Long";
        }
        if (t.equals("short")) {
            return "java.lang.Short";
        }
        return null;
    }

    public static String removeLeadingSlash(String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    public static IProject resource2Project(IResource r) {
        if (r == null) {
            return null;
        }
        return WizardUtils.resource2Project(r, true);
    }

    @Deprecated
    protected static IProject resource2Project(IResource r, boolean junk) {
        if (r instanceof IProject) {
            return (IProject)r;
        }
        return WizardUtils.path2Project(r.getFullPath(), true);
    }

    @Deprecated
    protected static IVirtualComponent resource2VirtualComponent(IResource resource, boolean junk) {
        if (resource instanceof IVirtualComponent) {
            return (IVirtualComponent)resource;
        }
        return Model2Util.findComponent((IResource)resource.getProject());
    }

    public static boolean resourcesEqual(IResource one, IResource other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        return one.equals((Object)other);
    }

    public static String segments2FQName(String path, String sn) {
        return WizardUtils.slashAppend(path, sn);
    }

    @Deprecated
    public static IProject selection2Project(ISelection sel) {
        if (sel == null) {
            return null;
        }
        return WizardUtils.selection2Project(sel, true);
    }

    @Deprecated
    protected static IProject selection2Project(ISelection sel, boolean junk) {
        Object o2 = null;
        if (sel instanceof IStructuredSelection) {
            for (Object o2 : (IStructuredSelection)sel) {
                if (o2 instanceof IProject) {
                    IProject p = (IProject)o2;
                    return p;
                }
                if (o2 instanceof IJavaElement) {
                    o2 = ((IJavaElement)o2).getResource();
                }
                if (!(o2 instanceof IResource)) continue;
                IProject p = WizardUtils.resource2Project((IResource)o2, true);
                assert (p != null);
                return p;
            }
        } else {
            o2 = sel;
            if (o2 instanceof IResource) {
                return WizardUtils.resource2Project((IResource)o2, true);
            }
            return null;
        }
        return null;
    }

    public static IVirtualComponent selection2VirtualComponent(ISelection sel) {
        if (sel == null) {
            return null;
        }
        return WizardUtils.selection2VirtualComponent(sel, true);
    }

    protected static IVirtualComponent selection2VirtualComponent(ISelection sel, boolean junk) {
        Object o2 = null;
        if (sel instanceof IStructuredSelection) {
            for (Object o2 : (IStructuredSelection)sel) {
                if (o2 instanceof IVirtualComponent) {
                    IVirtualComponent p = (IVirtualComponent)o2;
                    return p;
                }
                if (o2 instanceof IJavaElement) {
                    o2 = ((IJavaElement)o2).getResource();
                }
                if (!(o2 instanceof IResource)) continue;
                return WizardUtils.resource2VirtualComponent((IResource)o2, true);
            }
        } else {
            o2 = sel;
            if (o2 instanceof IResource) {
                return WizardUtils.resource2VirtualComponent((IResource)o2, true);
            }
            return null;
        }
        return null;
    }

    public static void setComponent(IModel2RegionData srd, IVirtualComponent component) {
        assert (srd != null);
        srd.setComponent(component);
    }

    public static void setFQClassname(IModel2RegionData srd, String classname) {
        String pkg = null;
        String name = null;
        if (!WizardUtils.isEmpty(classname)) {
            int i = classname.lastIndexOf(46);
            if (i == -1) {
                name = classname;
            } else {
                pkg = classname.substring(0, i);
                name = classname.substring(i + 1);
            }
        }
        srd.setClassname(name);
        WizardUtils.setPackage(srd, pkg);
    }

    protected static void setJavaPackageName(IModel2RegionData rd, String newPN) {
        IPackageFragmentRoot ipfr = WizardUtils.getJavaPackageFragmentRoot(rd);
        if (ipfr == null) {
            rd.setJavaPackageFragment(null);
        } else {
            IPackageFragment ipf = ipfr.getPackageFragment(newPN);
            rd.setJavaPackageFragment(ipf);
        }
    }

    public static void setPackage(IModel2RegionData srd, IPackageFragment f) {
        assert (srd != null);
        srd.setJavaPackageFragment(f);
    }

    public static IPackageFragment setPackage(IModel2RegionData srd, String pkgname) {
        assert (srd != null);
        IPackageFragment f = null;
        if (pkgname == null) {
            f = WizardUtils.getDefaultJavaPackageFragment(srd);
        } else {
            IPackageFragmentRoot fr = srd.getJavaPackageFragmentRoot();
            f = fr.getPackageFragment(pkgname);
            if (f == null) {
                f = WizardUtils.getDefaultJavaPackageFragment(srd);
            }
        }
        assert (f != null);
        WizardUtils.setPackage(srd, f);
        return f;
    }

    public static void setPrefix(IModel2RegionData srd, String p) {
        srd.setPrefix(p);
    }

    public static boolean sizesEqual(Collection one, Collection other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        return one.size() == other.size();
    }

    public static String slashAppend(String s0, String s1) {
        return new StringBuffer(s0).append(SLASH_STRING).append(s1).toString();
    }

    public static String slashAppend(String[] strings) {
        StringBuffer sb = new StringBuffer(strings[0]);
        int len = strings.length;
        if (len > 1) {
            int i = 1;
            while (i < len) {
                sb.append(SLASH_STRING).append(strings[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String slashesToDots(String s) {
        int index = s.indexOf(SLASH_STRING);
        while (index != -1) {
            s = String.valueOf(s.substring(0, index)) + DOT + s.substring(index + 1);
            index = s.indexOf(SLASH_STRING);
        }
        return s;
    }

    public static IContainer string2Container(String ct) {
        return (IContainer)WebtoolsWizardsPlugin.getWorkspace().getRoot().findMember((IPath)new Path(ct));
    }

    public static boolean stringListsEqual(Collection one, Collection other) {
        if (!WizardUtils.sizesEqual(one, other)) {
            return false;
        }
        if (WizardUtils.isEmpty(one)) {
            return true;
        }
        Iterator itOne = one.iterator();
        Iterator itOther = other.iterator();
        while (itOne.hasNext() && itOther.hasNext()) {
            String otherS;
            String oneS = (String)itOne.next();
            if (Model2Util.isEqualOrBothNull(oneS, otherS = (String)itOther.next())) continue;
            return false;
        }
        return true;
    }

    public static void trace(Object source, String message) {
        Model2BasePlugin.getLogger().trace(WizardUtils.getCategory(), message);
    }

    public static void trace(String message) {
        Model2BasePlugin.getLogger().trace(WizardUtils.getCategory(), message);
    }

    public static void traceException(Throwable t) {
        Model2BasePlugin.getLogger().trace(WizardUtils.getCategory(), t);
    }

    public static void traceException(Throwable t, String message) {
        Model2BasePlugin.getLogger().trace(WizardUtils.getCategory(), message, t);
    }

    public static String ucfc(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static List unchar(String separator, String s) {
        String[] list = s.split(separator);
        return Arrays.asList(list);
    }

    public static List undot(String s) {
        return WizardUtils.unchar("\\.", s);
    }

    public static List unslash(String s) {
        return WizardUtils.unchar(SLASH_STRING, s);
    }

    public static String whyIsJavaClassNameInvalid(IModel2RegionData rd) {
        return WizardUtils.whyIsJavaClassNameInvalid(rd.getPrefix(), rd);
    }

    public static String whyIsJavaClassNameInvalid(String c, IModel2RegionData rd) {
        ICompilationUnit classFile;
        if (WizardUtils.isEmpty(c)) {
            return ResourceHandler.wizards_common_type_emptyname;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)c);
        if (val.getSeverity() == 4) {
            return val.getMessage();
        }
        IPackageFragment pf = WizardUtils.getJavaPackageFragment(rd);
        if (pf != null && (classFile = pf.getCompilationUnit(String.valueOf(c) + DOT + SOURCE_SUFFIX)).exists()) {
            return NLS.bind((String)ResourceHandler.wizard_common_file_exists, (Object)classFile.getElementName());
        }
        return null;
    }

    public static String wrapper2Object(String t) {
        if (WizardUtils.isEmpty(t) || WizardUtils.isQualified(t)) {
            return null;
        }
        if (t.equals("Boolean")) {
            return "java.lang.Boolean";
        }
        if (t.equals("Byte")) {
            return "java.lang.Byte";
        }
        if (t.equals("Character")) {
            return "java.lang.Character";
        }
        if (t.equals("Double")) {
            return "java.lang.Double";
        }
        if (t.equals("Float")) {
            return "java.lang.Float";
        }
        if (t.equals("Integer")) {
            return "java.lang.Integer";
        }
        if (t.equals("Long")) {
            return "java.lang.Long";
        }
        if (t.equals("Short")) {
            return "java.lang.Short";
        }
        return null;
    }

    public static String wrapType(String s) {
        if (WizardUtils.isEmpty(s)) {
            return "";
        }
        return new StringBuffer("<TYPE>").append(s).append("</TYPE>").toString();
    }

    public boolean doExtends() {
        return !WizardUtils.isEmpty(this.getExtendsString());
    }

    public boolean doImplements() {
        return !WizardUtils.isEmpty(this.getImplementsString());
    }

    public JMethod[] getConstructors(boolean cfs, boolean dc, JMethod[] ctors) {
        assert (ctors != null);
        JMethod[] ret = new JMethod[]{};
        int len = ctors.length;
        if (len < 1) {
            if (cfs || dc) {
                JMethod defctor = this.typeWizardUtil.createJConstructor("public", new String[0], new String[0], new String[0]);
                ret = new JMethod[]{defctor};
            } else {
                ret = ctors;
            }
        } else if (cfs && dc) {
            ret = ctors;
        } else if (cfs && !dc) {
            assert (false);
        } else if (!cfs && dc) {
            int i = 0;
            while (i < len) {
                JMethod jm = ctors[i];
                JParameter[] jps = jm.getParams();
                assert (jps != null);
                if (jps.length == 0) {
                    ret = new JMethod[]{jm};
                }
                ++i;
            }
            assert (ret.length == 1);
        }
        return ret;
    }

    public String getDummy(String typename) {
        return typename.substring(0, 1).toLowerCase();
    }

    public String getGetter(String varname) {
        return "get" + varname.substring(0, 1).toUpperCase() + varname.substring(1);
    }

    public String getSetter(String varname) {
        return "set" + varname.substring(0, 1).toUpperCase() + varname.substring(1);
    }

    protected IType name2Type(String fqn) {
        return this.typeWizardUtil.getType(fqn);
    }

    protected IType names2Type(String pn, String sn) {
        return this.typeWizardUtil.getType(WizardUtils.names2FQName(pn, sn));
    }

    public String returnAndAddImport(IType t) {
        return this.returnAndAddImport(t, null);
    }

    public String returnAndAddImport(IType t, String s) {
        if (t == null) {
            s = WizardUtils.isEmpty(s) ? SPACE : " '" + s + "' ";
            Model2BasePlugin.getLogger().log(".returnAndAddImport: ERROR: type" + s + "not resolved");
            return s;
        }
        this.typeWizardUtil.addToImportsList(t);
        return this.typeWizardUtil.getTypeNameToUse(t);
    }

    public String returnAndAddImport(JMethod jm, String pn, String sn) {
        return WizardUtils.wrapType(new StringBuffer(pn).append(DOT).append(sn).toString());
    }

    public String returnAndAddImport(String fqn) {
        return WizardUtils.wrapType(fqn);
    }

    public String returnAndAddImport(String pn, String sn) {
        IType t = this.names2Type(pn, sn);
        String fqn = WizardUtils.names2FQName(pn, sn);
        return this.returnAndAddImport(t, fqn);
    }

    public void setDefaultCodeGenModel(IModel2RegionData m2rd, WebRegionCodeGenModel cgm) {
        assert (m2rd != null);
        assert (cgm != null);
        int oldIndex = m2rd.getDefaultCodeGenModelIndex();
        int newIndex = WizardUtils.getCodeGenModelIndex(m2rd, cgm);
        if (newIndex > -1 && newIndex != oldIndex) {
            m2rd.setDefaultModelIndex(newIndex);
        }
    }

    public String writeAccessors(List al) {
        StringBuffer ret = new StringBuffer();
        if (al.size() > 0) {
            String name = null;
            String type = null;
            String dummy = null;
            String getter = null;
            String setter = null;
            for (Accessor a : al) {
                assert (a != null);
                name = a.getName();
                assert (name != null && name.length() > 0);
                dummy = this.getDummy(name);
                type = a.getType();
                assert (type != null && type.length() > 0);
                this.returnAndAddImport(type);
                getter = this.getGetter(name);
                setter = this.getSetter(name);
                ret.append("/**\n");
                ret.append(" * Get ").append(name).append("\n");
                ret.append(" * @return ").append(type).append("\n");
                ret.append(" */\n");
                ret.append("public ").append(type).append(SPACE).append(getter).append("() {\n");
                ret.append("\treturn ").append(name).append(";\n");
                ret.append("}\n");
                ret.append("\n");
                ret.append("/**\n");
                ret.append(" * Set ").append(name).append("\n");
                ret.append(" * @param <code>").append(type).append("</code>\n");
                ret.append(" */\n");
                ret.append("public void ").append(setter).append("(").append(type).append(SPACE).append(dummy).append(") {\n");
                ret.append("\tthis.").append(name).append(" = ").append(dummy).append(";\n");
                ret.append("}\n");
                ret.append("\n");
            }
        }
        return ret.toString();
    }

    public String writeFields(List al) {
        StringBuffer ret = new StringBuffer();
        if (al.size() > 0) {
            String name = null;
            String type = null;
            for (Accessor a : al) {
                assert (a != null);
                name = a.getName();
                assert (name != null && name.length() > 0);
                type = a.getType();
                assert (type != null && type.length() > 0);
                ret.append("private ").append(type).append(SPACE).append(name);
                if (WizardUtils.isPrimitive(type)) {
                    ret.append(";\n");
                    continue;
                }
                ret.append(" = null;\n");
            }
        }
        return ret.toString();
    }
}

