/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.model2.base.util.EnablementGroup;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class WidgetUtils {
    public static final int DEFAULT_CHECKBOX_STYLE = 16384;
    public static final int DEFAULT_CHECKBOX_GRIDDATA_STYLE = 256;
    public static final int DEFAULT_COMBO_STYLE = 12;
    public static final int DEFAULT_COMBO_GRIDDATA_STYLE = 256;
    public static final int DEFAULT_COMPOSITE_STYLE = 0;
    public static final int DEFAULT_COMPOSITE_GRIDDATA_STYLE = 784;
    public static final int DEFAULT_GROUP_STYLE = 0;
    public static final int DEFAULT_GROUP_GRIDDATA_STYLE = 784;
    public static final int DEFAULT_LABEL_STYLE = 16384;
    public static final int DEFAULT_LABEL_GRIDDATA_STYLE = 256;
    public static final int DEFAULT_LISTYLE = 2052;
    public static final int DEFAULT_LIST_GRIDDATA_STYLE = 256;
    public static final int DEFAULT_BUTTON_STYLE = 0x1000000;
    public static final int DEFAULT_BUTTON_GRIDDATA_STYLE = 36;
    public static final int DEFAULT_TEXT_STYLE = 2048;
    public static final int DEFAULT_TEXT_GRIDDATA_STYLE = 768;
    public static final int DEFAULT_MULTITEXT_STYLE = 2816;
    public static final int DEFAULT_MULTITEXT_GRIDDATA_STYLE = 1808;

    protected WidgetUtils() {
    }

    public static Button createCheckBox(Composite parent, int hspan, String label) {
        return WidgetUtils.createCheckBox(parent, hspan, label, 16384, 256);
    }

    public static Button createCheckBox(Composite parent, int hspan, String label, int style, int gridDataStyle) {
        Button button = new Button(parent, style | 0x20);
        GridDataFactory.defaultsFor((Control)button).align(1, 1).grab(false, false).span(hspan, 1).applyTo((Control)button);
        button.setText(label);
        return button;
    }

    public static Button createCheckBox(Composite parent, String label) {
        return WidgetUtils.createCheckBox(parent, label, 16384);
    }

    public static Button createCheckBox(Composite parent, String label, int style) {
        return WidgetUtils.createCheckBox(parent, label, style, 256);
    }

    public static Button createCheckBox(Composite parent, String label, int style, int gridDataStyle) {
        return WidgetUtils.createCheckBox(parent, 1, label, style, gridDataStyle);
    }

    public static Combo createCombo(Composite parent) {
        return WidgetUtils.createCombo(parent, 12);
    }

    public static Combo createCombo(Composite parent, int style) {
        return WidgetUtils.createCombo(parent, style, 256);
    }

    public static Combo createCombo(Composite parent, int style, int gridDataStyle) {
        Combo combo = new Combo(parent, style);
        combo.setLayoutData((Object)new GridData(gridDataStyle));
        return combo;
    }

    public static Combo createCombo(Composite parent, String label) {
        return WidgetUtils.createCombo(parent, label, 12);
    }

    public static Combo createCombo(Composite parent, String label, int style) {
        return WidgetUtils.createCombo(parent, label, style, 256);
    }

    public static Combo createCombo(Composite parent, String label, int style, int gridDataStyle) {
        Composite composite = WidgetUtils.createComposite(parent, 2);
        WidgetUtils.createLabel(composite, label);
        return WidgetUtils.createCombo(composite, style, gridDataStyle);
    }

    public static Composite createComposite(Composite parent) {
        return WidgetUtils.createComposite(parent, 1);
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        return WidgetUtils.createComposite(parent, numColumns, 784);
    }

    public static Composite createComposite(Composite parent, int numColumns, GridData gridData) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns, int gridDataStyle) {
        return WidgetUtils.createComposite(parent, numColumns, new GridData(gridDataStyle));
    }

    public static Group createGroup(Composite parent, int numColumns, String label) {
        return WidgetUtils.createGroup(parent, numColumns, label, 784);
    }

    public static Group createGroup(Composite parent, int numColumns, String label, GridData gridData) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(numColumns, false));
        group.setLayoutData((Object)gridData);
        if (label != null) {
            group.setText(label);
        }
        return group;
    }

    public static Group createGroup(Composite parent, int numColumns, String label, int gridDataStyle) {
        return WidgetUtils.createGroup(parent, numColumns, label, new GridData(gridDataStyle));
    }

    public static Label createLabel(Composite parent, String text) {
        return WidgetUtils.createLabel(parent, text, 16384);
    }

    public static Label createLabel(Composite parent, String text, int style) {
        return WidgetUtils.createLabel(parent, text, style, 256);
    }

    public static Label createLabel(Composite parent, String text, int style, int gridDataStyle) {
        Label label = new Label(parent, style);
        label.setLayoutData((Object)new GridData(gridDataStyle));
        label.setText(text);
        return label;
    }

    public static Table createList(Composite parent) {
        return WidgetUtils.createList(parent, 2052);
    }

    public static Table createList(Composite parent, int style) {
        return WidgetUtils.createList(parent, style, 256);
    }

    public static Table createList(Composite parent, int style, int gridDataStyle) {
        Table table = new Table(parent, style);
        GridData data = new GridData(gridDataStyle);
        data.heightHint = table.getItemHeight() * 3;
        table.setLayoutData((Object)data);
        return table;
    }

    public static Text createMultiText(Composite parent) {
        Text text = new Text(parent, 2818);
        text.setLayoutData((Object)new GridData(1808));
        return text;
    }

    public static Text createMultiText(Composite parent, String label) {
        Composite composite = WidgetUtils.createComposite(parent, 1, 1808);
        WidgetUtils.createLabel(composite, label);
        return WidgetUtils.createMultiText(composite);
    }

    public static Button createPushButton(Composite parent) {
        Button button = new Button(parent, 0x1000008);
        GridDataFactory.defaultsFor((Control)button).align(1, 0x1000000).grab(false, false).applyTo((Control)button);
        return button;
    }

    public static Button createPushButton(Composite parent, Image image) {
        Button button = WidgetUtils.createPushButton(parent);
        button.setImage(image);
        return button;
    }

    public static Button createPushButton(Composite parent, String label) {
        Button button = WidgetUtils.createPushButton(parent);
        button.setText(label);
        GridDataFactory.defaultsFor((Control)button).align(1, 0x1000000).grab(false, false).applyTo((Control)button);
        return button;
    }

    public static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        return button;
    }

    public static final Label createSeparator(Composite c, int horizontalSpan) {
        Label label = new Label(c, 258);
        GridData data = new GridData(784);
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Composite createSkinnyComposite(Composite parent) {
        return WidgetUtils.createSkinnyComposite(parent, 1);
    }

    public static Composite createSkinnyComposite(Composite parent, int numColumns) {
        return WidgetUtils.createSkinnyComposite(parent, numColumns, 784);
    }

    public static Composite createSkinnyComposite(Composite parent, int numColumns, GridData gridData) {
        Composite composite = WidgetUtils.createComposite(parent, numColumns, gridData);
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        return composite;
    }

    public static Composite createSkinnyComposite(Composite parent, int numColumns, int gridDataStyle) {
        return WidgetUtils.createSkinnyComposite(parent, numColumns, new GridData(gridDataStyle));
    }

    public static Text createText(Composite parent) {
        return WidgetUtils.createText(parent, 2048);
    }

    public static Text createText(Composite parent, int style) {
        return WidgetUtils.createText(parent, style, 768);
    }

    public static Text createText(Composite parent, int style, int gridDataStyle) {
        Text text = new Text(parent, 4 | style);
        text.setLayoutData((Object)new GridData(gridDataStyle));
        return text;
    }

    public static Text createText(Composite parent, String label) {
        Composite composite = WidgetUtils.createComposite(parent, 2, 768);
        WidgetUtils.createLabel(composite, label);
        return WidgetUtils.createText(composite);
    }

    public static void select(Combo combo, String string, String altString) {
        int i;
        if (string == null) {
            string = "";
        }
        if ((i = combo.indexOf(string)) == -1) {
            if (altString != null) {
                combo.setText(altString);
            }
        } else {
            combo.select(i);
        }
    }

    public static final void setAccessibility(Control control, String name) {
        WidgetUtils.setAccessibility(control, name, null, null, null);
    }

    public static final void setAccessibility(Control control, String name, String description) {
        WidgetUtils.setAccessibility(control, name, description, null, null);
    }

    public static final void setAccessibility(Control control, String name, String description, String help) {
        WidgetUtils.setAccessibility(control, name, description, help, null);
    }

    public static final void setAccessibility(Control control, String name, String description, String help, String keyboardShortcut) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new StrutsAccessibleListener(control, name, description, help, keyboardShortcut));
    }

    public static final void setEnabled(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite && !(control instanceof EnablementGroup)) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                WidgetUtils.setEnabled(children[i], enable);
                ++i;
            }
        }
    }

    public static final void setToolTipText(Control control, String string) {
        control.setToolTipText(string);
    }

    private static final class StrutsAccessibleListener
    implements AccessibleListener {
        private final Control control;
        private final String name;
        private final String description;
        private final String help;
        private final String keyboardShortcut;

        public StrutsAccessibleListener(Control control, String name, String description, String help, String keyboardShortcut) {
            this.control = control;
            this.name = name;
            this.description = description;
            this.help = help;
            this.keyboardShortcut = keyboardShortcut;
        }

        public void getDescription(AccessibleEvent e) {
            this.setResult(e, this.description);
        }

        public void getHelp(AccessibleEvent e) {
            this.setResult(e, this.help);
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
            this.setResult(e, this.keyboardShortcut);
        }

        public void getName(AccessibleEvent e) {
            this.setResult(e, this.name);
        }

        private void setResult(AccessibleEvent e, String string) {
            if (string != null && (this.control instanceof Combo || e.childID == -1)) {
                e.result = string;
            }
        }
    }
}

