/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class TableResizeAdapter
extends ControlAdapter
implements DisposeListener {
    private Table table;
    private ColumnLayoutData[] columnLayoutDatas;
    private boolean usedInWizard;

    public TableResizeAdapter(Table table) {
        this(table, false);
    }

    public TableResizeAdapter(Table table, boolean usedInWizard) {
        this(table, null, usedInWizard);
    }

    public TableResizeAdapter(Table table, ColumnLayoutData[] columnLayoutDatas, boolean usedInWizard) {
        if (table.getParent().getChildren().length != 1) {
            throw new IllegalArgumentException("table has siblings");
        }
        this.table = table;
        this.columnLayoutDatas = columnLayoutDatas;
        this.normalizeColumnLayoutDatas();
        this.usedInWizard = usedInWizard;
        table.getParent().addControlListener((ControlListener)this);
        table.getParent().addDisposeListener((DisposeListener)this);
    }

    public void controlResized(ControlEvent e) {
        if (e.getSource() == this.table.getParent()) {
            if (!this.usedInWizard) {
                this.tableResized();
            }
            if (this.usedInWizard) {
                this.usedInWizard = false;
            }
        }
    }

    private void normalizeColumnLayoutDatas() {
        int columnCount = this.table.getColumnCount();
        if (this.columnLayoutDatas == null) {
            this.columnLayoutDatas = new ColumnLayoutData[columnCount];
            int i = 0;
            while (i < columnCount) {
                this.columnLayoutDatas[i] = new ColumnWeightData(1, true);
                ++i;
            }
            return;
        }
        if (this.columnLayoutDatas.length < columnCount) {
            throw new IllegalArgumentException("too few column layout datas");
        }
        if (this.columnLayoutDatas.length > columnCount) {
            ColumnLayoutData[] old = this.columnLayoutDatas;
            this.columnLayoutDatas = new ColumnLayoutData[columnCount];
            System.arraycopy(old, 0, this.columnLayoutDatas, 0, columnCount);
        }
    }

    private void setTableLayout() {
        TableLayout layout = new TableLayout();
        int columnCount = this.table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            layout.addColumnData(this.columnLayoutDatas[i]);
            ++i;
        }
        this.table.setLayout((Layout)layout);
    }

    private void setTableSize() {
        Rectangle area = this.table.getParent().getClientArea();
        Layout l = this.table.getParent().getLayout();
        if (l instanceof GridLayout) {
            GridLayout layout = (GridLayout)l;
            area.width = Math.max(area.width - layout.marginWidth * 2, 0);
        }
        this.table.setSize(area.width, area.height);
    }

    private void tableResized() {
        this.setTableLayout();
        this.setTableSize();
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.getSource() instanceof Composite) {
            ((Composite)e.getSource()).removeControlListener((ControlListener)this);
            ((Composite)e.getSource()).removeDisposeListener((DisposeListener)this);
        }
    }
}

