/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.model2.base.Model2BasePlugin;
import com.ibm.etools.model2.base.nls.ResourceHandler;
import com.ibm.etools.model2.base.util.WizardUtils;
import com.ibm.etools.model2.base.wizards.IModel2RegionData;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;

public class Model2Util {
    public static IWorkbenchWindow activeWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static List cds2List(String cdl) {
        StringTokenizer tokenizer = new StringTokenizer(cdl, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    public static IFile fileFor(IProject project, String fileName) {
        return Model2Util.fileFor(Model2Util.findComponent((IResource)project), fileName);
    }

    public static IFile fileFor(IVirtualComponent webComponent, String fileName) {
        IPath path = Model2Util.getProjectRelativeDocRootPath(webComponent);
        if (path != null) {
            path = path.append(fileName);
            return webComponent.getProject().getFile(path);
        }
        return null;
    }

    @Deprecated
    public static IVirtualComponent findComponent(IResource resource) {
        return WebUtil.findComponent((IResource)resource);
    }

    public static IFolder folderFor(IVirtualComponent component, String pathName) {
        IPath path = Model2Util.getProjectRelativeDocRootPath(component);
        if (path != null) {
            path = path.append(pathName);
            return component.getProject().getFolder(path);
        }
        return null;
    }

    public static Set getAllFacetIds(IVirtualComponent component) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
            if (facetedProject != null) {
                HashSet<String> ids = new HashSet<String>();
                Set facetVersions = facetedProject.getProjectFacets();
                for (IProjectFacetVersion facetVersion : facetVersions) {
                    ids.add(facetVersion.getProjectFacet().getId());
                }
                return ids;
            }
        }
        catch (CoreException coreException) {}
        return Collections.EMPTY_SET;
    }

    public static ArrayList getAllServletMapping(IVirtualComponent webModule) throws Exception {
        ArrayList<String> patterns = new ArrayList<String>(0);
        WebArtifactEdit artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)webModule);
        try {
            WebApp webApp = artifactEdit.getWebApp();
            for (Servlet servlet : webApp.getServlets()) {
                List mappings = servlet.getMappings();
                for (ServletMapping sm : mappings) {
                    if (sm == null) continue;
                    String urlp = sm.getUrlPattern();
                    if (WizardUtils.isEmpty(urlp)) {
                        Model2BasePlugin.getLogger().log("has empty url-pattern");
                        continue;
                    }
                    patterns.add(urlp);
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return patterns;
    }

    public static IContainer getContainer(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (path.segmentCount()) {
            case 0: {
                return root;
            }
            case 1: {
                return root.getProject(path.segment(0));
            }
        }
        return root.getFolder(path);
    }

    public static String getDefaultXMLEncoding() {
        ResourcesPlugin resourcePlugin = ResourcesPlugin.getPlugin();
        String enc = resourcePlugin.getPluginPreferences().getString("encoding");
        return enc;
    }

    public static IPath getDocRootRelativePath(IFile file) {
        IPath filePath;
        IPath modulePath;
        IVirtualComponent component;
        if (file != null && (component = Model2Util.findComponent((IResource)file)) != null && (modulePath = Model2Util.getWorkspaceRelativeDocRootPath(component)).isPrefixOf(filePath = file.getFullPath())) {
            return filePath.removeFirstSegments(modulePath.segmentCount()).makeAbsolute();
        }
        return null;
    }

    @Deprecated
    public static IContainer getDocumentRootContainer(IVirtualComponent component) {
        return WebUtil.getDocumentRootContainer((IVirtualComponent)component);
    }

    public static String getEditorId(IFile file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public static IFile getFile(IContainer container, String path) {
        switch (container.getType()) {
            case 8: {
                return ((IWorkspaceRoot)container).getFile((IPath)new Path(path));
            }
            case 4: {
                return ((IProject)container).getFile(path);
            }
            case 2: {
                return ((IFolder)container).getFile(path);
            }
        }
        return null;
    }

    public static IFile getFile(IVirtualComponent component, String path) {
        IContainer container = Model2Util.getDocumentRootContainer(component);
        if (container != null) {
            return Model2Util.getFile(container, path);
        }
        return null;
    }

    public static IFolder getFolder(IContainer container, String path) {
        switch (container.getType()) {
            case 8: {
                return ((IWorkspaceRoot)container).getFolder((IPath)new Path(path));
            }
            case 4: {
                return ((IProject)container).getFolder(path);
            }
            case 2: {
                return ((IFolder)container).getFolder(path);
            }
        }
        return null;
    }

    public static String getInitParam(Servlet servlet, String name) {
        if (servlet == null || name == null) {
            return null;
        }
        HashMap map = Model2Util.getServletInitParams(servlet);
        return (String)map.get(name);
    }

    public static ICompilationUnit getJavaElementFromClassName(IProject project, String className) {
        if (project == null || className == null) {
            return null;
        }
        String classPath = Model2Util.replace(className, ".", "/");
        classPath = String.valueOf(classPath) + ".java";
        IFolder folder = Model2Util.getSourceFolder(project);
        IFile file = folder.getFile(classPath);
        return (ICompilationUnit)JavaCore.create((IFile)file);
    }

    public static IJavaProject getJavaProject(IProject p) {
        return JavaCore.create((IProject)p);
    }

    public static String getPreferredXMLEncoding() {
        Preferences preferences = XMLCorePlugin.getDefault().getPluginPreferences();
        String encoding = preferences.getString("outputCodeset");
        return encoding.length() > 0 ? encoding : Model2Util.getDefaultXMLEncoding();
    }

    public static IProject getProject(IModel2RegionData srd) {
        return srd.getProject();
    }

    @Deprecated
    public static IPath getProjectRelativeDocRootPath(IVirtualComponent component) {
        return WebUtil.getProjectRelativeDocRootPath((IVirtualComponent)component);
    }

    public static HashMap getServletInitParams(Servlet servlet) {
        HashMap<String, String> result;
        block10: {
            block9: {
                result = new HashMap<String, String>();
                WebApp webApp = servlet.getWebApp();
                if (webApp == null) break block9;
                int j2eeVersion = servlet.getWebApp().getJ2EEVersionID();
                switch (j2eeVersion) {
                    case 12: 
                    case 13: {
                        EList initParams = servlet.getParams();
                        for (InitParam initParam : initParams) {
                            result.put(initParam.getParamName(), initParam.getParamValue());
                        }
                        break block10;
                    }
                    default: {
                        EList initParams = servlet.getInitParams();
                        for (ParamValue initParam : initParams) {
                            result.put(initParam.getName(), initParam.getValue());
                        }
                        break block10;
                    }
                }
            }
            EList initParams = servlet.getParams();
            if (initParams != null && initParams.size() > 0) {
                for (InitParam initParam : initParams) {
                    result.put(initParam.getParamName(), initParam.getParamValue());
                }
            } else {
                initParams = servlet.getInitParams();
                for (ParamValue initParam : initParams) {
                    result.put(initParam.getName(), initParam.getValue());
                }
            }
        }
        return result;
    }

    public static IFolder getSourceFolder(IProject project) {
        IPackageFragmentRoot[] sourceContainers = J2EEProjectUtilities.getSourceContainers((IProject)project);
        int i = 0;
        while (i < sourceContainers.length) {
            IResource resource = sourceContainers[i].getResource();
            if (resource != null && resource.getType() == 2) {
                return (IFolder)resource;
            }
            ++i;
        }
        return null;
    }

    public static IFolder getSourceFolder(IVirtualComponent webModule) {
        return Model2Util.getSourceFolder(webModule.getProject());
    }

    public static IType getType(IJavaProject javaProject, String name) {
        try {
            return javaProject.findType(name);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IType getType(IProject project, String name) {
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (name.indexOf(46) == -1) {
                name = "java.lang." + name;
            }
            return Model2Util.getType(javaProject, name);
        }
        return null;
    }

    public static WebArtifactEdit getWebArtifactEdit(IVirtualComponent webModule, boolean isReadOnly) {
        return isReadOnly ? WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)webModule) : WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)webModule);
    }

    public static IPath getWEBINFPath(IVirtualComponent component) {
        return component.getRootFolder().getFolder("WEB-INF").getProjectRelativePath();
    }

    @Deprecated
    public static IPath getWorkspaceRelativeDocRootPath(IVirtualComponent component) {
        return WebUtil.getWorkspaceRelativeDocRootPath((IVirtualComponent)component);
    }

    public static boolean isEqualOrBothNull(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        return one.equals(two);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExtenderOf(IType type, String className) {
        if (type.getFullyQualifiedName().equals(className)) {
            return true;
        }
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] superclasses = hierarchy.getAllSuperclasses(type);
            int i = 0;
            while (true) {
                if (i >= superclasses.length) {
                    return false;
                }
                if (superclasses[i].getFullyQualifiedName().equals(className)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException exception) {
            Model2BasePlugin.getLogger().log(exception);
            return false;
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean isExtenderOf(String className1, IJavaProject project, String className2) {
        IType type = null;
        try {
            type = project.findType(className1);
        }
        catch (JavaModelException exception) {
            Model2BasePlugin.getLogger().log(exception);
            return false;
        }
        if (type == null) {
            return false;
        }
        return Model2Util.isExtenderOf(type, className2);
    }

    public static boolean isHTML(IFile file) {
        if (file == null) {
            return false;
        }
        boolean result = false;
        try {
            IContentType contentTypeHTML = Platform.getContentTypeManager().getContentType(ContentTypeIdForHTML.ContentTypeID_HTML);
            String fileName = file.getName();
            IContentType[] contentTypes = null;
            contentTypes = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < contentTypes.length) {
                IContentType type = contentTypes[i];
                if (type.isKindOf(contentTypeHTML)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isJSP(IFile file) throws IOException {
        if (file == null) {
            return false;
        }
        boolean result = false;
        InputStream stream = null;
        try {
            try {
                IContentType type;
                IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
                String fileName = file.getName();
                IContentType[] contentTypes = null;
                if (file.exists()) {
                    IContentDescription contentDescription = file.getContentDescription();
                    if (contentDescription == null) {
                        stream = file.getContents();
                        contentDescription = Platform.getContentTypeManager().getDescriptionFor(stream, fileName, null);
                    }
                    if (contentDescription != null && (type = contentDescription.getContentType()) != null) {
                        contentTypes = new IContentType[]{type};
                    }
                }
                if (contentTypes == null) {
                    contentTypes = Platform.getContentTypeManager().findContentTypesFor(fileName);
                }
                int i = 0;
                while (i < contentTypes.length) {
                    type = contentTypes[i];
                    if (type.isKindOf(contentTypeJSP)) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (stream != null) {
                    stream.close();
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return result;
    }

    public static boolean isServletMapping(String URI, IVirtualComponent webModule) throws Exception {
        boolean result = false;
        if (URI != null) {
            Iterator i = Model2Util.getAllServletMapping(webModule).iterator();
            while (i.hasNext() && !result) {
                String mapping = (String)i.next();
                mapping = mapping.startsWith("*") ? mapping.substring(1) : mapping.substring(0, mapping.length() - 1);
                if (!URI.startsWith(mapping) && !URI.endsWith(mapping)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean isThisMyServlet(String candidate, IJavaProject project, String servletClassname) {
        boolean ret = false;
        if (Model2Util.isExtenderOf(candidate, project, servletClassname)) {
            ret = true;
        }
        return ret;
    }

    @Deprecated
    public static boolean isValidateEditRequired(IFile file) {
        return file.exists() && file.isReadOnly();
    }

    public static boolean isWebProject(IProject project) {
        return J2EEProjectUtilities.isDynamicWebProject((IProject)project) || J2EEProjectUtilities.isStaticWebProject((IProject)project);
    }

    public static IEditorPart openEditorOn(IFile file) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file);
        }
        catch (PartInitException e) {
            Model2BasePlugin.getLogger().log(e);
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Title", (String)"Opening editor failed");
            return null;
        }
    }

    public static IEditorPart openEditorOn(IMarker marker) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IMarker)marker, (boolean)true);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public static String replace(String string, String find, String replace) {
        if (string == null) {
            return null;
        }
        String normalString = "";
        int length = string.length();
        int position = 0;
        int previous = 0;
        int spacer = find.length();
        while (position + spacer - 1 < length && string.indexOf(find, position) > -1) {
            position = string.indexOf(find, previous);
            normalString = String.valueOf(normalString) + string.substring(previous, position) + replace;
            previous = position += spacer;
        }
        normalString = String.valueOf(normalString) + string.substring(position, string.length());
        return normalString;
    }

    public static boolean typesEqual(IType one, IType other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        String onename = one.getFullyQualifiedName();
        if (other == null) {
            return false;
        }
        return onename.equals(other.getFullyQualifiedName());
    }

    public static IStatus validateEdit(IFile file, Shell shell) {
        if (shell == null) {
            return file.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT);
        }
        return file.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
    }

    public static boolean validateEditAndWarn(IFile file, Shell shell) {
        IStatus status = Model2Util.validateEdit(file, shell);
        if (status.getSeverity() != 0) {
            MessageDialog dialog = new MessageDialog(shell, ResourceHandler.Message_dialog_warning_title, null, status.getMessage(), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return false;
        }
        return true;
    }

    public static boolean validateEditAndWarn(IVirtualComponent component, String fileName, Shell shell) {
        assert (component != null);
        assert (fileName != null && fileName.length() > 0);
        assert (shell != null);
        return Model2Util.validateEditAndWarn(Model2Util.fileFor(component, fileName), shell);
    }

    public static IStatus validatePackageName(String packageName) {
        return packageName.length() > 0 ? JavaConventions.validatePackageName((String)packageName) : Status.OK_STATUS;
    }

    public static IStatus validateSuperclassType(IType t, String fqcn) {
        if (!Model2Util.isExtenderOf(t, fqcn)) {
            return new Status(4, Model2BasePlugin.getPluginId(), 4, NLS.bind((String)ResourceHandler.wizard_common_superclass_mustExtend, (Object)fqcn), null);
        }
        return Status.OK_STATUS;
    }
}

