/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.model2.base.util.EnablementGroupListener;
import com.ibm.etools.model2.base.util.WidgetUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EnablementGroup
extends Composite {
    private Button checkbox;
    private Group group;
    private Set listeners = new HashSet();

    public EnablementGroup(Composite parent, int style, String checkboxLabel, String groupLabel) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        this.checkbox = WidgetUtils.createCheckBox(this, checkboxLabel);
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() == EnablementGroup.this.checkbox) {
                    EnablementGroup.this.selectionChanged();
                }
            }
        });
        this.group = WidgetUtils.createGroup(this, 1, groupLabel);
    }

    public void addEnablementListener(EnablementGroupListener listener) {
        this.listeners.add(listener);
    }

    public Button getCheckbox() {
        return this.checkbox;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean getSelection() {
        return this.checkbox.getSelection();
    }

    private void notifyEnablementListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((EnablementGroupListener)iterator.next()).handleEnablement(this);
        }
    }

    public void removeEnablementListener(EnablementGroupListener listener) {
        this.listeners.remove(listener);
    }

    private void selectionChanged() {
        WidgetUtils.setEnabled((Control)this.group, this.checkbox.getSelection());
        this.notifyEnablementListeners();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkbox.setEnabled(enabled);
        WidgetUtils.setEnabled((Control)this.group, enabled && this.getSelection());
        this.notifyEnablementListeners();
    }

    public void setSelection(boolean selection) {
        this.checkbox.setSelection(selection);
        this.selectionChanged();
    }
}

