/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class DataModelDumper {
    private final PrintStream stream;

    public DataModelDumper(PrintStream stream) {
        this.stream = stream;
    }

    public static void dump(IDataModel model, PrintStream stream) {
        new DataModelDumper(stream).dump(model);
    }

    private void dump(Collection collection, int level, Set dumped) {
        this.stream.print(collection.getClass().getName());
        this.stream.print('(');
        this.stream.print(collection.size());
        this.stream.println("):");
        Iterator iterator = this.sorterator(collection);
        while (iterator.hasNext()) {
            this.indent(level + 1);
            this.dump(iterator.next(), level + 1, dumped);
        }
    }

    public void dump(IDataModel model) {
        this.dump(model, 0, (Set)new HashSet());
    }

    private void dump(IDataModel model, int level, Set dumped) {
        this.stream.print(model.getClass().getName());
        this.stream.print('@');
        this.stream.print(model.hashCode());
        this.stream.print('(');
        this.stream.print(model.getID());
        this.stream.print(')');
        if (!dumped.add(model)) {
            this.stream.println(": dumped elsewhere");
        } else {
            this.stream.println();
            this.dumpProperties(model, level + 1, dumped);
            this.dumpNestedModels(model, level + 1, dumped);
            this.dumpNestingModels(model, level + 1, dumped);
        }
    }

    private void dump(Map map, int level, Set dumped) {
        this.stream.print(map.getClass().getName());
        this.stream.print('(');
        this.stream.print(map.size());
        this.stream.println("):");
        Iterator iterator = this.sorterator(map.keySet());
        while (iterator.hasNext()) {
            Object key = iterator.next();
            this.indent(level);
            this.dump(key, level + 1, dumped);
            this.stream.print(" --> ");
            this.dump(map.get(key), level + 1, dumped);
        }
    }

    private void dump(Object object, int level, Set dumped) {
        if (object == null) {
            this.stream.println((Object)null);
            return;
        }
        if (object instanceof IDataModel) {
            this.dump((IDataModel)object, level, dumped);
            return;
        }
        if (object instanceof Collection) {
            this.dump((Collection)object, level, dumped);
            return;
        }
        if (object instanceof Map) {
            this.dump((Map)object, level, dumped);
        }
        if (object.getClass().isArray()) {
            this.dump((Object[])object, level, dumped);
            return;
        }
        this.stream.println(object);
    }

    private void dump(Object[] array, int level, Set dumped) {
        this.stream.print(array.getClass().getName());
        this.stream.print('(');
        this.stream.print(array.length);
        this.stream.println("):");
        Iterator iterator = this.sorterator(array);
        while (iterator.hasNext()) {
            this.indent(level);
            this.dump(iterator.next(), level + 1, dumped);
        }
    }

    private void dumpNestedModel(String name, IDataModel model, int level, Set dumped) {
        this.indent(level);
        this.stream.print(name);
        this.stream.print(": ");
        try {
            IDataModel nestedModel = model.getNestedModel(name);
            this.dump(nestedModel, level, dumped);
        }
        catch (Exception exception) {
            this.dump(exception, level, dumped);
        }
    }

    private void dumpNestedModels(IDataModel model, int level, Set dumped) {
        this.indent(level);
        this.stream.println("nested models:");
        Iterator iterator = this.sorterator(model.getNestedModelNames());
        while (iterator.hasNext()) {
            this.dumpNestedModel((String)iterator.next(), model, level + 1, dumped);
        }
    }

    private void dumpNestingModel(IDataModel model, int level, Set dumped) {
        this.indent(level);
        this.dump(model, level, dumped);
    }

    private void dumpNestingModels(IDataModel model, int level, Set dumped) {
        this.indent(level);
        this.stream.println("nesting models:");
        Iterator iterator = model.getNestingModels().iterator();
        while (iterator.hasNext()) {
            this.dumpNestingModel((IDataModel)iterator.next(), level + 1, dumped);
        }
    }

    private void dumpProperties(IDataModel model, int level, Set dumped) {
        this.indent(level);
        this.stream.println("properties:");
        Iterator iterator = this.sorterator(model.getBaseProperties());
        while (iterator.hasNext()) {
            this.dumpProperty((String)iterator.next(), model, level + 1, dumped);
        }
    }

    private void dumpProperty(String name, IDataModel model, int level, Set dumped) {
        this.indent(level);
        this.stream.print(name);
        this.stream.print(": ");
        Object value = null;
        try {
            value = model.getProperty(name);
        }
        catch (Exception exception) {
            value = exception;
        }
        this.dump(value, level, dumped);
    }

    private void indent(int level) {
        int i = 0;
        while (i < level) {
            this.stream.print(' ');
            ++i;
        }
    }

    private Iterator sorterator(Collection collection) {
        ArrayList list = new ArrayList(collection);
        try {
            Collections.sort(list);
            return list.iterator();
        }
        catch (RuntimeException runtimeException) {
            return collection.iterator();
        }
    }

    private Iterator sorterator(Object[] array) {
        return this.sorterator(Arrays.asList(array));
    }
}

