/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.marshall.util.bidi.BidiFlag;
import com.ibm.etools.marshall.util.bidi.BidiFlagSet;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.PlatformCompilerInfo;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;
import com.ibm.etools.typedescriptor.UnicodeExternalDecimalTD;
import org.eclipse.emf.common.util.EList;

public class MarshallParms {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static int getSize(SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        if (!instanceTD.isSetSize()) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_SIZE_NOT_SET"));
        }
        String strSize = instanceTD.getSize();
        int size = ConversionUtils.evaluateFormula((String)strSize);
        if (instanceTD.isSetAttributeInBit() && instanceTD.getAttributeInBit().booleanValue()) {
            size /= 8;
        }
        return size;
    }

    public static int getOffset(SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        if (!instanceTD.isSetOffset()) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_OFFSET_NOT_SET"));
        }
        String strOffset = instanceTD.getOffset();
        int offset = ConversionUtils.evaluateFormula((String)strOffset);
        if (instanceTD.isSetAttributeInBit() && instanceTD.getAttributeInBit().booleanValue()) {
            offset /= 8;
        }
        return offset;
    }

    public static int getStride(InstanceTDBase tdBase) throws IllegalArgumentException {
        EList arrayList = tdBase.getArrayDescr();
        if (arrayList == null || arrayList.isEmpty()) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STRIDE_NOT_SET"));
        }
        ArrayTD arrayTD = (ArrayTD)arrayList.get(arrayList.size() - 1);
        if (!arrayTD.isSetStride()) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STRIDE_NOT_SET"));
        }
        String strSize = arrayTD.getStride();
        int stride = ConversionUtils.evaluateFormula((String)strSize);
        if (arrayTD.isSetStrideInBit() && arrayTD.getStrideInBit().booleanValue()) {
            stride /= 8;
        }
        return stride;
    }

    public static String getCodePage(StringTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        String codePage = null;
        if (typeDescriptor.isSetCodepage()) {
            codePage = typeDescriptor.getCodepage();
        } else {
            PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
            if (info.isSetDefaultCodepage()) {
                codePage = info.getDefaultCodepage();
            }
            if (codePage == null) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_CODEPAGE_NOT_SET"));
            }
        }
        if (codePage.equalsIgnoreCase("UTF-16") && "COBOL".equalsIgnoreCase(MarshallParms.getLanguage(instanceTD))) {
            codePage = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD) ? "UTF-16BE" : "UTF-16LE";
        }
        return codePage;
    }

    public static PlatformCompilerInfo getPlatformInfo(SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        PlatformCompilerInfo info = null;
        if (instanceTD.getPlatformInfo() != null) {
            info = instanceTD.getPlatformInfo();
        }
        if (info == null) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_PLATFORM_INFO_NOT_SET"));
        }
        return info;
    }

    public static int getEncodingStyle(StringTD typeDescriptor) {
        int encodingStyle = 0;
        if (typeDescriptor.isSetLengthEncoding()) {
            encodingStyle = typeDescriptor.getLengthEncoding().getValue();
        }
        return encodingStyle;
    }

    public static int getCharacterSize(StringTD typeDescriptor) {
        int charSize = 1;
        if (typeDescriptor.isSetCharacterSize()) {
            charSize = typeDescriptor.getCharacterSize();
        }
        return charSize;
    }

    public static String getPaddingCharacter(StringTD typeDescriptor) {
        String padCharStr = null;
        if (typeDescriptor.isSetPaddingCharacter()) {
            padCharStr = typeDescriptor.getPaddingCharacter();
        }
        return padCharStr;
    }

    public static String getFormatString(SimpleInstanceTD instanceTD) {
        String format = null;
        if (instanceTD.isSetFormat()) {
            format = instanceTD.getFormat();
        }
        return format;
    }

    public static int getStringJustification(StringTD typeDescriptor) throws IllegalArgumentException {
        int justification = 0;
        if (typeDescriptor.isSetStringJustification()) {
            justification = typeDescriptor.getStringJustification().getValue();
            switch (justification) {
                case 0: {
                    justification = 0;
                    break;
                }
                case 1: {
                    justification = 1;
                    break;
                }
                case 2: {
                    justification = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(justification)));
                }
            }
        }
        return justification;
    }

    public static String getLanguage(SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        String language = null;
        PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
        if (info.isSetLanguage()) {
            language = info.getLanguage();
        }
        return language;
    }

    public static boolean isBigEndian(BaseTDType typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = false;
        PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
        if (typeDescriptor.isSetBigEndian()) {
            isBigEndian = typeDescriptor.getBigEndian();
        } else if (info.isSetDefaultBigEndian()) {
            isBigEndian = info.getDefaultBigEndian();
        }
        return isBigEndian;
    }

    public static int getPrefixLength(StringTD typeDescriptor) {
        int prefixLength = 4;
        if (typeDescriptor.isSetPrefixLength()) {
            prefixLength = typeDescriptor.getPrefixLength();
        }
        return prefixLength;
    }

    public static Bi_DirectionStringTD getBidiStringTD(StringTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        Bi_DirectionStringTD bidiTD = null;
        PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
        if (typeDescriptor.getBidiAttributes() != null) {
            bidiTD = typeDescriptor.getBidiAttributes();
        } else if (info.getBidiAttributes() != null) {
            bidiTD = info.getBidiAttributes();
        }
        return bidiTD;
    }

    public static boolean getDBCSOnly(StringTD typeDescriptor) {
        boolean DBCSOnly = false;
        if (typeDescriptor.isSetDBCSOnly()) {
            DBCSOnly = typeDescriptor.getDBCSOnly();
        }
        return DBCSOnly;
    }

    public static BidiFlagSet createBidiFlagSet(Bi_DirectionStringTD bidiTD) throws IllegalArgumentException {
        BidiFlagSet flagSet = new BidiFlagSet();
        switch (bidiTD.getTextType().getValue()) {
            case 0: {
                flagSet.setOneFlag(BidiFlag.TYPE_IMPLICIT);
                break;
            }
            case 1: {
                flagSet.setOneFlag(BidiFlag.TYPE_VISUAL);
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(bidiTD.getTextType().getValue()));
            }
        }
        switch (bidiTD.getOrientation().getValue()) {
            case 0: {
                flagSet.setOneFlag(BidiFlag.ORIENTATION_LTR);
                break;
            }
            case 1: {
                flagSet.setOneFlag(BidiFlag.ORIENTATION_RTL);
                break;
            }
            case 2: {
                flagSet.setOneFlag(BidiFlag.ORIENTATION_CONTEXT_LTR);
                break;
            }
            case 3: {
                flagSet.setOneFlag(BidiFlag.ORIENTATION_CONTEXT_RTL);
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(bidiTD.getOrientation().getValue()));
            }
        }
        if (bidiTD.getSymmetric().booleanValue()) {
            flagSet.setOneFlag(BidiFlag.SWAP_YES);
        } else {
            flagSet.setOneFlag(BidiFlag.SWAP_NO);
        }
        switch (bidiTD.getNumeralShapes().getValue()) {
            case 0: {
                flagSet.setOneFlag(BidiFlag.NUMERALS_NOMINAL);
                break;
            }
            case 1: {
                flagSet.setOneFlag(BidiFlag.NUMERALS_NATIONAL);
                break;
            }
            case 2: {
                flagSet.setOneFlag(BidiFlag.NUMERALS_CONTEXTUAL);
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(bidiTD.getNumeralShapes().getValue()));
            }
        }
        switch (bidiTD.getTextShape().getValue()) {
            case 0: {
                flagSet.setOneFlag(BidiFlag.TEXT_NOMINAL);
                break;
            }
            case 1: {
                flagSet.setOneFlag(BidiFlag.TEXT_SHAPED);
                break;
            }
            case 2: {
                flagSet.setOneFlag(BidiFlag.TEXT_INITIAL);
                break;
            }
            case 3: {
                flagSet.setOneFlag(BidiFlag.TEXT_MIDDLE);
                break;
            }
            case 4: {
                flagSet.setOneFlag(BidiFlag.TEXT_FINAL);
                break;
            }
            case 5: {
                flagSet.setOneFlag(BidiFlag.TEXT_ISOLATED);
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(bidiTD.getTextShape().getValue()));
            }
        }
        return flagSet;
    }

    public static int getVirtualDecimalPoint(NumberTD typeDescriptor) throws IllegalArgumentException {
        int decPt = 0;
        if (typeDescriptor.isSetVirtualDecimalPoint()) {
            decPt = typeDescriptor.getVirtualDecimalPoint();
        }
        return decPt;
    }

    public static boolean isSigned(NumberTD typeDescriptor) throws IllegalArgumentException {
        boolean isSigned = true;
        if (typeDescriptor.isSetSigned()) {
            isSigned = typeDescriptor.getSigned();
        }
        return isSigned;
    }

    public static int getSignFormat(ExternalDecimalTD typeDescriptor) throws IllegalArgumentException {
        int signFormat = -1;
        if (typeDescriptor.isSetSignFormat()) {
            int TDSignFormat = typeDescriptor.getSignFormat().getValue();
            signFormat = MarshallParms.getSignFormat(TDSignFormat);
        }
        return signFormat;
    }

    public static int getSignFormat(int TDSignFormat) throws IllegalArgumentException {
        int signFormat = -1;
        switch (TDSignFormat) {
            case 0: {
                signFormat = 0;
                break;
            }
            case 2: {
                signFormat = 1;
                break;
            }
            case 1: {
                signFormat = 2;
                break;
            }
            case 3: {
                signFormat = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_FMT_NOT_VALID", Integer.toString(TDSignFormat)));
            }
        }
        return signFormat;
    }

    public static int getSignFormat(UnicodeExternalDecimalTD typeDescriptor) throws IllegalArgumentException {
        int signFormat = -1;
        if (typeDescriptor.isSetSignFormat()) {
            int TDSignFormat = typeDescriptor.getSignFormat().getValue();
            signFormat = MarshallParms.getSignFormat(TDSignFormat);
        }
        return signFormat;
    }

    public static int getExternalDecimalSign(ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int edSign = 0;
        int TDEdSign = 0;
        if (typeDescriptor.isSetExternalDecimalSign()) {
            TDEdSign = typeDescriptor.getExternalDecimalSign().getValue();
        } else {
            PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
            if (info.isSetDefaultExternalDecimalSign()) {
                TDEdSign = info.getDefaultExternalDecimalSign().getValue();
            } else {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_NOT_SET"));
            }
        }
        switch (TDEdSign) {
            case 0: {
                edSign = 0;
                break;
            }
            case 1: {
                edSign = 1;
                break;
            }
            case 2: {
                edSign = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_NOT_VALID", Integer.toString(TDEdSign)));
            }
        }
        return edSign;
    }

    public static int getFloatType(FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int floatType = 1;
        int TDFloatType = 0;
        if (typeDescriptor.isSetFloatType()) {
            TDFloatType = typeDescriptor.getFloatType().getValue();
        } else {
            PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
            if (info.isSetDefaultFloatType()) {
                TDFloatType = info.getDefaultFloatType().getValue();
            } else {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FLOAT_TYPE_NOT_SET"));
            }
        }
        switch (TDFloatType) {
            case 0: {
                floatType = 0;
                break;
            }
            case 1: {
                floatType = 1;
                break;
            }
            case 2: {
                floatType = 2;
                break;
            }
            case 3: {
                floatType = 3;
                break;
            }
            case 4: {
                floatType = 4;
                break;
            }
            case 5: {
                floatType = 5;
                break;
            }
            case 6: {
                floatType = 6;
                break;
            }
            case 7: {
                floatType = 7;
                break;
            }
            case 8: {
                floatType = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FLOAT_TYPE_NOT_VALID", Integer.toString(TDFloatType)));
            }
        }
        return floatType;
    }

    public static int getSignCoding(IntegerTD typeDescriptor) throws IllegalArgumentException {
        int signCoding = 0;
        int TDSignCoding = 0;
        if (!typeDescriptor.isSetSignCoding()) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIGN_CODING_NOT_SET"));
        }
        TDSignCoding = typeDescriptor.getSignCoding().getValue();
        switch (TDSignCoding) {
            case 0: {
                signCoding = 0;
                break;
            }
            case 1: {
                signCoding = 1;
                break;
            }
            case 2: {
                signCoding = 2;
                break;
            }
            case 3: {
                signCoding = 3;
                break;
            }
            case 4: {
                signCoding = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIGN_CODING_NOT_VALID", Integer.toString(TDSignCoding)));
            }
        }
        return signCoding;
    }

    public static boolean isArray(InstanceTDBase tdBase) {
        boolean isArray = false;
        EList arrayList = tdBase.getArrayDescr();
        if (arrayList != null && !arrayList.isEmpty()) {
            isArray = true;
        }
        return isArray;
    }
}

