/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallPackedDecimalUtils;
import com.ibm.etools.typedescriptor.PackedDecimalTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallPackedDecimal {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static void marshallPackedDecimalIntoBuffer(double value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        MarshallPackedDecimal.marshallPackedDecimalIntoBuffer(bd, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallPackedDecimalIntoBuffer(float value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Float.toString(value));
        MarshallPackedDecimal.marshallPackedDecimalIntoBuffer(bd, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallPackedDecimalIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(value);
        MarshallPackedDecimal.marshallPackedDecimalIntoBuffer(bd, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallPackedDecimalIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = ConversionUtils.evaluateFormula((String)instanceTD.getSize());
        int virtualDecimalPoint = typeDescriptor.getVirtualDecimalPoint();
        boolean signed = typeDescriptor.getSigned();
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (int)size, (boolean)signed, (int)virtualDecimalPoint);
    }

    public static void marshallPackedDecimalIntoBuffer(byte value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallPackedDecimal.marshallPackedDecimalIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallPackedDecimalIntoBuffer(short value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallPackedDecimal.marshallPackedDecimalIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallPackedDecimalIntoBuffer(int value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallPackedDecimal.marshallPackedDecimalIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallPackedDecimalIntoBuffer(long value, byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = ConversionUtils.evaluateFormula((String)instanceTD.getSize());
        boolean signed = typeDescriptor.getSigned();
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer((long)value, (byte[])buffer, (int)startingOffset, (int)size, (boolean)signed);
    }

    public static byte unmarshalByteFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        byte result = (byte)MarshallPackedDecimal.unmarshalLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static short unmarshalShortFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        short result = (short)MarshallPackedDecimal.unmarshalLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static int unmarshalIntFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int result = (int)MarshallPackedDecimal.unmarshalLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static long unmarshalLongFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        long result = 0L;
        int size = ConversionUtils.evaluateFormula((String)instanceTD.getSize());
        result = MarshallPackedDecimalUtils.unmarshallLongFromBuffer((byte[])buffer, (int)startingOffset, (int)size);
        return result;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = ConversionUtils.evaluateFormula((String)instanceTD.getSize());
        int virtualDecimalPoint = typeDescriptor.getVirtualDecimalPoint();
        BigDecimal result = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer((byte[])buffer, (int)startingOffset, (int)size, (int)virtualDecimalPoint);
        return result;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigInteger result = MarshallPackedDecimal.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD).toBigInteger();
        return result;
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        double result = MarshallPackedDecimal.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD).doubleValue();
        return result;
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, PackedDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        float result = MarshallPackedDecimal.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD).floatValue();
        return result;
    }
}

