/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.util.MarshallIntegerUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallInteger {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static void marshallIntegerIntoBuffer(byte value, byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallInteger.marshallIntegerIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallIntegerIntoBuffer(short value, byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallInteger.marshallIntegerIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallIntegerIntoBuffer(int value, byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallInteger.marshallIntegerIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallIntegerIntoBuffer(long value, byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = MarshallParms.getSize(instanceTD);
        int signCoding = MarshallParms.getSignCoding(typeDescriptor);
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        switch (size) {
            case 1: {
                if (signed) {
                    MarshallIntegerUtils.marshallOneByteIntegerIntoBuffer((byte)((byte)value), (byte[])buffer, (int)startingOffset, (int)signCoding);
                    break;
                }
                MarshallIntegerUtils.marshallOneByteUnsignedIntegerIntoBuffer((short)((short)value), (byte[])buffer, (int)startingOffset, (int)signCoding);
                break;
            }
            case 2: {
                if (signed) {
                    MarshallIntegerUtils.marshallTwoByteIntegerIntoBuffer((short)((short)value), (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                    break;
                }
                MarshallIntegerUtils.marshallTwoByteUnsignedIntegerIntoBuffer((int)((int)value), (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                break;
            }
            case 4: {
                if (signed) {
                    MarshallIntegerUtils.marshallFourByteIntegerIntoBuffer((int)((int)value), (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                    break;
                }
                MarshallIntegerUtils.marshallFourByteUnsignedIntegerIntoBuffer((long)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                break;
            }
            case 8: {
                MarshallIntegerUtils.marshallEightByteIntegerIntoBuffer((long)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
    }

    public static void marshallIntegerIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallInteger.marshallIntegerIntoBuffer(new BigDecimal(value), buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallIntegerIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = MarshallParms.getSize(instanceTD);
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int signCoding = MarshallParms.getSignCoding(typeDescriptor);
        int virtualDecimalPt = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        switch (size) {
            case 1: {
                MarshallIntegerUtils.marshallOneByteIntegerIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (boolean)signed, (int)signCoding, (int)virtualDecimalPt);
                break;
            }
            case 2: {
                MarshallIntegerUtils.marshallTwoByteIntegerIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (boolean)signed, (boolean)isBigEndian, (int)signCoding, (int)virtualDecimalPt);
                break;
            }
            case 4: {
                MarshallIntegerUtils.marshallFourByteIntegerIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (boolean)signed, (boolean)isBigEndian, (int)signCoding, (int)virtualDecimalPt);
                break;
            }
            case 8: {
                MarshallIntegerUtils.marshallEightByteIntegerIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (boolean)signed, (boolean)isBigEndian, (int)signCoding, (int)virtualDecimalPt);
                break;
            }
            case 16: {
                MarshallIntegerUtils.marshallSixteenByteIntegerIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (boolean)signed, (boolean)isBigEndian, (int)signCoding, (int)virtualDecimalPt);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
    }

    public static byte unmarshallByteFromBuffer(byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        byte result = (byte)MarshallInteger.unmarshallLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static short unmarshallShortFromBuffer(byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        short result = (short)MarshallInteger.unmarshallLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static int unmarshallIntFromBuffer(byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int result = (int)MarshallInteger.unmarshallLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static long unmarshallLongFromBuffer(byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        long result = 0L;
        int size = MarshallParms.getSize(instanceTD);
        int signCoding = MarshallParms.getSignCoding(typeDescriptor);
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        switch (size) {
            case 1: {
                if (signed) {
                    result = MarshallIntegerUtils.unmarshallOneByteIntegerFromBuffer((byte[])buffer, (int)startingOffset, (int)signCoding);
                    break;
                }
                result = MarshallIntegerUtils.unmarshallOneByteUnsignedIntegerFromBuffer((byte[])buffer, (int)startingOffset, (int)signCoding);
                break;
            }
            case 2: {
                if (signed) {
                    result = MarshallIntegerUtils.unmarshallTwoByteIntegerFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                    break;
                }
                result = MarshallIntegerUtils.unmarshallTwoByteUnsignedIntegerFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                break;
            }
            case 4: {
                if (signed) {
                    result = MarshallIntegerUtils.unmarshallFourByteIntegerFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                    break;
                }
                result = MarshallIntegerUtils.unmarshallFourByteUnsignedIntegerFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                break;
            }
            case 8: {
                result = MarshallIntegerUtils.unmarshallEightByteIntegerFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)signCoding);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
        return result;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigInteger result = null;
        BigDecimal bdResult = MarshallInteger.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        result = bdResult.toBigInteger();
        return result;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, IntegerTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = MarshallParms.getSize(instanceTD);
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int signCoding = MarshallParms.getSignCoding(typeDescriptor);
        int virtualDecimalPt = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        BigDecimal result = MarshallIntegerUtils.unmarshallBigDecimalFromBuffer((byte[])buffer, (int)startingOffset, (int)size, (boolean)signed, (boolean)isBigEndian, (int)signCoding, (int)virtualDecimalPt);
        return result;
    }
}

